/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.repository.display.impl;

import java.sql.Timestamp;
import java.util.List;
import org.jooq.Condition;
import org.jooq.DSLContext;
import org.jooq.Field;
import org.jooq.GroupField;
import org.jooq.OrderField;
import org.jooq.Record4;
import org.jooq.SelectField;
import org.jooq.SelectHavingStep;
import org.jooq.TableLike;
import org.jooq.impl.DSL;
import org.springframework.stereotype.Repository;
import org.squashtest.tm.jooq.domain.Tables;
import org.squashtest.tm.service.internal.display.dto.requirement.RequirementVersionLinkDto;
import org.squashtest.tm.service.internal.repository.display.RequirementVersionLinkDisplayDao;

@Repository
public class RequirementVersionLinkDisplayDaoImpl
implements RequirementVersionLinkDisplayDao {
    private static final String MILESTONE_LABELS = "MILESTONE_LABELS";
    private static final String MILESTONE_MAX_DATE = "MILESTONE_MAX_DATE";
    private static final String MILESTONE_MIN_DATE = "MILESTONE_MIN_DATE";
    private static final String RES_ID = "RES_ID";
    private static final String ROLE = "ROLE";
    private final DSLContext dsl;

    public RequirementVersionLinkDisplayDaoImpl(DSLContext dsl) {
        this.dsl = dsl;
    }

    @Override
    public List<RequirementVersionLinkDto> findLinksByRequirementVersionId(Long reqVersionId) {
        SelectHavingStep<Record4<Long, Timestamp, Timestamp, String>> milestoneDates = this.getMilestoneDates();
        return this.dsl.select((SelectField)Tables.REQUIREMENT_VERSION.RES_ID.as("ID"), (SelectField)Tables.REQUIREMENT_VERSION.REFERENCE, (SelectField)Tables.REQUIREMENT_VERSION.VERSION_NUMBER, (SelectField)Tables.REQUIREMENT_VERSION.REQUIREMENT_ID, (SelectField)Tables.RESOURCE.NAME, (SelectField)Tables.PROJECT.NAME.as("PROJECT_NAME"), (SelectField)DSL.field((String)MILESTONE_LABELS), (SelectField)DSL.field((String)MILESTONE_MIN_DATE), (SelectField)DSL.field((String)MILESTONE_MAX_DATE), (SelectField)DSL.when((Condition)Tables.REQUIREMENT_VERSION_LINK.LINK_DIRECTION.eq((Object)true), (Field)Tables.REQUIREMENT_VERSION_LINK_TYPE.ROLE_1).otherwise((Field)Tables.REQUIREMENT_VERSION_LINK_TYPE.ROLE_2).as(ROLE)).from((TableLike)Tables.REQUIREMENT_VERSION_LINK).innerJoin((TableLike)Tables.REQUIREMENT_VERSION_LINK_TYPE).on(Tables.REQUIREMENT_VERSION_LINK.LINK_TYPE_ID.eq((Field)Tables.REQUIREMENT_VERSION_LINK_TYPE.TYPE_ID)).innerJoin((TableLike)Tables.REQUIREMENT_VERSION).on(Tables.REQUIREMENT_VERSION_LINK.RELATED_REQUIREMENT_VERSION_ID.eq((Field)Tables.REQUIREMENT_VERSION.RES_ID)).innerJoin((TableLike)Tables.RESOURCE).on(Tables.REQUIREMENT_VERSION.RES_ID.eq((Field)Tables.RESOURCE.RES_ID)).innerJoin((TableLike)Tables.REQUIREMENT_LIBRARY_NODE).on(Tables.REQUIREMENT_VERSION.REQUIREMENT_ID.eq((Field)Tables.REQUIREMENT_LIBRARY_NODE.RLN_ID)).innerJoin((TableLike)Tables.PROJECT).on(Tables.REQUIREMENT_LIBRARY_NODE.PROJECT_ID.eq((Field)Tables.PROJECT.PROJECT_ID)).leftJoin(milestoneDates).on(Tables.REQUIREMENT_VERSION.RES_ID.eq(milestoneDates.field(RES_ID, Long.class))).where(Tables.REQUIREMENT_VERSION_LINK.REQUIREMENT_VERSION_ID.eq((Object)reqVersionId)).orderBy((OrderField)Tables.REQUIREMENT_VERSION.RES_ID.as("ID")).fetchInto(RequirementVersionLinkDto.class);
    }

    private SelectHavingStep<Record4<Long, Timestamp, Timestamp, String>> getMilestoneDates() {
        return DSL.select((SelectField)Tables.REQUIREMENT_VERSION.RES_ID.as(RES_ID), (SelectField)DSL.min((Field)Tables.MILESTONE.END_DATE).as(MILESTONE_MIN_DATE), (SelectField)DSL.max((Field)Tables.MILESTONE.END_DATE).as(MILESTONE_MAX_DATE), (SelectField)DSL.listAgg((Field)Tables.MILESTONE.LABEL, (String)", ").withinGroupOrderBy(new OrderField[]{Tables.MILESTONE.END_DATE.asc()}).as(MILESTONE_LABELS)).from((TableLike)Tables.REQUIREMENT_VERSION).innerJoin((TableLike)Tables.MILESTONE_REQ_VERSION).on(Tables.REQUIREMENT_VERSION.RES_ID.eq((Field)Tables.MILESTONE_REQ_VERSION.REQ_VERSION_ID)).innerJoin((TableLike)Tables.MILESTONE).on(Tables.MILESTONE.MILESTONE_ID.eq((Field)Tables.MILESTONE_REQ_VERSION.MILESTONE_ID)).groupBy(new GroupField[]{Tables.REQUIREMENT_VERSION.RES_ID, Tables.MILESTONE_REQ_VERSION.REQ_VERSION_ID});
    }
}

