/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.dto;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.DatabindContext;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.jsontype.TypeIdResolver;
import com.fasterxml.jackson.databind.jsontype.impl.TypeIdResolverBase;
import com.fasterxml.jackson.databind.type.TypeFactory;
import org.squashtest.tm.domain.customfield.InputType;
import org.squashtest.tm.service.internal.dto.CustomFieldModel;
import org.squashtest.tm.service.internal.dto.CustomFieldModelFactory;

public class CustomFieldModelIdTypeResolver
extends TypeIdResolverBase
implements TypeIdResolver {
    private JavaType baseType;

    public void init(JavaType baseType) {
        this.baseType = baseType;
    }

    public JsonTypeInfo.Id getMechanism() {
        return JsonTypeInfo.Id.CUSTOM;
    }

    public String idFromValue(Object obj) {
        return this.idFromValueAndType(obj, obj.getClass());
    }

    public String idFromBaseType() {
        return null;
    }

    public String idFromValueAndType(Object obj, Class<?> clazz) {
        return ((CustomFieldModel)obj).getInputType().getEnumName();
    }

    public JavaType typeFromId(DatabindContext context, String type) {
        InputType enumType = InputType.valueOf((String)type);
        return switch (enumType) {
            case InputType.DATE_PICKER -> TypeFactory.defaultInstance().constructSpecializedType(this.baseType, CustomFieldModelFactory.DatePickerFieldModel.class);
            case InputType.DROPDOWN_LIST -> TypeFactory.defaultInstance().constructSpecializedType(this.baseType, CustomFieldModelFactory.SingleSelectFieldModel.class);
            case InputType.TAG -> TypeFactory.defaultInstance().constructSpecializedType(this.baseType, CustomFieldModelFactory.MultiSelectFieldModel.class);
            default -> TypeFactory.defaultInstance().constructSpecializedType(this.baseType, CustomFieldModelFactory.SingleValuedCustomFieldModel.class);
        };
    }
}

