/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.display.grid.campaign;

import java.util.ArrayList;
import org.jooq.DSLContext;
import org.jooq.Field;
import org.jooq.Record;
import org.jooq.Table;
import org.springframework.context.MessageSource;
import org.squashtest.tm.api.security.acls.Permissions;
import org.squashtest.tm.jooq.domain.Tables;
import org.squashtest.tm.jooq.domain.tables.AutomatedSuite;
import org.squashtest.tm.service.internal.display.grid.GridRequest;
import org.squashtest.tm.service.internal.display.grid.campaign.AbstractAutomatedSuiteGrid;
import org.squashtest.tm.service.internal.repository.display.AutomatedSuiteDisplayDao;
import org.squashtest.tm.service.internal.repository.display.impl.AutomatedSuiteDisplayDaoImpl;
import org.squashtest.tm.service.security.PermissionEvaluationService;

public class TestSuiteAutomatedSuiteGrid
extends AbstractAutomatedSuiteGrid {
    private final PermissionEvaluationService permissionEvaluationService;

    public TestSuiteAutomatedSuiteGrid(Long testSuiteId, MessageSource messageSource, AutomatedSuiteDisplayDao automatedSuiteDisplayDao, PermissionEvaluationService permissionEvaluationService) {
        super(testSuiteId, messageSource, automatedSuiteDisplayDao);
        this.permissionEvaluationService = permissionEvaluationService;
    }

    @Override
    protected Long countRows(DSLContext dslContext, GridRequest request) {
        if (request.getFilterValues().isEmpty() && this.currentUserCanReadUnassigned(this.holderId)) {
            return this.automatedSuiteDisplayDao.countAutomatedSuiteByTestSuiteId(this.holderId);
        }
        return super.countRows(dslContext, request);
    }

    @Override
    protected Table<Record> getAutomatedSuiteTable() {
        ArrayList fields = new ArrayList(this.getSuiteFields());
        fields.add(Tables.ITERATION_TEST_SUITE.ITERATION_ID.as(AbstractAutomatedSuiteGrid.suiteHolderIdField));
        return AutomatedSuiteDisplayDaoImpl.getAutomatedSuiteTableByTestSuiteId(this.holderId, fields);
    }

    @Override
    protected Field<Long> getAutomatedSuiteHolderField() {
        return AutomatedSuite.AUTOMATED_SUITE.TEST_SUITE_ID;
    }

    private boolean currentUserCanReadUnassigned(Long testSuiteId) {
        return this.permissionEvaluationService.hasRoleOrPermissionOnObject("ROLE_ADMIN", Permissions.READ_UNASSIGNED.name(), testSuiteId, "org.squashtest.tm.domain.campaign.TestSuite");
    }
}

