/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.dto;

import java.util.List;
import java.util.Objects;
import org.squashtest.tm.domain.testcase.ActionTestStep;
import org.squashtest.tm.domain.testcase.TestCase;
import org.squashtest.tm.domain.testcase.TestStep;
import org.squashtest.tm.service.internal.dto.ActionTestStepFromAiDto;

public class TestCaseFromAiDto {
    private String name;
    private String description;
    private String prerequisites;
    private List<ActionTestStepFromAiDto> testSteps;

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getPrerequisites() {
        return this.prerequisites;
    }

    public void setPrerequisites(String prerequisites) {
        this.prerequisites = prerequisites;
    }

    public List<ActionTestStepFromAiDto> getTestSteps() {
        return this.testSteps;
    }

    public void setTestSteps(List<ActionTestStepFromAiDto> testSteps) {
        this.testSteps = testSteps;
    }

    public TestCase toTestCase(List<String> parentContentNames) {
        TestCase newTestCase = new TestCase();
        this.fixTestCaseDuplicationNames(newTestCase, this.name, parentContentNames);
        newTestCase.setDescription(this.description);
        newTestCase.setPrerequisite(Objects.requireNonNullElse(this.prerequisites, ""));
        for (ActionTestStepFromAiDto actionStep : this.testSteps) {
            ActionTestStep newStep = new ActionTestStep();
            newStep.setAction(actionStep.getAction());
            newStep.setExpectedResult(actionStep.getExpectedResult());
            newTestCase.addStep(actionStep.getIndex(), (TestStep)newStep);
        }
        newTestCase.setDraftedByAi(true);
        return newTestCase;
    }

    private void fixTestCaseDuplicationNames(TestCase testCase, String name, List<String> parentContentNames) {
        int i = 0;
        Object uniqueName = name;
        while (parentContentNames.contains(uniqueName)) {
            uniqueName = name + "(" + ++i + ")";
        }
        testCase.setName((String)uniqueName);
        parentContentNames.add((String)uniqueName);
    }
}

