/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.display.campaign;

import org.springframework.stereotype.Component;
import org.squashtest.tm.service.security.PermissionEvaluationService;
import org.squashtest.tm.service.security.UserContextService;

@Component
public class ReadUnassignedTestPlanHelper {
    static final String READ_UNASSIGNED = "READ_UNASSIGNED";
    private final PermissionEvaluationService permissionEvaluationService;
    private final UserContextService userContextService;

    public ReadUnassignedTestPlanHelper(PermissionEvaluationService permissionEvaluationService, UserContextService userContextService) {
        this.permissionEvaluationService = permissionEvaluationService;
        this.userContextService = userContextService;
    }

    public String getUserToRestrictTo(Long testPlanOwnerEntityId, String testPlanOwnerClassName) {
        boolean readUnassigned = this.currentUserCanReadUnassigned(testPlanOwnerEntityId, testPlanOwnerClassName);
        if (!readUnassigned) {
            return this.userContextService.getUsername();
        }
        return null;
    }

    private boolean currentUserCanReadUnassigned(Long testPlanOwnerId, String testPlanOwnerClassName) {
        return this.permissionEvaluationService.hasRoleOrPermissionOnObject("ROLE_ADMIN", READ_UNASSIGNED, testPlanOwnerId, testPlanOwnerClassName);
    }
}

