/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.customreport.export;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import org.jooq.Condition;
import org.jooq.DSLContext;
import org.jooq.Field;
import org.jooq.GroupField;
import org.jooq.OrderField;
import org.jooq.Record;
import org.jooq.Record3;
import org.jooq.Record6;
import org.jooq.ResultQuery;
import org.jooq.Select;
import org.jooq.SelectField;
import org.jooq.SelectJoinStep;
import org.jooq.Table;
import org.jooq.TableLike;
import org.jooq.impl.DSL;
import org.springframework.stereotype.Repository;
import org.squashtest.tm.core.foundation.lang.DateUtils;
import org.squashtest.tm.domain.EntityReference;
import org.squashtest.tm.domain.EntityType;
import org.squashtest.tm.domain.customfield.CustomFieldValueType;
import org.squashtest.tm.domain.customfield.InputType;
import org.squashtest.tm.domain.customreport.CustomExportColumnLabel;
import org.squashtest.tm.domain.customreport.CustomReportCustomExport;
import org.squashtest.tm.domain.customreport.CustomReportCustomExportColumn;
import org.squashtest.tm.jooq.domain.Tables;
import org.squashtest.tm.service.customreport.export.CustomReportExportDao;
import org.squashtest.tm.service.internal.attachment.AttachmentHelper;
import org.squashtest.tm.service.internal.dto.CustomFieldValueDto;
import org.squashtest.tm.service.internal.dto.NumericCufHelper;
import org.squashtest.tm.service.internal.jooq.SubElementRecordProcessor;

@Repository
public class CustomReportExportDaoImpl
implements CustomReportExportDao {
    protected static final Integer BATCH_SIZE = 200;
    private static final Field<Integer> EXECUTION_POSITION_FIELD = DSL.field((String)"execution_position", Integer.class);
    private static final Field<Long> CUF_VALUE_ID = DSL.field((String)"cuf_value_id", Long.class);
    private final DSLContext dsl;

    public CustomReportExportDaoImpl(DSLContext dsl) {
        this.dsl = dsl;
    }

    @Override
    public Map<Long, List<String>> getExecutionStatusByCampaignId(Set<Long> campaignIds) {
        return this.dsl.select((SelectField)Tables.CAMPAIGN_ITERATION.CAMPAIGN_ID, (SelectField)Tables.TEST_PLAN_ITEM.EXECUTION_STATUS).from((TableLike)Tables.CAMPAIGN_ITERATION).join((TableLike)Tables.ITERATION).on(Tables.ITERATION.ITERATION_ID.eq((Field)Tables.CAMPAIGN_ITERATION.ITERATION_ID)).join((TableLike)Tables.TEST_PLAN_ITEM).on(Tables.TEST_PLAN_ITEM.TEST_PLAN_ID.eq((Field)Tables.ITERATION.TEST_PLAN_ID)).where(Tables.CAMPAIGN_ITERATION.CAMPAIGN_ID.in(campaignIds)).fetchGroups((Field)Tables.CAMPAIGN_ITERATION.CAMPAIGN_ID, (Field)Tables.TEST_PLAN_ITEM.EXECUTION_STATUS);
    }

    @Override
    public Set<Long> getSelectedCampaignIds(CustomReportCustomExport customExport) {
        HashSet<EntityType> entityTypes = new HashSet<EntityType>();
        QueryConfiguration queryConfiguration = new QueryConfiguration();
        queryConfiguration.selectFields().add((Field<?>)Tables.CAMPAIGN.CLN_ID);
        Map<Field<?>, List<Long>> selectableIdsByField = this.computeSelectableIdsByField(customExport, entityTypes);
        queryConfiguration.columnEntityTypes().addAll(entityTypes);
        return new QueryBuilder().withColumnEntityTypes(queryConfiguration.columnEntityTypes()).withSelectFields(queryConfiguration.selectFields()).withConditionFields(selectableIdsByField).buildBasicQuery().fetchSet((Field)Tables.CAMPAIGN.CLN_ID);
    }

    private Map<Field<?>, List<Long>> computeSelectableIdsByField(CustomReportCustomExport customExport, Set<EntityType> entityTypes) {
        return customExport.getScope().stream().collect(Collectors.groupingBy(ref -> this.computeSelectableField((EntityReference)ref, entityTypes), Collectors.mapping(EntityReference::getId, Collectors.toList())));
    }

    private Field<?> computeSelectableField(EntityReference entityReference, Set<EntityType> entityTypes) {
        Field selectedColumn = (Field)CustomExportColumnLabel.getSelectableEntityTypeToIdTableFieldMap().get(entityReference.getType());
        if (Objects.isNull(selectedColumn)) {
            throw new IllegalArgumentException("Entity of type " + entityReference.getType().name() + " is not supported");
        }
        entityTypes.add(entityReference.getType());
        return selectedColumn;
    }

    @Override
    public Map<EntityType, SubElementRecordProcessor<CustomFieldValueDto>> getCufQueryByEntityType(Collection<Long> campaignIds, Map<EntityType, List<Long>> cufIdsByEntityType) {
        return cufIdsByEntityType.entrySet().stream().filter(e -> !((List)e.getValue()).isEmpty()).collect(Collectors.toMap(Map.Entry::getKey, entry -> this.getCufProcessor((EntityType)entry.getKey(), campaignIds, (Collection)entry.getValue())));
    }

    private SubElementRecordProcessor<CustomFieldValueDto> getCufProcessor(EntityType entityType, Collection<Long> campaignIds, Collection<Long> cufIds) {
        ResultQuery<Record6<Long, Long, Long, String, String, String>> query = this.getCufQuery(entityType, campaignIds, cufIds);
        return new SubElementRecordProcessor<CustomFieldValueDto>(query, (Field<Long>)DSL.field((String)"ID", Long.class), CUF_VALUE_ID, r -> this.toCustomFieldDto((Record)r, entityType), CustomFieldValueDto.class);
    }

    private CustomFieldValueDto toCustomFieldDto(Record record, EntityType entityType) {
        if (EntityType.TEST_STEP.equals((Object)entityType)) {
            return this.toCustomFieldDto(record, (String)record.get((Field)Tables.DENORMALIZED_FIELD_VALUE.VALUE), (String)record.get((Field)Tables.DENORMALIZED_FIELD_VALUE.FIELD_TYPE));
        }
        return this.toCustomFieldDto(record, (String)record.get((Field)Tables.CUSTOM_FIELD_VALUE.VALUE), (String)record.get((Field)Tables.CUSTOM_FIELD_VALUE.FIELD_TYPE));
    }

    private CustomFieldValueDto toCustomFieldDto(Record record, String rawValue, String fieldType) {
        String value = CustomFieldValueType.NUM.name().equals(fieldType) ? NumericCufHelper.formatOutputNumericCufValue(rawValue) : (CustomFieldValueType.RTF.name().equals(fieldType) ? AttachmentHelper.adaptHtmlImageExport(rawValue) : (InputType.DATE_PICKER.equals((Object)InputType.valueOf((String)((String)record.get((Field)Tables.CUSTOM_FIELD.INPUT_TYPE)))) ? DateUtils.formatCufDate((String)rawValue) : rawValue));
        return new CustomFieldValueDto((Long)record.get(CUF_VALUE_ID), (Long)record.get(DSL.field((String)"ID", Long.class)), (Long)record.get((Field)Tables.CUSTOM_FIELD_VALUE.CF_ID), value);
    }

    private ResultQuery<Record6<Long, Long, Long, String, String, String>> getCufQuery(EntityType entityType, Collection<Long> campaignIds, Collection<Long> cufIds) {
        Set<Field<?>> sortedFields = QueryBuilder.getDefaultOrderFields(Set.of(entityType));
        Field entityIdField = (Field)CustomExportColumnLabel.getEntityTypeToIdTableFieldMap().get(entityType);
        HashSet selectedFields = new HashSet(sortedFields);
        selectedFields.add(entityIdField);
        Table entityTable = new QueryBuilder().withColumnEntityTypes(Set.of(entityType)).withSelectFields(selectedFields).withCampaignIds(campaignIds).withGroupingFields(Set.of(entityIdField)).withoutOrdering().build().asTable();
        Set<Field<?>> orderAliasFields = sortedFields.stream().map(arg_0 -> ((Table)entityTable).field(arg_0)).filter(Objects::nonNull).collect(Collectors.toSet());
        if (EntityType.TEST_STEP.equals((Object)entityType)) {
            return this.getTestStepDenormalizedQuery((Table<Record>)entityTable, (Field<Long>)entityIdField, orderAliasFields, cufIds);
        }
        return this.getCufQuery((Table<Record>)entityTable, (Field<Long>)entityIdField, orderAliasFields, entityType, cufIds);
    }

    private ResultQuery<Record6<Long, Long, Long, String, String, String>> getCufQuery(Table<Record> entityTable, Field<Long> entityIdField, Collection<Field<?>> orderFields, EntityType entityType, Collection<Long> cufIds) {
        ArrayList<Object> groupByFields = new ArrayList<Object>();
        groupByFields.add(entityTable.field(entityIdField));
        groupByFields.add(Tables.CUSTOM_FIELD_VALUE.CFV_ID);
        groupByFields.add(Tables.CUSTOM_FIELD_VALUE.FIELD_TYPE);
        groupByFields.add(Tables.CUSTOM_FIELD.CF_ID);
        groupByFields.addAll(orderFields);
        return this.dsl.select((SelectField)Tables.CUSTOM_FIELD_VALUE.BOUND_ENTITY_ID.as("ID"), (SelectField)Tables.CUSTOM_FIELD_VALUE.CFV_ID.as(CUF_VALUE_ID), (SelectField)Tables.CUSTOM_FIELD_VALUE.CF_ID, (SelectField)Tables.CUSTOM_FIELD_VALUE.FIELD_TYPE, (SelectField)Tables.CUSTOM_FIELD.INPUT_TYPE, (SelectField)DSL.when((Condition)Tables.CUSTOM_FIELD_VALUE.FIELD_TYPE.eq((Object)CustomFieldValueType.CF.name()), (Field)CustomFieldValueType.CF.getValueColumn()).when(Tables.CUSTOM_FIELD_VALUE.FIELD_TYPE.eq((Object)CustomFieldValueType.RTF.name()), CustomFieldValueType.RTF.getValueColumn()).when(Tables.CUSTOM_FIELD_VALUE.FIELD_TYPE.eq((Object)CustomFieldValueType.NUM.name()), DSL.coalesce((Field)CustomFieldValueType.NUM.getValueColumn(), (Object)"")).when(Tables.CUSTOM_FIELD_VALUE.FIELD_TYPE.eq((Object)CustomFieldValueType.TAG.name()), (Field)DSL.groupConcat((Field)CustomFieldValueType.TAG.getValueColumn()).separator(", ")).otherwise((Object)"").as((Field)Tables.CUSTOM_FIELD_VALUE.VALUE)).from(entityTable).join((TableLike)Tables.CUSTOM_FIELD_VALUE).on(Tables.CUSTOM_FIELD_VALUE.BOUND_ENTITY_ID.eq(entityTable.field(entityIdField))).join((TableLike)Tables.CUSTOM_FIELD).on(Tables.CUSTOM_FIELD_VALUE.CF_ID.eq((Field)Tables.CUSTOM_FIELD.CF_ID)).leftJoin((TableLike)Tables.CUSTOM_FIELD_VALUE_OPTION).on(Tables.CUSTOM_FIELD_VALUE_OPTION.CFV_ID.eq((Field)Tables.CUSTOM_FIELD_VALUE.CFV_ID)).where(Tables.CUSTOM_FIELD_VALUE.CF_ID.in(cufIds)).and(Tables.CUSTOM_FIELD_VALUE.BOUND_ENTITY_TYPE.eq((Object)entityType.name())).groupBy(groupByFields).orderBy(orderFields).fetchSize(BATCH_SIZE.intValue());
    }

    private ResultQuery<Record6<Long, Long, Long, String, String, String>> getTestStepDenormalizedQuery(Table<Record> entityTable, Field<Long> entityIdField, Collection<Field<?>> orderFields, Collection<Long> cufIds) {
        ArrayList<Object> groupByFields = new ArrayList<Object>();
        groupByFields.add(entityTable.field(entityIdField));
        groupByFields.add(Tables.DENORMALIZED_FIELD_VALUE.DFV_ID);
        groupByFields.add(Tables.CUSTOM_FIELD_VALUE.CF_ID);
        groupByFields.add(Tables.DENORMALIZED_FIELD_VALUE.FIELD_TYPE);
        groupByFields.add(Tables.CUSTOM_FIELD.CF_ID);
        groupByFields.addAll(orderFields);
        return this.dsl.select((SelectField)Objects.requireNonNull(entityTable.field(entityIdField)).as("ID"), (SelectField)Tables.DENORMALIZED_FIELD_VALUE.DFV_ID.as(CUF_VALUE_ID), (SelectField)Tables.CUSTOM_FIELD_VALUE.CF_ID, (SelectField)Tables.DENORMALIZED_FIELD_VALUE.FIELD_TYPE, (SelectField)Tables.CUSTOM_FIELD.INPUT_TYPE, (SelectField)DSL.when((Condition)Tables.DENORMALIZED_FIELD_VALUE.FIELD_TYPE.eq((Object)CustomFieldValueType.CF.name()), (Field)CustomFieldValueType.CF.getDenormalizedColumn()).when(Tables.DENORMALIZED_FIELD_VALUE.FIELD_TYPE.eq((Object)CustomFieldValueType.RTF.name()), CustomFieldValueType.RTF.getDenormalizedColumn()).when(Tables.DENORMALIZED_FIELD_VALUE.FIELD_TYPE.eq((Object)CustomFieldValueType.NUM.name()), DSL.coalesce((Field)CustomFieldValueType.NUM.getDenormalizedColumn(), (Object)"")).when(Tables.DENORMALIZED_FIELD_VALUE.FIELD_TYPE.eq((Object)CustomFieldValueType.TAG.name()), (Field)DSL.groupConcat((Field)CustomFieldValueType.TAG.getDenormalizedColumn()).separator(", ")).otherwise((Object)"").as((Field)Tables.DENORMALIZED_FIELD_VALUE.VALUE)).from(entityTable).join((TableLike)Tables.EXECUTION_STEP).on(Tables.EXECUTION_STEP.TEST_STEP_ID.eq(entityTable.field(entityIdField))).join((TableLike)Tables.DENORMALIZED_FIELD_VALUE).on(Tables.DENORMALIZED_FIELD_VALUE.DENORMALIZED_FIELD_HOLDER_ID.eq((Field)Tables.EXECUTION_STEP.EXECUTION_STEP_ID)).leftJoin((TableLike)Tables.DENORMALIZED_FIELD_VALUE_OPTION).on(Tables.DENORMALIZED_FIELD_VALUE_OPTION.DFV_ID.eq((Field)Tables.DENORMALIZED_FIELD_VALUE.DFV_ID)).join((TableLike)Tables.CUSTOM_FIELD_VALUE).on(Tables.CUSTOM_FIELD_VALUE.CFV_ID.eq((Field)Tables.DENORMALIZED_FIELD_VALUE.CFV_ID)).join((TableLike)Tables.CUSTOM_FIELD).on(Tables.CUSTOM_FIELD_VALUE.CF_ID.eq((Field)Tables.CUSTOM_FIELD.CF_ID)).where(Tables.CUSTOM_FIELD_VALUE.CF_ID.in(cufIds)).and(Tables.DENORMALIZED_FIELD_VALUE.DENORMALIZED_FIELD_HOLDER_TYPE.eq((Object)EntityType.EXECUTION_STEP.name())).groupBy(groupByFields).orderBy(orderFields).fetchSize(BATCH_SIZE.intValue());
    }

    @Override
    public ResultQuery<Record> getExportQuery(Collection<Long> campaignIds, Collection<CustomReportCustomExportColumn> selectedColumns, Map<EntityType, List<Long>> cufIdsByEntityType, boolean onlyLastExecution) {
        QueryConfiguration queryConfiguration = QueryConfiguration.toMainQuery(selectedColumns, cufIdsByEntityType);
        return new QueryBuilder().withColumnEntityTypes(queryConfiguration.columnEntityTypes()).withGroupingFields(queryConfiguration.pkFields()).withSelectFields(queryConfiguration.selectFields()).withCampaignIds(campaignIds).withOnlyLastExecution(onlyLastExecution).build().fetchSize(BATCH_SIZE.intValue());
    }

    private final class QueryBuilder {
        private static final Map<EntityType, Integer> ENTITY_TYPE_DEPTH = Map.of(EntityType.ISSUE, 6, EntityType.EXECUTION_STEP, 5, EntityType.TEST_STEP, 5, EntityType.EXECUTION, 4, EntityType.TEST_CASE, 3, EntityType.TEST_SUITE, 3, EntityType.ITERATION, 2);
        private static final Map<Integer, Function<QueryBuilder, UnaryOperator<SelectJoinStep<Record>>>> MAIN_JOIN_STRATEGIES = Map.of(2, qb -> qb::joinIteration, 3, qb -> qb::joinTestPlanItem, 4, qb -> qb::joinExecution, 5, qb -> qb::joinExecutionStep);
        private static final Map<EntityType, Function<QueryBuilder, UnaryOperator<SelectJoinStep<Record>>>> OPT_JOIN_STRATEGIES = Map.of(EntityType.CAMPAIGN_FOLDER, qb -> qb::joinCampaignFolder, EntityType.MILESTONE, qb -> qb::joinCampaignMilestone, EntityType.TEST_SUITE, qb -> qb::joinTestSuite, EntityType.TEST_CASE, qb -> qb::joinTestCase);
        private static final Map<Integer, Field<Long>> SORTING_FIELDS_BY_DEPTH = Map.of(5, Tables.EXECUTION_STEP.EXECUTION_STEP_ID, 4, Tables.EXECUTION.EXECUTION_ID, 3, Tables.TEST_PLAN_ITEM.TEST_PLAN_ITEM_ID, 2, Tables.ITERATION.ITERATION_ID);
        private Collection<EntityType> columnEntityTypes = Collections.emptyList();
        private Collection<Field<?>> selectFields = Collections.emptyList();
        private Collection<Field<?>> groupingFields = Collections.emptyList();
        private Map<Field<?>, List<Long>> idsByConditionField = Collections.emptyMap();
        private Collection<Long> campaignIds = Collections.emptyList();
        private boolean onlyLastExecution = false;
        private boolean orderingFields = true;

        private QueryBuilder() {
        }

        public QueryBuilder withColumnEntityTypes(Collection<EntityType> columnEntityTypes) {
            this.columnEntityTypes = columnEntityTypes;
            return this;
        }

        private QueryBuilder withSelectFields(Collection<Field<?>> selectFields) {
            this.selectFields = selectFields;
            return this;
        }

        private QueryBuilder withGroupingFields(Collection<Field<?>> pkFields) {
            this.groupingFields = pkFields;
            return this;
        }

        private QueryBuilder withConditionFields(Map<Field<?>, List<Long>> idsByConditionField) {
            this.idsByConditionField = idsByConditionField;
            return this;
        }

        private QueryBuilder withCampaignIds(Collection<Long> campaignIds) {
            this.campaignIds = campaignIds;
            return this;
        }

        private QueryBuilder withOnlyLastExecution(boolean onlyLastExecution) {
            this.onlyLastExecution = onlyLastExecution;
            return this;
        }

        private QueryBuilder withoutOrdering() {
            this.orderingFields = false;
            return this;
        }

        private static Set<Field<?>> getDefaultOrderFields(Set<EntityType> columnEntityTypes) {
            int queryDepth = QueryBuilder.getQueryDepth(columnEntityTypes);
            return QueryBuilder.getGroupOrderFields(queryDepth, columnEntityTypes);
        }

        private Select<Record> buildBasicQuery() {
            int queryDepth = QueryBuilder.getQueryDepth(this.columnEntityTypes);
            SelectJoinStep<Record> query = this.getMainQuery(queryDepth);
            this.appendOptionalJoins(query);
            return query.where(DSL.or(this.getConditions()));
        }

        private Select<Record> build() {
            int queryDepth = QueryBuilder.getQueryDepth(this.columnEntityTypes);
            SelectJoinStep<Record> query = this.getMainQuery(queryDepth);
            this.appendOptionalJoins(query);
            return query.where(this.getConditions()).groupBy(this.getGroupingFields(queryDepth)).orderBy(this.buildOrderingFields(queryDepth));
        }

        private static int getQueryDepth(Collection<EntityType> columnEntityTypes) {
            return columnEntityTypes.stream().map(entityType -> ENTITY_TYPE_DEPTH.getOrDefault(entityType, 1)).max(Integer::compareTo).orElse(1);
        }

        private SelectJoinStep<Record> getMainQuery(int depth) {
            SelectJoinStep query = this.campaignJoin();
            int level = 2;
            while (level <= depth && level <= 5) {
                UnaryOperator<SelectJoinStep<Record>> joinFunction = MAIN_JOIN_STRATEGIES.get(level).apply(this);
                query = (SelectJoinStep)joinFunction.apply(query);
                ++level;
            }
            return query;
        }

        private void appendOptionalJoins(SelectJoinStep<Record> fromQuery) {
            SelectJoinStep query = fromQuery;
            for (EntityType entityType : this.columnEntityTypes) {
                if (!OPT_JOIN_STRATEGIES.containsKey(entityType)) continue;
                UnaryOperator<SelectJoinStep<Record>> joinFunction = OPT_JOIN_STRATEGIES.get(entityType).apply(this);
                query = (SelectJoinStep)joinFunction.apply(query);
            }
        }

        private List<Condition> getConditions() {
            if (this.campaignIds.isEmpty()) {
                return this.idsByConditionField.entrySet().stream().map(entry -> ((Field)entry.getKey()).in((Collection)entry.getValue())).toList();
            }
            return List.of(Tables.CAMPAIGN.CLN_ID.in(this.campaignIds));
        }

        private Set<Field<?>> getGroupingFields(int depth) {
            Set<Field<?>> fields = QueryBuilder.getGroupOrderFields(depth, this.columnEntityTypes);
            fields.addAll(this.groupingFields);
            return fields;
        }

        private Set<Field<?>> buildOrderingFields(int depth) {
            if (!this.orderingFields) {
                return Collections.emptySet();
            }
            return QueryBuilder.getGroupOrderFields(depth, this.columnEntityTypes);
        }

        private static Set<Field<?>> getGroupOrderFields(int depth, Collection<EntityType> columnEntityTypes) {
            LinkedHashSet fields = new LinkedHashSet();
            fields.add((Field<?>)Tables.CAMPAIGN_LIBRARY_NODE.PROJECT_ID);
            fields.add((Field<?>)Tables.CAMPAIGN.CLN_ID);
            int level = 2;
            while (level <= depth && level <= 5) {
                if (level == 3 && columnEntityTypes.contains(EntityType.TEST_SUITE)) {
                    fields.add((Field<?>)Tables.TEST_SUITE.ID);
                }
                fields.add(SORTING_FIELDS_BY_DEPTH.get(level));
                ++level;
            }
            return fields;
        }

        private SelectJoinStep<Record> campaignJoin() {
            return CustomReportExportDaoImpl.this.dsl.select(this.selectFields).from((TableLike)Tables.CAMPAIGN).join((TableLike)Tables.CAMPAIGN_LIBRARY_NODE).on(Tables.CAMPAIGN_LIBRARY_NODE.CLN_ID.eq((Field)Tables.CAMPAIGN.CLN_ID));
        }

        private SelectJoinStep<Record> joinIteration(SelectJoinStep<Record> fromQuery) {
            return fromQuery.leftJoin((TableLike)Tables.CAMPAIGN_ITERATION).on(Tables.CAMPAIGN_ITERATION.CAMPAIGN_ID.eq((Field)Tables.CAMPAIGN.CLN_ID)).leftJoin((TableLike)Tables.ITERATION).on(Tables.ITERATION.ITERATION_ID.eq((Field)Tables.CAMPAIGN_ITERATION.ITERATION_ID));
        }

        private SelectJoinStep<Record> joinTestPlanItem(SelectJoinStep<Record> fromQuery) {
            return fromQuery.leftJoin((TableLike)Tables.TEST_PLAN_ITEM).on(Tables.TEST_PLAN_ITEM.TEST_PLAN_ID.eq((Field)Tables.ITERATION.TEST_PLAN_ID));
        }

        private SelectJoinStep<Record> joinExecution(SelectJoinStep<Record> fromQuery) {
            if (this.onlyLastExecution) {
                Table<Record3<Long, Long, Integer>> lastestExecutionTable = this.getLastestExecution();
                return fromQuery.leftJoin(lastestExecutionTable).on(Tables.TEST_PLAN_ITEM.TEST_PLAN_ITEM_ID.eq(lastestExecutionTable.field((Field)Tables.EXECUTION.TEST_PLAN_ITEM_ID)).and(EXECUTION_POSITION_FIELD.eq((Object)1))).leftJoin((TableLike)Tables.EXECUTION).on(Tables.EXECUTION.EXECUTION_ID.eq(lastestExecutionTable.field((Field)Tables.EXECUTION.EXECUTION_ID)));
            }
            return fromQuery.leftJoin((TableLike)Tables.EXECUTION).on(Tables.EXECUTION.TEST_PLAN_ITEM_ID.eq((Field)Tables.TEST_PLAN_ITEM.TEST_PLAN_ITEM_ID));
        }

        private Table<Record3<Long, Long, Integer>> getLastestExecution() {
            return DSL.select((SelectField)Tables.EXECUTION.EXECUTION_ID, (SelectField)Tables.EXECUTION.TEST_PLAN_ITEM_ID, (SelectField)DSL.rowNumber().over().partitionBy(new GroupField[]{Tables.EXECUTION.TEST_PLAN_ITEM_ID}).orderBy(new OrderField[]{Tables.EXECUTION.EXECUTION_ORDER.desc()}).as(EXECUTION_POSITION_FIELD)).from((TableLike)Tables.CAMPAIGN_ITERATION).join((TableLike)Tables.ITERATION).on(Tables.ITERATION.ITERATION_ID.eq((Field)Tables.CAMPAIGN_ITERATION.ITERATION_ID)).join((TableLike)Tables.TEST_PLAN_ITEM).on(Tables.TEST_PLAN_ITEM.TEST_PLAN_ID.eq((Field)Tables.ITERATION.TEST_PLAN_ID)).join((TableLike)Tables.EXECUTION).on(Tables.EXECUTION.TEST_PLAN_ITEM_ID.eq((Field)Tables.TEST_PLAN_ITEM.TEST_PLAN_ITEM_ID)).where(Tables.CAMPAIGN_ITERATION.CAMPAIGN_ID.in(this.campaignIds)).asTable();
        }

        private SelectJoinStep<Record> joinExecutionStep(SelectJoinStep<Record> fromQuery) {
            return fromQuery.leftJoin((TableLike)Tables.EXECUTION_EXECUTION_STEPS).on(Tables.EXECUTION_EXECUTION_STEPS.EXECUTION_ID.eq((Field)Tables.EXECUTION.EXECUTION_ID)).leftJoin((TableLike)Tables.EXECUTION_STEP).on(Tables.EXECUTION_STEP.EXECUTION_STEP_ID.eq((Field)Tables.EXECUTION_EXECUTION_STEPS.EXECUTION_STEP_ID));
        }

        private SelectJoinStep<Record> joinCampaignFolder(SelectJoinStep<Record> fromQuery) {
            return fromQuery.leftJoin((TableLike)Tables.CLN_RELATIONSHIP_CLOSURE).on(Tables.CLN_RELATIONSHIP_CLOSURE.DESCENDANT_ID.eq((Field)Tables.CAMPAIGN.CLN_ID)).leftJoin((TableLike)Tables.CAMPAIGN_FOLDER).on(Tables.CAMPAIGN_FOLDER.CLN_ID.eq((Field)Tables.CLN_RELATIONSHIP_CLOSURE.ANCESTOR_ID));
        }

        private SelectJoinStep<Record> joinCampaignMilestone(SelectJoinStep<Record> fromQuery) {
            return fromQuery.leftJoin((TableLike)Tables.MILESTONE_CAMPAIGN).on(Tables.MILESTONE_CAMPAIGN.CAMPAIGN_ID.eq((Field)Tables.CAMPAIGN.CLN_ID)).leftJoin((TableLike)Tables.MILESTONE).on(Tables.MILESTONE.MILESTONE_ID.eq((Field)Tables.MILESTONE_CAMPAIGN.MILESTONE_ID));
        }

        private SelectJoinStep<Record> joinTestSuite(SelectJoinStep<Record> fromQuery) {
            return fromQuery.leftJoin((TableLike)Tables.TEST_SUITE_TEST_PLAN_ITEM).on(Tables.TEST_SUITE_TEST_PLAN_ITEM.TPI_ID.eq((Field)Tables.TEST_PLAN_ITEM.TEST_PLAN_ITEM_ID)).leftJoin((TableLike)Tables.TEST_SUITE).on(Tables.TEST_SUITE.ID.eq((Field)Tables.TEST_SUITE_TEST_PLAN_ITEM.SUITE_ID));
        }

        private SelectJoinStep<Record> joinTestCase(SelectJoinStep<Record> fromQuery) {
            return fromQuery.leftJoin((TableLike)Tables.DATASET).on(Tables.DATASET.DATASET_ID.eq((Field)Tables.TEST_PLAN_ITEM.DATASET_ID)).leftJoin((TableLike)Tables.TEST_CASE).on(Tables.TEST_CASE.TCLN_ID.eq((Field)Tables.TEST_PLAN_ITEM.TCLN_ID)).leftJoin((TableLike)Tables.TEST_CASE_LIBRARY_NODE).on(Tables.TEST_CASE_LIBRARY_NODE.TCLN_ID.eq((Field)Tables.TEST_CASE.TCLN_ID)).leftJoin((TableLike)Tables.PROJECT).on(Tables.PROJECT.TCL_ID.eq((Field)Tables.TEST_CASE_LIBRARY_NODE.PROJECT_ID)).leftJoin((TableLike)Tables.INFO_LIST_ITEM.as("type_list")).on(Tables.INFO_LIST_ITEM.as((String)"type_list").ITEM_ID.eq((Field)Tables.TEST_CASE.TC_TYPE)).leftJoin((TableLike)Tables.INFO_LIST_ITEM.as("type_nature")).on(Tables.INFO_LIST_ITEM.as((String)"type_nature").ITEM_ID.eq((Field)Tables.TEST_CASE.TC_NATURE));
        }
    }

    private record QueryConfiguration(Set<EntityType> columnEntityTypes, Set<Field<?>> selectFields, Set<Field<?>> pkFields) {
        private QueryConfiguration() {
            this(new HashSet<EntityType>(), new HashSet(), new LinkedHashSet());
        }

        private static QueryConfiguration toMainQuery(Collection<CustomReportCustomExportColumn> selectedColumns, Map<EntityType, List<Long>> cufIdsByEntityType) {
            QueryConfiguration conf = new QueryConfiguration();
            QueryConfiguration.addSelectField(Tables.CAMPAIGN.CLN_ID, conf.selectFields());
            selectedColumns.stream().map(CustomReportCustomExportColumn::getLabel).forEach(column -> {
                QueryConfiguration.addEntityType(column, conf);
                QueryConfiguration.addPkField(column.getJooqTablePkField(), conf.pkFields());
                QueryConfiguration.addSelectField(column.getJooqTableField(), conf.selectFields());
            });
            cufIdsByEntityType.keySet().forEach(entityType -> {
                Field entityIdTableField = (Field)CustomExportColumnLabel.getEntityTypeToIdTableFieldMap().get(entityType);
                QueryConfiguration.addSelectField(entityIdTableField, conf.selectFields());
            });
            return conf;
        }

        private static void addEntityType(CustomExportColumnLabel column, QueryConfiguration conf) {
            if (CustomExportColumnLabel.CAMPAIGN_MILESTONE.equals((Object)column)) {
                conf.columnEntityTypes().add(EntityType.MILESTONE);
            } else {
                conf.columnEntityTypes().add(column.getEntityType());
            }
        }

        private static void addPkField(Field<?> pkField, Set<Field<?>> groupingFields) {
            if (pkField != null) {
                groupingFields.add(pkField);
            }
        }

        private static void addSelectField(Field<?> selectField, Set<Field<?>> selectFields) {
            if (selectField != null) {
                selectFields.add(selectField);
            }
        }
    }
}

