/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.campaign.export;

import java.util.List;
import java.util.Map;
import org.jooq.Record;
import org.jooq.ResultQuery;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.squashtest.tm.domain.customfield.BindableEntity;
import org.squashtest.tm.service.campaign.export.CampaignExport;
import org.squashtest.tm.service.campaign.export.dao.CampaignExportDao;
import org.squashtest.tm.service.feature.FeatureManager;
import org.squashtest.tm.service.internal.campaign.export.AbstractCampaignExport;
import org.squashtest.tm.service.internal.campaign.export.CampaignExportMode;
import org.squashtest.tm.service.internal.dto.CustomFieldValueDto;
import org.squashtest.tm.service.internal.dto.FileDto;
import org.squashtest.tm.service.internal.filemanagement.writer.WriterFactory;
import org.squashtest.tm.service.internal.jooq.SubElementRecordProcessor;

@Service(value="squashtest.tm.service.CampaignExportSimple")
@Transactional
public class CampaignExportSimpleImpl
extends AbstractCampaignExport
implements CampaignExport {
    private final CampaignExportDao campaignExportDao;

    public CampaignExportSimpleImpl(FeatureManager featureManager, WriterFactory writerFactory, @Qualifier(value="squashtest.tm.service.CampaignExportSimpleDao") CampaignExportDao campaignExportDao) {
        super(featureManager, writerFactory);
        this.campaignExportDao = campaignExportDao;
    }

    @Override
    public FileDto getExportFile(String campaignName) {
        return super.getExportFile(CampaignExportMode.SIMPLE, campaignName);
    }

    @Override
    public void doExport(Appendable appendable, Long campaignId) {
        this.doExport(appendable, campaignId, CampaignExportMode.SIMPLE);
    }

    @Override
    protected Map<BindableEntity, List<String>> getCufHeader(Long campaignId, List<BindableEntity> bindableEntities) {
        return this.campaignExportDao.getCufHeaderQuery(campaignId, bindableEntities);
    }

    @Override
    protected ResultQuery<Record> getQuery(Long campaignId) {
        return this.campaignExportDao.getQuery(campaignId);
    }

    @Override
    protected List<BindableEntity> getBindableEntities() {
        return List.of(BindableEntity.CAMPAIGN, BindableEntity.ITERATION, BindableEntity.TEST_CASE);
    }

    @Override
    protected Map<BindableEntity, SubElementRecordProcessor<CustomFieldValueDto>> getCufProcessors(Long campaignId) {
        return this.campaignExportDao.getCufProcessors(campaignId);
    }
}

