/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.testcase;

import java.util.Objects;
import org.squashtest.tm.domain.infolist.InfoList;
import org.squashtest.tm.domain.infolist.InfoListItem;
import org.squashtest.tm.domain.infolist.ListItemReference;
import org.squashtest.tm.domain.testcase.TestCase;
import org.squashtest.tm.domain.testcase.TestCaseFolder;
import org.squashtest.tm.domain.testcase.TestCaseLibraryNode;
import org.squashtest.tm.domain.testcase.TestCaseLibraryNodeVisitor;
import org.squashtest.tm.exception.InconsistentInfoListItemException;

public final class NatureTypeChainFixer
implements TestCaseLibraryNodeVisitor {
    public void visit(TestCaseFolder visited) {
        for (TestCaseLibraryNode node : visited.getContent()) {
            node.accept((TestCaseLibraryNodeVisitor)this);
        }
    }

    public void visit(TestCase visited) {
        NatureTypeChainFixer.replaceInfoListReferences(visited);
    }

    public static void fix(TestCase testCase) {
        NatureTypeChainFixer.replaceInfoListReferences(testCase);
    }

    public void fix(TestCaseFolder folder) {
        for (TestCaseLibraryNode node : folder.getContent()) {
            node.accept((TestCaseLibraryNodeVisitor)this);
        }
    }

    private static void replaceInfoListReferences(TestCase testCase) {
        NatureTypeChainFixer.replaceNatureInfoListReference(testCase);
        NatureTypeChainFixer.replaceTypeInfoListReference(testCase);
    }

    private static void replaceNatureInfoListReference(TestCase testCase) {
        InfoListItem nature = testCase.getNature();
        InfoList projectNatures = testCase.getProject().getTestCaseNatures();
        if (nature == null) {
            testCase.setNature(projectNatures.getDefaultItem());
        } else {
            InfoListItem persistedItem;
            if (nature instanceof ListItemReference && Objects.nonNull(persistedItem = projectNatures.getItem(nature))) {
                testCase.setNature(projectNatures.getItem(nature));
            }
            if (!projectNatures.contains(nature)) {
                throw new InconsistentInfoListItemException("nature", nature.getCode());
            }
        }
    }

    private static void replaceTypeInfoListReference(TestCase testCase) {
        InfoListItem persistedItem;
        InfoListItem type = testCase.getType();
        InfoList projectTypes = testCase.getProject().getTestCaseTypes();
        if (type == null) {
            testCase.setType(projectTypes.getDefaultItem());
            return;
        }
        if (type instanceof ListItemReference && Objects.nonNull(persistedItem = projectTypes.getItem(type))) {
            testCase.setType(projectTypes.getItem(type));
            return;
        }
        if (!projectTypes.contains(type)) {
            throw new InconsistentInfoListItemException("type", type.getCode());
        }
    }
}

