/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.importer;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.nodes.Node;
import org.jsoup.nodes.TextNode;
import org.squashtest.tm.core.foundation.logger.Logger;
import org.squashtest.tm.core.foundation.logger.LoggerFactory;

public final class ExcelRowReaderUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(ExcelRowReaderUtils.class);

    private ExcelRowReaderUtils() {
    }

    public static Double readNumericField(Row row, Map<String, Integer> columnsMapping, String tag) {
        Cell cell = ExcelRowReaderUtils.accessToCell(row, columnsMapping, tag);
        Double toReturn = null;
        if (cell != null) {
            CellType type = cell.getCellType();
            if (type == CellType.NUMERIC) {
                toReturn = cell.getNumericCellValue();
            } else if (type == CellType.STRING) {
                String value2s = cell.getStringCellValue();
                toReturn = ExcelRowReaderUtils.determineNumericValue(toReturn, value2s);
            }
        }
        return toReturn;
    }

    public static Double determineNumericValue(Double toReturn, String value2s) {
        try {
            toReturn = Double.parseDouble(value2s);
        }
        catch (NumberFormatException nfe) {
            LOGGER.warn(nfe.getMessage(), new Object[0]);
        }
        return toReturn;
    }

    public static Date readDateField(Row row, Map<String, Integer> columnsMapping, String tag) {
        Cell cell = ExcelRowReaderUtils.accessToCell(row, columnsMapping, tag);
        Date toReturn = null;
        if (cell != null) {
            CellType type = cell.getCellType();
            if (type == CellType.NUMERIC) {
                toReturn = cell.getDateCellValue();
            } else if (type == CellType.STRING) {
                String dateS = cell.getStringCellValue();
                ExcelRowReaderUtils.determineDateValue(toReturn, dateS);
            }
        }
        return toReturn;
    }

    private static Date determineDateValue(Date toReturn, String dateS) {
        try {
            toReturn = new SimpleDateFormat("dd/MM/yyyy").parse(dateS);
        }
        catch (ParseException e) {
            LOGGER.warn(e.getMessage(), new Object[0]);
        }
        return toReturn;
    }

    public static String readTextField(Row row, Map<String, Integer> columnsMapping, String tag) {
        Cell cell = ExcelRowReaderUtils.accessToCell(row, columnsMapping, tag);
        String toReturn = null;
        if (cell != null) {
            CellType type = cell.getCellType();
            if (type == CellType.STRING) {
                String value = cell.getStringCellValue();
                if (ExcelRowReaderUtils.notEmpty(value)) {
                    toReturn = value;
                }
            } else if (type == CellType.NUMERIC) {
                Double doubleVal = cell.getNumericCellValue();
                toReturn = ExcelRowReaderUtils.determineNumericDoubleValue(doubleVal);
            }
        }
        return toReturn;
    }

    private static String determineNumericDoubleValue(Double doubleVal) {
        return doubleVal % 1.0 == 0.0 ? String.valueOf(doubleVal.intValue()) : doubleVal.toString();
    }

    private static boolean notEmpty(String string) {
        return string != null && !string.isEmpty();
    }

    private static Cell accessToCell(Row row, Map<String, Integer> columnsMapping, String tag) {
        Integer columnIndex = columnsMapping.get(tag);
        if (columnIndex != null && columnIndex >= 0) {
            return row.getCell(columnIndex.intValue());
        }
        return null;
    }

    public static Map<String, Integer> mapColumns(Sheet sheet) {
        HashMap<String, Integer> columnsMapping = new HashMap<String, Integer>();
        Row firstRow = sheet.getRow(0);
        int c = 0;
        while (c < firstRow.getLastCellNum()) {
            Cell headerCell = firstRow.getCell(c);
            if (headerCell != null) {
                String headerTag = headerCell.getStringCellValue();
                columnsMapping.put(headerTag.toUpperCase(), c);
            }
            ++c;
        }
        return columnsMapping;
    }

    public static String escapeHTMLInsideTags(String html) {
        Document doc = Jsoup.parse((String)html);
        for (Element element : doc.select("script")) {
            element.replaceWith((Node)TextNode.createFromEncoded((String)element.toString()));
        }
        return doc.body().html();
    }
}

