/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.deletion;

import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.squashtest.tm.service.deletion.MultipleReqVersionWithActiveMilestonesReport;
import org.squashtest.tm.service.deletion.SingleMilestonesReport;
import org.squashtest.tm.service.deletion.SuppressionPreviewReport;
import org.squashtest.tm.service.internal.campaign.LockedRequirementNodeDetectionService;
import org.squashtest.tm.service.internal.deletion.AbstractLockedNodeDetectionService;
import org.squashtest.tm.service.internal.repository.RequirementDao;
import org.squashtest.tm.service.internal.repository.RequirementDeletionDao;
import org.squashtest.tm.service.milestone.ActiveMilestoneHolder;

@Service
public class LockedRequirementNodeDetectionServiceImpl
extends AbstractLockedNodeDetectionService
implements LockedRequirementNodeDetectionService {
    private static final String REQUIREMENTS_TYPE = "requirements";
    private final RequirementDeletionDao deletionDao;
    private final RequirementDao requirementDao;

    @Autowired
    public LockedRequirementNodeDetectionServiceImpl(ActiveMilestoneHolder activeMilestoneHolder, RequirementDeletionDao deletionDao, RequirementDao requirementDao) {
        super(activeMilestoneHolder);
        this.deletionDao = deletionDao;
        this.requirementDao = requirementDao;
    }

    @Override
    public List<SuppressionPreviewReport> detectLockedByMilestone(List<Long> nodeIds) {
        return super.detectLockedByMilestone(nodeIds, REQUIREMENTS_TYPE);
    }

    @Override
    public List<SuppressionPreviewReport> detectLockedWithActiveMilestone(List<Long> nodeIds) {
        return super.detectLockedWithActiveMilestone(nodeIds, REQUIREMENTS_TYPE);
    }

    @Override
    protected void addMultipleMilestoneBindingToReportList(List<Long> nodeIds, List<Long> multiMilestoneNodes, List<SuppressionPreviewReport> reportList, String reportType) {
        if (!multiMilestoneNodes.isEmpty()) {
            SuppressionPreviewReport suppressionPreviewReport = this.getReportMultipleMilestoneBinding(nodeIds, multiMilestoneNodes, reportType);
            suppressionPreviewReport.addAllLockedNodes(multiMilestoneNodes);
            reportList.add(suppressionPreviewReport);
        } else {
            reportList.add(new SingleMilestonesReport(reportType));
        }
    }

    @Override
    protected void addAdditionalReportWithActiveMilestoneToReportList(List<Long> nodeIds, Long activeMilestoneId, List<SuppressionPreviewReport> reportList, String reportType) {
        List<Long> nonBoundNodes = this.requirementDao.findNonBoundRequirement(nodeIds, activeMilestoneId);
        this.addNonBoundNodesWithActiveMilestoneToReportList(nonBoundNodes, reportList, reportType);
        List<Long> reqHavingManyVersions = this.requirementDao.filterRequirementHavingManyVersions(nodeIds);
        if (!reqHavingManyVersions.isEmpty()) {
            MultipleReqVersionWithActiveMilestonesReport suppressionPreviewReport = new MultipleReqVersionWithActiveMilestonesReport(reportType);
            suppressionPreviewReport.addAllLockedNodes(reqHavingManyVersions);
            reportList.add(suppressionPreviewReport);
        }
    }

    @Override
    protected List<Long> findNodesWhichMilestonesForbidsDeletion(List<Long> nodeIds) {
        return this.deletionDao.filterRequirementsIdsWhichMilestonesForbidsDeletion(nodeIds);
    }

    @Override
    protected Map<String, List<Long>> getIdsSeparateFolderFromNodeIds(List<Long> nodeIds) {
        return this.deletionDao.separateFolderFromRequirementIds(nodeIds);
    }

    @Override
    protected List<Long> findNodeIdsHavingMultipleMilestones(List<Long> nodeIds) {
        return this.deletionDao.filterRequirementHavingMultipleMilestones(nodeIds);
    }
}

