/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.display.grid.filters;

import java.util.List;
import java.util.Objects;
import org.jooq.Condition;
import org.jooq.Field;
import org.squashtest.tm.service.internal.display.grid.GridFilterValue;
import org.squashtest.tm.service.internal.display.grid.filters.GridFilterConditionBuilder;

public class FulltextConditionBuilder<T>
implements GridFilterConditionBuilder {
    private final Field<T> field;
    private final GridFilterValue gridFilterValue;

    FulltextConditionBuilder(Field<T> field, GridFilterValue gridFilterValue) {
        Objects.requireNonNull(field);
        Objects.requireNonNull(gridFilterValue);
        List<String> values = gridFilterValue.getValues();
        if (values.isEmpty()) {
            throw new IllegalArgumentException("At least one value is required to build a fulltext condition");
        }
        this.field = field;
        this.gridFilterValue = gridFilterValue;
    }

    @Override
    public Condition build() {
        String value = this.gridFilterValue.getValues().getFirst();
        return this.field.containsIgnoreCase((Object)value);
    }
}

