/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.campaign;

import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.squashtest.tm.domain.execution.ExecutionStatus;
import org.squashtest.tm.domain.execution.ExecutionStatusReport;
import org.squashtest.tm.domain.testautomation.AutomatedExecutionExtender;
import org.squashtest.tm.domain.testautomation.AutomatedSuite;
import org.squashtest.tm.service.campaign.AutomatedSuiteModificationService;
import org.squashtest.tm.service.internal.repository.AutomatedExecutionExtenderDao;
import org.squashtest.tm.service.internal.repository.AutomatedSuiteDao;

@Transactional
@Service(value="AutomatedSuiteModificationService")
public class AutomatedSuiteModificationServiceImpl
implements AutomatedSuiteModificationService {
    private final AutomatedSuiteDao automatedSuiteDao;
    private final AutomatedExecutionExtenderDao automatedExecutionExtenderDao;

    public AutomatedSuiteModificationServiceImpl(AutomatedSuiteDao automatedSuiteDao, AutomatedExecutionExtenderDao automatedExecutionExtenderDao) {
        this.automatedSuiteDao = automatedSuiteDao;
        this.automatedExecutionExtenderDao = automatedExecutionExtenderDao;
    }

    @Override
    public void updateExecutionStatus(AutomatedSuite automatedSuite) {
        ExecutionStatusReport report = this.automatedSuiteDao.getStatusReport(automatedSuite.getId());
        ExecutionStatus newExecutionStatus = ExecutionStatus.computeNewStatusForAutomatedSuite((ExecutionStatusReport)report);
        automatedSuite.setExecutionStatus(newExecutionStatus);
    }

    @Override
    public void updateExecutionStatusByExtenderId(long automatedExecExtenderId) {
        AutomatedExecutionExtender extender = this.automatedExecutionExtenderDao.findById(automatedExecExtenderId);
        if (extender != null && extender.getAutomatedSuite() != null) {
            this.updateExecutionStatus(extender.getAutomatedSuite());
        }
    }
}

