/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.testautomation.resultpublisher;

import jakarta.persistence.EntityManager;
import jakarta.persistence.EntityNotFoundException;
import jakarta.persistence.PersistenceContext;
import jakarta.validation.constraints.NotNull;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.Date;
import java.util.EnumMap;
import java.util.Map;
import java.util.Optional;
import org.springframework.security.access.AccessDeniedException;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.squashtest.tm.api.plugin.PluginName;
import org.squashtest.tm.api.plugin.UsedInPlugin;
import org.squashtest.tm.api.testautomation.execution.dto.TestExecutionStatus;
import org.squashtest.tm.aspect.validation.NotNullValidatorAspect;
import org.squashtest.tm.core.foundation.exception.EntityDoesNotExistException;
import org.squashtest.tm.core.foundation.logger.Logger;
import org.squashtest.tm.core.foundation.logger.LoggerFactory;
import org.squashtest.tm.domain.EntityType;
import org.squashtest.tm.domain.attachment.Attachment;
import org.squashtest.tm.domain.campaign.Iteration;
import org.squashtest.tm.domain.campaign.TestSuite;
import org.squashtest.tm.domain.execution.ExecutionStatus;
import org.squashtest.tm.domain.testautomation.AutomatedSuite;
import org.squashtest.tm.service.attachment.AttachmentManagerService;
import org.squashtest.tm.service.attachment.RawAttachment;
import org.squashtest.tm.service.internal.display.dto.AttachmentDto;
import org.squashtest.tm.service.internal.repository.AutomatedSuiteDao;
import org.squashtest.tm.service.security.PermissionEvaluationService;
import org.squashtest.tm.service.testautomation.model.AutomatedExecutionState;
import org.squashtest.tm.service.testautomation.model.RestUploadedData;
import org.squashtest.tm.service.testautomation.resultpublisher.AutomatedSuitePublisherService;

@Service(value="automatedSuitePublisherService")
@Transactional
public class AutomatedSuitePublisherServiceImpl
implements AutomatedSuitePublisherService {
    private static final Logger LOGGER = LoggerFactory.getLogger(AutomatedSuitePublisherServiceImpl.class);
    private static final Map<ExecutionStatus, Integer> PRIORITY_MAP;
    private final AutomatedSuiteDao autoSuiteDao;
    private final AttachmentManagerService attachmentManagerService;
    private final PermissionEvaluationService permissionEvaluationService;
    @PersistenceContext
    private EntityManager entityManager;

    static {
        EnumMap<ExecutionStatus, Integer> statusPriorityMap = new EnumMap<ExecutionStatus, Integer>(ExecutionStatus.class);
        statusPriorityMap.put(ExecutionStatus.READY, 1);
        statusPriorityMap.put(ExecutionStatus.RUNNING, 2);
        statusPriorityMap.put(ExecutionStatus.UNTESTABLE, 3);
        statusPriorityMap.put(ExecutionStatus.SETTLED, 4);
        statusPriorityMap.put(ExecutionStatus.SKIPPED, 5);
        statusPriorityMap.put(ExecutionStatus.SUCCESS, 6);
        statusPriorityMap.put(ExecutionStatus.FAILURE, 7);
        statusPriorityMap.put(ExecutionStatus.BLOCKED, 8);
        statusPriorityMap.put(ExecutionStatus.CANCELLED, 9);
        PRIORITY_MAP = Collections.unmodifiableMap(statusPriorityMap);
    }

    public AutomatedSuitePublisherServiceImpl(AutomatedSuiteDao autoSuiteDao, AttachmentManagerService attachmentManagerService, PermissionEvaluationService permissionEvaluationService) {
        this.autoSuiteDao = autoSuiteDao;
        this.attachmentManagerService = attachmentManagerService;
        this.permissionEvaluationService = permissionEvaluationService;
    }

    @Override
    public void forceExecutionStatus(Long suiteId, @NotNull AutomatedExecutionState stateChange) {
        AutomatedExecutionState automatedExecutionState = stateChange;
        NotNullValidatorAspect.aspectOf().ajc$before$org_squashtest_tm_aspect_validation_NotNullValidatorAspect$2$7531eba5((Object)automatedExecutionState);
        AutomatedSuite autoSuite = this.autoSuiteDao.findById(suiteId);
        this.checkPermissionsToUpdateAutomatedSuite(autoSuite);
        Date date = new Date();
        this.arbitraryUpdateMetadata(autoSuite, date);
        this.updateSelfExecutionStatus(autoSuite, stateChange);
        Optional.ofNullable(stateChange.getAttachments()).ifPresent(attachments -> {
            for (org.squashtest.tm.service.testautomation.model.Attachment attachment : attachments) {
                this.updateAttachments(autoSuite.getAttachmentList().getId(), attachment, EntityType.AUTOMATED_SUITE);
            }
        });
    }

    private void arbitraryUpdateMetadata(AutomatedSuite autoSuite, Date date) {
        autoSuite.setLastModifiedOn(date);
    }

    private void updateSelfExecutionStatus(AutomatedSuite automatedSuite, AutomatedExecutionState stateChange) {
        TestExecutionStatus testExecutionStatus = stateChange.getTfTestExecutionStatus().tfTestExecutionStatusToTmTestExecutionStatus();
        ExecutionStatus formerStatus = automatedSuite.getExecutionStatus().getCanonicalStatus();
        ExecutionStatus newStatus = ExecutionStatus.valueOf((String)testExecutionStatus.getStatus().name()).getCanonicalStatus();
        if (PRIORITY_MAP.get(newStatus) > PRIORITY_MAP.get(formerStatus)) {
            automatedSuite.setExecutionStatus(newStatus);
        }
        this.entityManager.flush();
        this.entityManager.clear();
    }

    @Override
    @UsedInPlugin(names={PluginName.API_REST})
    public AttachmentDto attachReportToAutomatedSuite(String uuid, org.squashtest.tm.service.testautomation.model.Attachment allureUpdate) {
        AutomatedSuite autoSuite = this.autoSuiteDao.findByUuid(uuid).orElseThrow(() -> new EntityDoesNotExistException("AUTOMATED_SUITE", uuid));
        this.checkPermissionsToUpdateAutomatedSuite(autoSuite);
        Long attachmentListId = autoSuite.getAttachmentList().getId();
        return this.updateAttachments(attachmentListId, allureUpdate, EntityType.AUTOMATED_SUITE);
    }

    @Override
    @UsedInPlugin(names={PluginName.API_REST})
    public AttachmentDto updateAttachmentContent(org.squashtest.tm.service.testautomation.model.Attachment testAutoAttachment, Long attachmentId) {
        try {
            Attachment attachment = this.attachmentManagerService.findAttachment(attachmentId);
            if (attachment == null) {
                throw new EntityNotFoundException();
            }
            return this.attachmentManagerService.updateAttachmentContent(attachment, testAutoAttachment.getContent());
        }
        catch (IOException e) {
            LOGGER.error("Unable to read attachment.", (Throwable)e);
            throw new NullPointerException();
        }
    }

    @Override
    public AttachmentDto updateAttachments(Long attachmentListId, org.squashtest.tm.service.testautomation.model.Attachment attachment, EntityType entityType) {
        try {
            InputStream stream = attachment.getContent();
            String name = attachment.getName();
            long sizeInBytes = attachment.getContent().available();
            RestUploadedData attachmentUploadedData = new RestUploadedData(stream, name, sizeInBytes);
            return this.attachmentManagerService.addAttachment(attachmentListId, (RawAttachment)attachmentUploadedData, entityType);
        }
        catch (IOException e) {
            LOGGER.debug("Unable to read attachment.", (Throwable)e);
            return null;
        }
    }

    private void checkPermissionsToUpdateAutomatedSuite(AutomatedSuite suite) {
        boolean hasPermission = false;
        Iteration iteration = suite.getIteration();
        TestSuite testSuite = suite.getTestSuite();
        if (this.permissionEvaluationService.hasRole("ROLE_TA_API_CLIENT") || this.permissionEvaluationService.hasRole("ROLE_ADMIN")) {
            hasPermission = true;
        } else if (iteration != null) {
            hasPermission = this.permissionEvaluationService.hasPermissionOnObject("EXECUTE", iteration);
        } else if (testSuite != null) {
            hasPermission = this.permissionEvaluationService.hasPermissionOnObject("EXECUTE", testSuite);
        }
        if (!hasPermission) {
            throw new AccessDeniedException("Access is denied.");
        }
    }

    @Override
    @UsedInPlugin(names={PluginName.API_REST})
    public void updateAutomatedSuiteExecStatus(String uuid, String status) {
        try {
            ExecutionStatus executionStatus = ExecutionStatus.valueOf((String)status);
            AutomatedSuite autoSuite = this.autoSuiteDao.findByUuid(uuid).orElseThrow(() -> new EntityDoesNotExistException("AUTOMATED_SUITE", uuid));
            autoSuite.setExecutionStatus(executionStatus);
            TestSuite testSuite = autoSuite.getTestSuite();
            if (testSuite != null) {
                testSuite.setExecutionStatus(executionStatus);
            }
            if (ExecutionStatus.BLOCKED.equals((Object)executionStatus)) {
                autoSuite.setWorkflows(null);
            }
            this.entityManager.flush();
            this.entityManager.clear();
        }
        catch (IllegalArgumentException ex) {
            LOGGER.error("Received status {} is not a valid status.", new Object[]{status, ex});
        }
    }
}

