/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.dto.projectimporterxray.model;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.jooq.tools.StringUtils;
import org.squashtest.tm.exception.pivot.projectimporter.xrayimporter.XrayParsingException;

public class XrayInfoModel {
    private final Map<String, Entity> entities = new HashMap<String, Entity>();
    private final Set<String> keys = new HashSet<String>();

    public Map<String, Entity> getEntities() {
        return this.entities;
    }

    public void addEntity(Entity entity) {
        if (Objects.isNull(entity)) {
            return;
        }
        this.addTypeEntity(entity);
        this.addKeyEntity(entity);
    }

    private void addTypeEntity(Entity entity) {
        String type = entity.getType();
        if (StringUtils.isBlank((String)type)) {
            throw new XrayParsingException(entity.filename, entity.line, entity.name, "type");
        }
        if (!this.entities.containsKey(type)) {
            this.entities.put(type, entity);
        } else {
            this.entities.get(type).mergingEntity(entity);
        }
    }

    private void addKeyEntity(Entity entity) {
        String key = entity.getKey();
        if (StringUtils.isBlank((String)key)) {
            throw new XrayParsingException(entity.filename, entity.line, entity.name, "key");
        }
        if (this.keys.contains(key)) {
            throw new XrayParsingException(entity.filename, entity.line, entity.name);
        }
        this.keys.add(key);
    }

    public static class Entity {
        private final String filename;
        private final int line;
        private final Set<String> status = new HashSet<String>();
        private final Set<String> priorities = new HashSet<String>();
        private String key;
        private String type;
        private String name;
        private int entityCount = 1;

        public Entity(String filename, int line) {
            this.filename = filename;
            this.line = line;
            this.name = Entity.generateDefaultName(line);
        }

        private static String generateDefaultName(int line) {
            return "entity_at_line_" + line;
        }

        public String getType() {
            return this.type;
        }

        public void setType(String type) {
            this.type = type;
        }

        public String getKey() {
            return this.key;
        }

        public void setKey(String key) {
            this.key = key;
        }

        public int getEntityCount() {
            return this.entityCount;
        }

        public void setName(String name) {
            this.name = name;
        }

        public Set<String> getStatus() {
            return this.status;
        }

        public Set<String> getPriorities() {
            return this.priorities;
        }

        public void mergingEntity(Entity entity) {
            this.entityCount += entity.getEntityCount();
            this.status.addAll(entity.getStatus());
            this.priorities.addAll(entity.getPriorities());
        }
    }
}

