/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.batchimport;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.map.MultiValueMap;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.validator.routines.BigDecimalValidator;
import org.squashtest.tm.core.foundation.lang.DateUtils;
import org.squashtest.tm.domain.customfield.CustomField;
import org.squashtest.tm.domain.customfield.CustomFieldOption;
import org.squashtest.tm.domain.customfield.InputType;
import org.squashtest.tm.domain.customfield.SingleSelectField;
import org.squashtest.tm.service.importer.LogEntry;
import org.squashtest.tm.service.importer.Target;
import org.squashtest.tm.service.internal.batchimport.CustomFieldError;
import org.squashtest.tm.service.internal.batchimport.LogTrain;
import org.squashtest.tm.service.internal.dto.NumericCufHelper;

class CustomFieldValidator {
    private static final String TRUE = "TRUE";
    private static final String FALSE = "FALSE";
    private MultiValueMap optionsByListCode = new MultiValueMap();

    LogTrain checkUpdateCustomFields(Target target, Map<String, String> cufs, Collection<CustomField> definitions) {
        LogTrain train = new LogTrain();
        for (CustomField cuf : definitions) {
            String code = cuf.getCode();
            String value = cufs.get(code);
            CustomFieldError error = this.checkCustomField(value, cuf);
            if (error == null) continue;
            String errorMessage = error.getErrorMessage();
            String impact = error.getUpdateImpact();
            CustomFieldError.updateValue(cufs, cuf, value, impact);
            LogEntry entry = LogEntry.warning().forTarget(target).withMessage(errorMessage, code).withImpact(impact, new Object[0]).build();
            train.addEntry(entry);
        }
        return train;
    }

    LogTrain checkCreateCustomFields(Target target, Map<String, String> cufs, Collection<CustomField> definitions) {
        LogTrain train = new LogTrain();
        for (CustomField cuf : definitions) {
            String code = cuf.getCode();
            String value = cufs.get(code);
            CustomFieldError error = this.checkCustomField(value, cuf);
            if (error == null) continue;
            String errorMessage = error.getErrorMessage();
            String impact = error.getCreateImpact();
            CustomFieldError.updateValue(cufs, cuf, value, impact);
            LogEntry entry = LogEntry.warning().forTarget(target).withMessage(errorMessage, code).withImpact(impact, new Object[0]).build();
            train.addEntry(entry);
        }
        return train;
    }

    private CustomFieldError checkCustomField(String inputValue, CustomField cuf) {
        CustomFieldError error = null;
        InputType type = cuf.getInputType();
        if (StringUtils.isNotBlank((CharSequence)inputValue)) {
            error = this.checkForType(inputValue, cuf, type);
        } else if (!cuf.isOptional()) {
            error = CustomFieldError.MANDATORY_CUF;
        }
        return error;
    }

    public CustomFieldError checkForType(String inputValue, CustomField cuf, InputType type) {
        CustomFieldError error = null;
        switch (type) {
            case PLAIN_TEXT: {
                if (inputValue.length() <= 255) break;
                error = CustomFieldError.MAX_SIZE;
                break;
            }
            case CHECKBOX: {
                if (TRUE.equalsIgnoreCase(inputValue) || FALSE.equalsIgnoreCase(inputValue)) break;
                error = CustomFieldError.UNPARSABLE_CHECKBOX;
                break;
            }
            case DATE_PICKER: {
                if (StringUtils.isBlank((CharSequence)inputValue) || DateUtils.weakCheckIso8601Date((String)inputValue)) break;
                error = CustomFieldError.UNPARSABLE_DATE;
                break;
            }
            case DROPDOWN_LIST: {
                this.registerOptions(cuf);
                error = this.getDropdownListError(inputValue, cuf);
                break;
            }
            case RICH_TEXT: {
                break;
            }
            case TAG: {
                break;
            }
            case NUMERIC: {
                error = StringUtils.isBlank((CharSequence)inputValue) ? CustomFieldError.UNPARSABLE_NUMBER : this.validateNumericCustomField(inputValue);
                break;
            }
            default: {
                error = CustomFieldError.UNKNOWN_CUF_TYPE;
            }
        }
        return error;
    }

    private CustomFieldError getDropdownListError(String inputValue, CustomField cuf) {
        Collection rawOptions = this.optionsByListCode.getCollection((Object)cuf.getCode());
        List<String> options = rawOptions.stream().map(String.class::cast).toList();
        if (!options.contains(inputValue)) {
            return CustomFieldError.UNPARSABLE_OPTION;
        }
        return null;
    }

    private CustomFieldError validateNumericCustomField(String inputValue) {
        String formattedInputValue = NumericCufHelper.formatInputNumericCufValue(inputValue);
        BigDecimalValidator validator = BigDecimalValidator.getInstance();
        boolean valid = validator.isValid(formattedInputValue);
        if (!valid) {
            return CustomFieldError.UNPARSABLE_NUMBER;
        }
        return null;
    }

    private void registerOptions(CustomField cuf) {
        String code = cuf.getCode();
        if (!this.optionsByListCode.containsKey((Object)cuf.getCode())) {
            List options = ((SingleSelectField)cuf).getOptions();
            for (CustomFieldOption op : options) {
                this.optionsByListCode.put((Object)code, (Object)op.getLabel());
            }
        }
    }
}

