/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.requirement;

import jakarta.inject.Inject;
import jakarta.inject.Named;
import jakarta.inject.Provider;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jooq.TableField;
import org.springframework.context.MessageSource;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.squashtest.tm.aspect.validation.NotNullValidatorAspect;
import org.squashtest.tm.domain.requirement.ExportRequirementData;
import org.squashtest.tm.domain.requirement.Requirement;
import org.squashtest.tm.domain.requirement.RequirementLibrary;
import org.squashtest.tm.domain.requirement.RequirementLibraryNode;
import org.squashtest.tm.domain.requirement.RequirementVersion;
import org.squashtest.tm.jooq.domain.Tables;
import org.squashtest.tm.jooq.domain.tables.records.ProjectRecord;
import org.squashtest.tm.service.internal.batchexport.RequirementExcelExporter;
import org.squashtest.tm.service.internal.batchexport.RequirementExportDao;
import org.squashtest.tm.service.internal.batchexport.RequirementSearchExcelExporter;
import org.squashtest.tm.service.internal.batchexport.SearchRequirementExcelExporter;
import org.squashtest.tm.service.internal.batchexport.SearchSimpleRequirementExcelExporter;
import org.squashtest.tm.service.internal.batchexport.models.RequirementExportModel;
import org.squashtest.tm.service.internal.dto.UserDto;
import org.squashtest.tm.service.internal.repository.RequirementDao;
import org.squashtest.tm.service.internal.repository.display.HighLevelRequirementDisplayDao;
import org.squashtest.tm.service.project.ProjectFinder;
import org.squashtest.tm.service.requirement.RequirementLibraryNavigationExportService;
import org.squashtest.tm.service.requirement.RequirementLibraryNavigationService;
import org.squashtest.tm.service.security.PermissionEvaluationService;
import org.squashtest.tm.service.user.UserAccountService;

@Transactional
@Service(value="squashtest.tm.service.RequirementLibraryNavigationExportService")
public class RequirementLibraryNavigationExportServiceImpl
implements RequirementLibraryNavigationExportService {
    private static final String EXPORT = "EXPORT";
    private static final String SIMPLE = "simple";
    @Inject
    private RequirementDao requirementDao;
    @Inject
    private RequirementExportDao requirementExportDao;
    @Inject
    private UserAccountService userAccountService;
    @Inject
    private ProjectFinder projectFinder;
    @Inject
    protected PermissionEvaluationService permissionService;
    @Inject
    private HighLevelRequirementDisplayDao highLevelRequirementDisplayDao;
    @Inject
    private RequirementLibraryNavigationService requirementLibraryNavigationService;
    @Inject
    @Named(value="requirementExcelExporter")
    private Provider<RequirementExcelExporter> exporterProvider;
    @Inject
    private Provider<SearchRequirementExcelExporter> searchExporterProvider;
    @Inject
    private Provider<SearchSimpleRequirementExcelExporter> searchSimpleExporterProvider;

    @Override
    public File exportRequirementAsExcel(List<Long> libraryIds, List<Long> nodeIds, boolean keepRteFormat, MessageSource messageSource) {
        return this.exportRequirementAsExcel(libraryIds, nodeIds, false, keepRteFormat, messageSource);
    }

    @Override
    public File exportRequirementAsExcel(List<Long> libraryIds, List<Long> nodeIds, boolean addLinkedLowLevelReq, boolean keepRteFormat, MessageSource messageSource) {
        HashSet<Long> reqIds = new HashSet<Long>();
        Collection<Long> allIds = this.requirementLibraryNavigationService.findRequirementIdsFromSelection(libraryIds, nodeIds);
        allIds = this.securityFilterIds(allIds, Requirement.class.getName(), EXPORT);
        reqIds.addAll(allIds);
        if (addLinkedLowLevelReq) {
            List<Long> exportableProjectIds = this.findExportableProjectIds();
            reqIds.addAll(this.highLevelRequirementDisplayDao.findStandardRequirementsByRequirementIdsAndProjectIds(new ArrayList<Long>(reqIds), exportableProjectIds));
        }
        List<Long> reqVersionIds = this.requirementDao.findIdsVersionsForAll(new ArrayList<Long>(reqIds));
        RequirementExportModel exportModel = this.requirementExportDao.findAllRequirementModel(reqVersionIds);
        RequirementExcelExporter exporter = (RequirementExcelExporter)this.exporterProvider.get();
        exporter.appendToWorkbook(exportModel, keepRteFormat);
        return exporter.print();
    }

    private List<Long> findExportableProjectIds() {
        UserDto currentUser = this.userAccountService.findCurrentUserDto();
        return this.projectFinder.findAllExportableIdsOnGivenLibrary(currentUser, RequirementLibrary.class.getName(), (TableField<ProjectRecord, Long>)Tables.PROJECT.RL_ID);
    }

    @Override
    public File searchExportRequirementAsExcel(List<Long> nodeIds, boolean keepRteFormat, boolean addLinkedLowLevelReq, MessageSource messageSource, String type, Boolean simplifiedColumnDisplay) {
        File file;
        Set<Long> reqVersionIds = this.securityFilterIds(nodeIds, RequirementVersion.class.getName(), EXPORT);
        if (addLinkedLowLevelReq) {
            List<Long> exportableProjectIds = this.findExportableProjectIds();
            reqVersionIds.addAll(this.highLevelRequirementDisplayDao.findLinkedLowLevelReqVersionIdsByReqVersionIdsAndProjectIds(new ArrayList<Long>(reqVersionIds), exportableProjectIds));
        }
        if (type.equals(SIMPLE)) {
            RequirementExportModel exportModel = this.requirementExportDao.populateRequirementExportModelFromJooq(new ArrayList<Long>(reqVersionIds));
            exporter = (SearchSimpleRequirementExcelExporter)this.searchSimpleExporterProvider.get();
            ((RequirementSearchExcelExporter)exporter).createHeaders(simplifiedColumnDisplay);
            ((RequirementSearchExcelExporter)exporter).getMessageSource(messageSource);
            ((RequirementSearchExcelExporter)exporter).appendToWorkbook(exportModel, keepRteFormat, simplifiedColumnDisplay);
            file = ((RequirementSearchExcelExporter)exporter).print();
        } else {
            RequirementExportModel exportModel = this.requirementExportDao.findAllRequirementModel(new ArrayList<Long>(reqVersionIds));
            exporter = (SearchRequirementExcelExporter)this.searchExporterProvider.get();
            ((RequirementExcelExporter)exporter).appendToWorkbook(exportModel, keepRteFormat);
            file = ((RequirementExcelExporter)exporter).print();
        }
        return file;
    }

    @Override
    public List<ExportRequirementData> findRequirementsToExportFromLibrary(List<Long> libraryIds) {
        List<Long> list = libraryIds;
        NotNullValidatorAspect.aspectOf().ajc$before$org_squashtest_tm_aspect_validation_NotNullValidatorAspect$1$53d01289(list);
        this.permissionService.checkPermission(libraryIds, EXPORT, RequirementLibrary.class.getName());
        return this.requirementDao.findRequirementToExportFromLibrary(libraryIds);
    }

    @Override
    public List<ExportRequirementData> findRequirementsToExportFromNodes(List<Long> nodesIds) {
        List<Long> list = nodesIds;
        NotNullValidatorAspect.aspectOf().ajc$before$org_squashtest_tm_aspect_validation_NotNullValidatorAspect$1$53d01289(list);
        this.permissionService.checkPermission(nodesIds, EXPORT, RequirementLibraryNode.class.getName());
        return this.requirementDao.findRequirementToExportFromNodes(nodesIds);
    }

    private Set<Long> securityFilterIds(Collection<Long> original, String entityType, String permission) {
        HashSet<Long> effective = new HashSet<Long>();
        for (Long id : original) {
            if (!this.permissionService.hasRoleOrPermissionOnObject("ROLE_ADMIN", permission, id, entityType)) continue;
            effective.add(id);
        }
        return effective;
    }
}

