/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.repository.display.impl.collectors.customreports;

import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.jooq.DSLContext;
import org.jooq.Field;
import org.jooq.GroupField;
import org.jooq.SelectField;
import org.jooq.TableLike;
import org.springframework.stereotype.Component;
import org.squashtest.tm.domain.NodeReference;
import org.squashtest.tm.domain.NodeType;
import org.squashtest.tm.domain.customreport.CustomReportTreeDefinition;
import org.squashtest.tm.jooq.domain.Tables;
import org.squashtest.tm.service.internal.display.grid.DataRow;
import org.squashtest.tm.service.internal.repository.display.CustomFieldValueDisplayDao;
import org.squashtest.tm.service.internal.repository.display.MilestoneDisplayDao;
import org.squashtest.tm.service.internal.repository.display.impl.collectors.AbstractTreeNodeCollector;
import org.squashtest.tm.service.milestone.ActiveMilestoneHolder;

@Component
public class ChartDefinitionCollector
extends AbstractTreeNodeCollector {
    public ChartDefinitionCollector(DSLContext dsl, CustomFieldValueDisplayDao customFieldValueDisplayDao, ActiveMilestoneHolder activeMilestoneHolder, MilestoneDisplayDao milestoneDisplayDao) {
        super(dsl, customFieldValueDisplayDao, activeMilestoneHolder, milestoneDisplayDao);
    }

    @Override
    protected Map<Long, DataRow> doCollect(List<Long> ids) {
        Map<Long, DataRow> customReportFolders = this.dsl.select((SelectField)Tables.CUSTOM_REPORT_LIBRARY_NODE.CRLN_ID, (SelectField)Tables.CHART_DEFINITION.CHART_ID, (SelectField)Tables.CHART_DEFINITION.NAME, (SelectField)Tables.CHART_DEFINITION.PROJECT_ID.as("projectId")).from((TableLike)Tables.CUSTOM_REPORT_LIBRARY_NODE).innerJoin((TableLike)Tables.CHART_DEFINITION).on(Tables.CHART_DEFINITION.CHART_ID.eq((Field)Tables.CUSTOM_REPORT_LIBRARY_NODE.ENTITY_ID)).and(Tables.CUSTOM_REPORT_LIBRARY_NODE.ENTITY_TYPE.eq((Object)CustomReportTreeDefinition.CHART.name())).where(Tables.CUSTOM_REPORT_LIBRARY_NODE.CRLN_ID.in(ids)).groupBy(new GroupField[]{Tables.CUSTOM_REPORT_LIBRARY_NODE.CRLN_ID, Tables.CHART_DEFINITION.CHART_ID}).fetch().stream().collect(Collectors.toMap(tuple -> (Long)tuple.get((Field)Tables.CUSTOM_REPORT_LIBRARY_NODE.CRLN_ID), tuple -> {
            DataRow dataRow = new DataRow();
            dataRow.setId(new NodeReference(NodeType.CHART_DEFINITION, (Long)tuple.get((Field)Tables.CUSTOM_REPORT_LIBRARY_NODE.CRLN_ID)).toNodeId());
            dataRow.setProjectId((Long)tuple.get("projectId", Long.class));
            dataRow.setData(tuple.intoMap());
            return dataRow;
        }));
        this.appendMilestonesByProject(customReportFolders);
        return customReportFolders;
    }

    @Override
    public NodeType getHandledEntityType() {
        return NodeType.CHART_DEFINITION;
    }
}

