/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.display.tf;

import java.util.Arrays;
import java.util.List;
import org.jooq.DSLContext;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.squashtest.tm.domain.query.Operation;
import org.squashtest.tm.domain.tf.automationrequest.AutomationRequestStatus;
import org.squashtest.tm.service.display.tf.AutomationRequestDisplayService;
import org.squashtest.tm.service.internal.display.grid.GridFilterValue;
import org.squashtest.tm.service.internal.display.grid.GridRequest;
import org.squashtest.tm.service.internal.display.grid.GridResponse;
import org.squashtest.tm.service.internal.display.grid.tf.AutomationRequestGrid;
import org.squashtest.tm.service.internal.dto.UserDto;
import org.squashtest.tm.service.project.ProjectFinder;
import org.squashtest.tm.service.user.UserAccountService;

@Service
@Transactional(readOnly=true)
public class AutomationRequestDisplayServiceImpl
implements AutomationRequestDisplayService {
    private final UserAccountService userAccountService;
    private final DSLContext dslContext;
    private final ProjectFinder projectFinder;

    public AutomationRequestDisplayServiceImpl(UserAccountService userAccountService, DSLContext dslContext, ProjectFinder projectFinder) {
        this.userAccountService = userAccountService;
        this.dslContext = dslContext;
        this.projectFinder = projectFinder;
    }

    @Override
    public GridResponse findAutomationRequestAssignedToCurrentUser(GridRequest request) {
        UserDto currentUser = this.userAccountService.findCurrentUserDto();
        return this.fetchData(request, false, currentUser.getUserId());
    }

    @Override
    public GridResponse findAutomationRequestToTreat(GridRequest request) {
        GridFilterValue requestStatusFilterValue = new GridFilterValue();
        requestStatusFilterValue.setId("requestStatus");
        requestStatusFilterValue.setValues(Arrays.asList(AutomationRequestStatus.AUTOMATION_IN_PROGRESS.name(), AutomationRequestStatus.TRANSMITTED.name()));
        requestStatusFilterValue.setOperation(Operation.IN.name());
        request.getFilterValues().add(requestStatusFilterValue);
        return this.fetchData(request, true, null);
    }

    @Override
    public GridResponse findAutomationRequests(GridRequest request) {
        return this.fetchData(request, false, null);
    }

    private GridResponse fetchData(GridRequest request, boolean withAssigneeNull, Long assigneeId) {
        List<Long> readableProjectIds = this.projectFinder.findAllReadableIdsForAutomationWriter();
        AutomationRequestGrid grid = new AutomationRequestGrid(readableProjectIds, withAssigneeNull, assigneeId);
        return grid.getRows(request, this.dslContext);
    }
}

