/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.display.search;

import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;
import org.squashtest.tm.service.annotation.SpringDaoMetaAnnotationAspect;
import org.squashtest.tm.service.display.search.RequirementSearchInputData;
import org.squashtest.tm.service.display.search.RequirementSearchInputDataProvider;
import org.squashtest.tm.service.internal.display.dto.UserView;
import org.squashtest.tm.service.internal.display.search.RequirementSearchInputDataProviderImpl$AjcClosure1;
import org.squashtest.tm.service.internal.repository.ProjectDao;
import org.squashtest.tm.service.internal.repository.UserDao;
import org.squashtest.tm.service.project.ProjectFinder;

@Component
@Transactional(readOnly=true)
public class RequirementSearchInputDataProviderImpl
implements RequirementSearchInputDataProvider {
    private final ProjectFinder projectFinder;
    private final ProjectDao projectDao;
    private final UserDao userDao;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;

    public RequirementSearchInputDataProviderImpl(ProjectFinder projectFinder, ProjectDao projectDao, UserDao userDao) {
        this.projectFinder = projectFinder;
        this.projectDao = projectDao;
        this.userDao = userDao;
    }

    @Override
    public RequirementSearchInputData provide() {
        List<Long> readableProjectIds = this.projectFinder.findAllReadableIds();
        List<UserView> createdUsers = this.findCreatedUserViews(readableProjectIds);
        List<UserView> modifiedUsers = this.findModifiedUserViews(readableProjectIds);
        return new RequirementSearchInputData(createdUsers, modifiedUsers);
    }

    private List<UserView> findCreatedUserViews(List<Long> readableProjectIds) {
        List<String> usersWhoCreatedRequirementVersions = this.projectDao.findUsersWhoCreatedRequirementVersions(readableProjectIds);
        return this.findUserViewsByLogin(usersWhoCreatedRequirementVersions);
    }

    private List<UserView> findModifiedUserViews(List<Long> readableProjectIds) {
        List<String> usersWhoModifiedRequirementVersions = this.projectDao.findUsersWhoModifiedRequirementVersions(readableProjectIds);
        return this.findUserViewsByLogin(usersWhoModifiedRequirementVersions);
    }

    private List<UserView> findUserViewsByLogin(List<String> usersWhoCreatedTestCases) {
        List<String> list = usersWhoCreatedTestCases;
        UserDao userDao = this.userDao;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)userDao, list);
        Object[] objectArray = new Object[]{this, userDao, list, joinPoint};
        RequirementSearchInputDataProviderImpl$AjcClosure1 requirementSearchInputDataProviderImpl$AjcClosure1 = new RequirementSearchInputDataProviderImpl$AjcClosure1(objectArray);
        List users = (List)SpringDaoMetaAnnotationAspect.aspectOf().guardAgainstEmptyness(requirementSearchInputDataProviderImpl$AjcClosure1.linkClosureAndJoinPoint(4112));
        Map userViews = users.stream().map(user -> {
            UserView userView = new UserView();
            userView.setId(user.getId());
            userView.setFirstName(user.getFirstName());
            userView.setLastName(user.getLastName());
            userView.setLogin(user.getLogin());
            return userView;
        }).collect(Collectors.toMap(UserView::getLogin, Function.identity()));
        return usersWhoCreatedTestCases.stream().map(login -> userViews.getOrDefault(login, new UserView((String)login))).toList();
    }

    static {
        RequirementSearchInputDataProviderImpl.ajc$preClinit();
    }

    static final /* synthetic */ List findUsersByLoginIn_aroundBody0(RequirementSearchInputDataProviderImpl requirementSearchInputDataProviderImpl, UserDao userDao, List list, JoinPoint joinPoint) {
        return userDao.findUsersByLoginIn(list);
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("RequirementSearchInputDataProviderImpl.java", RequirementSearchInputDataProviderImpl.class);
        ajc$tjp_0 = factory.makeSJP("method-call", (Signature)factory.makeMethodSig("41000401", "findUsersByLoginIn", "org.squashtest.tm.service.internal.repository.UserDao", "java.util.List", "loginList", "", "java.util.List"), 75);
    }
}

