/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.batchimport.requirement.dto;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jooq.Record5;
import org.jooq.Record6;
import org.jooq.Record7;
import org.jooq.Record8;
import org.squashtest.tm.core.foundation.lang.PathUtils;
import org.squashtest.tm.domain.requirement.RemoteRequirementPerimeterStatus;
import org.squashtest.tm.service.internal.batchimport.Existence;
import org.squashtest.tm.service.internal.batchimport.TargetStatus;
import org.squashtest.tm.service.internal.batchimport.instruction.targets.HighLevelRequirementTarget;
import org.squashtest.tm.service.internal.batchimport.instruction.targets.RequirementTarget;
import org.squashtest.tm.service.internal.batchimport.requirement.tree.ImportedRequirementNode;
import org.squashtest.tm.service.internal.repository.RequirementImportDao;

public class ImportRequirementFinder {
    private final RequirementImportDao dao;
    private final Map<String, List<RequirementNode>> requirements = new HashMap<String, List<RequirementNode>>();
    private final Map<String, List<RequirementNode>> synchronizedRequirements = new HashMap<String, List<RequirementNode>>();
    private final Map<String, List<RequirementNode>> importSynchronizedRequirements = new HashMap<String, List<RequirementNode>>();
    private final Map<String, List<Long>> folders = new HashMap<String, List<Long>>();
    private final Map<String, List<RequirementTarget>> targetsPath;

    public ImportRequirementFinder(RequirementImportDao dao, Set<RequirementTarget> targets) {
        this.dao = dao;
        this.targetsPath = targets.stream().collect(Collectors.groupingBy(RequirementTarget::getPath));
    }

    public ImportedRequirementNode searchRequirementNode(RequirementTarget target) {
        RequirementNode node = null;
        if (this.synchronizedRequirements.containsKey(PathUtils.asSquashPath((String)target.getPath()))) {
            node = this.getSynchronizedRequirementNode(target);
        } else if (this.requirements.containsKey(PathUtils.asSquashPath((String)target.getPath())) && !target.isSynchronized()) {
            node = this.getBasicRequirementNode(target);
        }
        if (node == null) {
            node = this.getImportedSynchronizedRequirementNode(target);
        }
        return node != null ? node.toImportedRequirementNode(target) : null;
    }

    private RequirementNode getSynchronizedRequirementNode(RequirementTarget target) {
        List synchronizedRequirement = this.synchronizedRequirements.getOrDefault(PathUtils.asSquashPath((String)target.getPath()), Collections.emptyList());
        boolean hasOneSynchronizedRequirement = synchronizedRequirement.size() == 1;
        for (RequirementNode requirement : synchronizedRequirement) {
            boolean isTargetMatch;
            if (target.isEmpty() && hasOneSynchronizedRequirement) {
                return requirement;
            }
            boolean bl = isTargetMatch = target.isHighLevel() == requirement.isHighLevel() && Objects.equals(target.getRemoteKey(), requirement.remoteKey()) && Objects.equals(requirement.remoteSyncId(), target.getRemoteSynchronisationId());
            if (!isTargetMatch) continue;
            return requirement;
        }
        return null;
    }

    private RequirementNode getImportedSynchronizedRequirementNode(RequirementTarget target) {
        return this.importSynchronizedRequirements.getOrDefault(PathUtils.asSquashPath((String)target.getPath()), Collections.emptyList()).stream().filter(requirementNode -> this.isCloseMatchingNode((RequirementNode)requirementNode, target)).findFirst().orElse(null);
    }

    private boolean isCloseMatchingNode(RequirementNode requirementNode, RequirementTarget target) {
        boolean isHighLevelMatch;
        if (target.isEmpty()) {
            return true;
        }
        boolean bl = isHighLevelMatch = target.isHighLevel() == requirementNode.isHighLevel();
        if (Objects.isNull(target.getRemoteKey())) {
            return isHighLevelMatch;
        }
        return isHighLevelMatch && Objects.equals(target.getRemoteKey(), requirementNode.remoteKey()) && Objects.equals(target.getRemoteSynchronisationId(), requirementNode.remoteSyncId());
    }

    private RequirementNode getBasicRequirementNode(RequirementTarget target) {
        return this.requirements.getOrDefault(PathUtils.asSquashPath((String)target.getPath()), Collections.emptyList()).stream().findFirst().orElse(null);
    }

    public ImportedRequirementNode searchSynchronizedRequirementParent(String parentPath, Long remoteSyncId) {
        List nodes = this.synchronizedRequirements.getOrDefault(PathUtils.asSquashPath((String)parentPath), Collections.emptyList());
        for (RequirementNode requirement : nodes) {
            if (!requirement.isSynchronized() || !Objects.equals(requirement.remoteSyncId(), remoteSyncId)) continue;
            return requirement.toImportedRequirementNode(parentPath);
        }
        return null;
    }

    public ImportedRequirementNode searchImportedSynchronizedRequirementParent(String parentPath, Long remoteSyncId) {
        List nodes = this.importSynchronizedRequirements.getOrDefault(PathUtils.asSquashPath((String)parentPath), Collections.emptyList());
        return nodes.stream().filter(requirement -> requirement.isSynchronized() && Objects.equals(requirement.remoteSyncId(), remoteSyncId)).findFirst().map(requirementNode -> requirementNode.toImportedRequirementNode(parentPath)).orElse(null);
    }

    public ImportedRequirementNode searchBasicRequirementParent(String parentPath) {
        List nodes = this.requirements.getOrDefault(PathUtils.asSquashPath((String)parentPath), Collections.emptyList());
        for (RequirementNode requirement : nodes) {
            if (requirement.isSynchronized()) continue;
            return requirement.toImportedRequirementNode(parentPath);
        }
        return null;
    }

    public ImportedRequirementNode searchFolderParent(RequirementTarget target) {
        List ids = this.folders.getOrDefault(PathUtils.asSquashPath((String)target.getPath()), Collections.emptyList());
        Iterator iterator = ids.iterator();
        if (iterator.hasNext()) {
            Long id = (Long)iterator.next();
            return ImportedRequirementNode.createRequirementFolderNode(target, new TargetStatus(Existence.EXISTS, id));
        }
        return null;
    }

    public RequirementTarget searchParentTarget(String parentPath, ImportedRequirementNode child) {
        return this.targetsPath.getOrDefault(parentPath, Collections.emptyList()).stream().filter(target -> target.isSynchronized() == child.isSynchronized() && Objects.equals(target.getRemoteSynchronisationId(), child.getRemoteSynchronisationId())).findFirst().orElse(null);
    }

    private boolean targetExist(RequirementTarget target) {
        if (target.isSynchronized()) {
            return this.getSynchronizedRequirementNode(target) != null;
        }
        return this.getBasicRequirementNode(target) != null;
    }

    public void fetch(Set<RequirementTarget> targets, String project) {
        HashSet<String> remoteKeys = new HashSet<String>();
        HashSet<Long> remoteSynchronisationIds = new HashSet<Long>();
        HashSet<String> keys = new HashSet<String>();
        LinkedHashMap<String, String> nodeNames = new LinkedHashMap<String, String>();
        for (RequirementTarget target : targets) {
            if (target.isSynchronized()) {
                String remoteKey = target.getRemoteKey();
                Long remoteSyncId = target.getRemoteSynchronisationId();
                if (remoteSyncId != null) {
                    remoteKeys.add(remoteKey);
                    remoteSynchronisationIds.add(remoteSyncId);
                    continue;
                }
                keys.add(remoteKey);
                continue;
            }
            String parentName = PathUtils.extractParentName((String)target.getPath());
            nodeNames.put(target.getName(), parentName);
        }
        this.fetchRemoteSynchronizedRequirements(remoteSynchronisationIds, remoteKeys);
        this.fetchSynchronizedRequirements(keys, project);
        this.fetchImportedAndBasicRequirements(nodeNames, project);
        this.fetchParentNodes(targets, project);
    }

    private void fetchRemoteSynchronizedRequirements(Set<Long> remoteSynchronisationIds, Set<String> remoteKeys) {
        if (remoteKeys.isEmpty()) {
            return;
        }
        Throwable throwable = null;
        Object var4_5 = null;
        try (Stream<Record6<String, Long, Boolean, String, Long, String>> resultStream = this.dao.findRemoteSyncRequirements(remoteKeys, remoteSynchronisationIds);){
            resultStream.forEach(record -> {
                String path = (String)record.value1();
                Long id = (Long)record.value2();
                boolean isHighLevel = (Boolean)record.value3();
                String remoteKey = (String)record.value4();
                Long remoteSyncId = (Long)record.value5();
                RemoteRequirementPerimeterStatus perimeterStatus = record.value6() != null ? RemoteRequirementPerimeterStatus.valueOf((String)((String)record.value6())) : null;
                this.addSynchronizedRequirement(path, id, isHighLevel, remoteKey, remoteSyncId, perimeterStatus);
            });
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private void fetchSynchronizedRequirements(Set<String> keys, String project) {
        if (keys.isEmpty()) {
            return;
        }
        Throwable throwable = null;
        Object var4_5 = null;
        try (Stream<Record5<String, Long, Boolean, String, String>> resultStream = this.dao.findSyncRequirements(keys, project);){
            resultStream.forEach(record -> {
                String path = (String)record.value1();
                Long id = (Long)record.value2();
                boolean isHighLevel = (Boolean)record.value3();
                String remoteKey = (String)record.value4();
                RemoteRequirementPerimeterStatus perimeterStatus = record.value5() != null ? RemoteRequirementPerimeterStatus.valueOf((String)((String)record.value5())) : null;
                this.addSynchronizedRequirement(path, id, isHighLevel, remoteKey, null, perimeterStatus);
            });
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private void addSynchronizedRequirement(String path, Long id, boolean isHighLevel, String remoteKey, Long remoteSyncId, RemoteRequirementPerimeterStatus perimeterStatus) {
        this.synchronizedRequirements.computeIfAbsent(path, k -> new ArrayList()).add(new RequirementNode(id, isHighLevel, remoteKey, remoteSyncId, null, perimeterStatus));
    }

    private void fetchImportedAndBasicRequirements(Map<String, String> nodeNames, String project) {
        if (nodeNames.isEmpty()) {
            return;
        }
        Throwable throwable = null;
        Object var4_5 = null;
        try (Stream<Record7<String, Long, Boolean, String, Long, String, String>> resultStream = this.dao.findRequirementsByNamesParentNamesAndProject(nodeNames, project);){
            resultStream.forEach(record -> {
                String path = (String)record.value1();
                Long id = (Long)record.value2();
                boolean isHighLevel = (Boolean)record.value3();
                String remoteKey = (String)record.value4();
                Long remoteSyncId = (Long)record.value5();
                String remoteSyncKind = (String)record.value6();
                RemoteRequirementPerimeterStatus perimeterStatus = record.value7() != null ? RemoteRequirementPerimeterStatus.valueOf((String)((String)record.value7())) : null;
                this.addRequirements(path, id, isHighLevel, remoteKey, remoteSyncId, remoteSyncKind, perimeterStatus);
            });
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private void fetchParentNodes(Set<RequirementTarget> targets, String project) {
        Set<String> missingNodesPaths = targets.stream().filter(target -> !this.targetExist((RequirementTarget)target)).map(RequirementTarget::collectParentPaths).map(PathUtils::unescapePathPartSlashes).flatMap(Collection::stream).collect(Collectors.toSet());
        if (missingNodesPaths.isEmpty()) {
            return;
        }
        Throwable throwable = null;
        Object var5_6 = null;
        try (Stream<Record8<String, Long, Boolean, Boolean, String, Long, String, String>> resultStream = this.dao.findNodesByPathAndProject(missingNodesPaths, project);){
            resultStream.forEach(record -> {
                String path = (String)record.value1();
                Long nodeId = (Long)record.value2();
                boolean isRequirement = (Boolean)record.value3();
                if (isRequirement) {
                    boolean isHighLevel = (Boolean)record.value4();
                    String remoteKey = (String)record.value5();
                    Long remoteSyncId = (Long)record.value6();
                    String remoteSyncKind = (String)record.value7();
                    RemoteRequirementPerimeterStatus perimeterStatus = record.value8() != null ? RemoteRequirementPerimeterStatus.valueOf((String)((String)record.value8())) : null;
                    this.addRequirements(path, nodeId, isHighLevel, remoteKey, remoteSyncId, remoteSyncKind, perimeterStatus);
                } else {
                    this.addFolder(path, nodeId);
                }
            });
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private void addFolder(String path, Long id) {
        this.folders.computeIfAbsent(path, k -> new ArrayList()).add(id);
    }

    private void addRequirements(String path, Long nodeId, boolean isHighLevel, String remoteKey, Long remoteSyncId, String remoteSyncKind, RemoteRequirementPerimeterStatus perimeterStatus) {
        RequirementNode node = new RequirementNode(nodeId, isHighLevel, remoteKey, remoteSyncId, remoteSyncKind, perimeterStatus);
        if (remoteKey != null && remoteSyncKind == null) {
            this.synchronizedRequirements.computeIfAbsent(path, k -> new ArrayList()).add(node);
        } else if (remoteSyncKind != null) {
            this.importSynchronizedRequirements.computeIfAbsent(path, k -> new ArrayList()).add(node);
        } else {
            this.requirements.computeIfAbsent(path, k -> new ArrayList()).add(node);
        }
    }

    public void fetch(Set<RequirementTarget> targets, Set<String> projects) {
        Set<String> names = targets.stream().map(RequirementTarget::getName).collect(Collectors.toSet());
        Throwable throwable = null;
        Object var5_6 = null;
        try (Stream<Record6<String, Long, Boolean, String, Long, String>> stream = this.dao.findRequirementsByNamesAndProjects(names, projects);){
            stream.forEach(record -> {
                String path = (String)record.value1();
                Long id = (Long)record.value2();
                boolean isHighLevel = (Boolean)record.value3();
                String remoteKey = (String)record.value4();
                Long remoteSyncId = (Long)record.value5();
                RemoteRequirementPerimeterStatus perimeterStatus = record.value6() != null ? RemoteRequirementPerimeterStatus.valueOf((String)((String)record.value6())) : null;
                this.addRequirements(path, id, isHighLevel, remoteKey, remoteSyncId, null, perimeterStatus);
            });
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public record RequirementNode(Long id, boolean isHighLevel, String remoteKey, Long remoteSyncId, String remoteSyncKind, RemoteRequirementPerimeterStatus perimeterStatus) {
        boolean isSynchronized() {
            return this.remoteKey != null;
        }

        ImportedRequirementNode toImportedRequirementNode(String path) {
            RequirementTarget target = this.isHighLevel ? new HighLevelRequirementTarget(path) : new RequirementTarget(path);
            target.setId(this.id);
            if (this.remoteKey != null) {
                target.setRemoteKey(this.remoteKey);
                target.setRemoteSynchronisationId(this.remoteSyncId);
                target.setRemoteSynchronisationKind(this.remoteSyncKind);
            }
            return ImportedRequirementNode.createRequirementNode(target, new TargetStatus(Existence.EXISTS, this.id), this.isHighLevel);
        }

        ImportedRequirementNode toImportedRequirementNode(RequirementTarget target) {
            target.setId(this.id);
            if (this.remoteKey != null && target.getRemoteKey() == null) {
                target.setRemoteKey(this.remoteKey);
                target.setRemoteSynchronisationId(this.remoteSyncId);
                target.setRemoteSynchronisationKind(this.remoteSyncKind);
                target.setRemotePerimeterStatus(this.perimeterStatus);
            }
            return ImportedRequirementNode.createRequirementNode(target, new TargetStatus(Existence.EXISTS, this.id), this.isHighLevel);
        }
    }
}

