/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.statistics.campaign;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.squashtest.tm.domain.execution.ExecutionStatus;
import org.squashtest.tm.service.statistics.CountOnEnum;

public class TestInventoryStatistics {
    private String name;
    private CountOnEnum<ExecutionStatus> statistics;

    public TestInventoryStatistics() {
        Set<ExecutionStatus> executionStatuses = TestInventoryStatistics.getHandledStatuses();
        this.statistics = new CountOnEnum<ExecutionStatus>(executionStatuses);
    }

    public static Set<ExecutionStatus> getHandledStatuses() {
        return EnumSet.allOf(ExecutionStatus.class).stream().map(ExecutionStatus::getCanonicalStatus).collect(Collectors.toSet());
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setStatistics(CountOnEnum<ExecutionStatus> statistics) {
        this.statistics = statistics;
    }

    public Map<ExecutionStatus, Integer> getStatistics() {
        return this.statistics.getStatistics();
    }

    public void setNumber(int intValue, ExecutionStatus status) {
        this.statistics.add(status.getCanonicalStatus(), intValue);
    }
}

