/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.user;

import jakarta.persistence.EntityManager;
import jakarta.persistence.PersistenceContext;
import jakarta.validation.constraints.NotNull;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.hibernate.Session;
import org.hibernate.query.Query;
import org.springframework.security.access.AccessDeniedException;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.session.SessionInformation;
import org.springframework.security.core.session.SessionRegistry;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.provisioning.UserDetailsManager;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.squashtest.tm.aspect.validation.NotNullValidatorAspect;
import org.squashtest.tm.core.foundation.logger.Logger;
import org.squashtest.tm.core.foundation.logger.LoggerFactory;
import org.squashtest.tm.domain.acl.AclGroup;
import org.squashtest.tm.domain.project.Project;
import org.squashtest.tm.domain.synchronisation.RemoteSynchronisation;
import org.squashtest.tm.domain.users.Team;
import org.squashtest.tm.domain.users.User;
import org.squashtest.tm.domain.users.UsersGroup;
import org.squashtest.tm.exception.IllegalUserGroupTransitionException;
import org.squashtest.tm.exception.WrongStringSizeException;
import org.squashtest.tm.exception.user.ActiveUserDeleteException;
import org.squashtest.tm.exception.user.LoginAlreadyExistsException;
import org.squashtest.tm.exception.user.MilestoneOwnerDeleteException;
import org.squashtest.tm.exception.user.UserWithSynchronisationsDeleteException;
import org.squashtest.tm.security.UserContextHolder;
import org.squashtest.tm.service.configuration.ConfigurationService;
import org.squashtest.tm.service.internal.display.dto.MilestonePossibleOwnerDto;
import org.squashtest.tm.service.internal.dto.AccessPermission;
import org.squashtest.tm.service.internal.repository.ApiTokenDao;
import org.squashtest.tm.service.internal.repository.ProfileDao;
import org.squashtest.tm.service.internal.repository.ProjectDao;
import org.squashtest.tm.service.internal.repository.RemoteSynchronisationDao;
import org.squashtest.tm.service.internal.repository.TeamDao;
import org.squashtest.tm.service.internal.repository.UserDao;
import org.squashtest.tm.service.internal.repository.UsersGroupDao;
import org.squashtest.tm.service.license.LicenseHelperService;
import org.squashtest.tm.service.license.UltimateLicenseAvailabilityService;
import org.squashtest.tm.service.milestone.MilestoneManagerService;
import org.squashtest.tm.service.project.ProjectFilterModificationService;
import org.squashtest.tm.service.project.ProjectsPermissionManagementService;
import org.squashtest.tm.service.security.AdministratorAuthenticationService;
import org.squashtest.tm.service.security.PermissionEvaluationService;
import org.squashtest.tm.service.security.UserAuthenticationService;
import org.squashtest.tm.service.security.UserContextService;
import org.squashtest.tm.service.security.acls.model.ObjectAclService;
import org.squashtest.tm.service.servers.StoredCredentialsManager;
import org.squashtest.tm.service.user.AuthenticatedUser;
import org.squashtest.tm.service.user.LoginValidatorService;
import org.squashtest.tm.service.user.TeamModificationService;
import org.squashtest.tm.service.user.UserAdministrationService;

@Service(value="squashtest.tm.service.AdministrationService")
@Transactional
public class UserAdministrationServiceImpl
implements UserAdministrationService {
    private static final Logger LOGGER = LoggerFactory.getLogger(UserAdministrationServiceImpl.class);
    private static final String PLUGIN_LICENSE_EXPIRATION = "plugin.license.expiration";
    private static final String ACTIVATED_USER_EXCESS = "activated.user.excess";
    public static final String AUTOMATION_WORKSPACE_URL = "/automation-workspace";
    public static final String HOME_WORKSPACE_URL = "/home-workspace";
    private final UserAuthenticationService authService;
    private final UserDetailsManager userDetailsManager;
    private final ProjectDao projectDao;
    private final UserDao userDao;
    private final UsersGroupDao groupDao;
    private final ConfigurationService configurationService;
    private final TeamDao teamDao;
    private final ObjectAclService aclService;
    private final AdministratorAuthenticationService adminAuthentService;
    private final MilestoneManagerService milestoneManagerService;
    private final LicenseHelperService licenseHelperService;
    private final SessionRegistry sessionRegistry;
    private final RemoteSynchronisationDao remoteSynchronisationDao;
    private final ProjectFilterModificationService projectFilterModificationService;
    private final PermissionEvaluationService permissionEvaluationService;
    private final UltimateLicenseAvailabilityService ultimateLicenseAvailabilityService;
    private final ProfileDao profileDao;
    private final UserContextService userContextService;
    private final StoredCredentialsManager storedCredentialsManager;
    private final ApiTokenDao apiTokenDao;
    private final TeamModificationService teamModificationService;
    private final ProjectsPermissionManagementService projectsPermissionManagementService;
    private final LoginValidatorService loginValidatorService;
    @PersistenceContext
    private EntityManager em;

    public UserAdministrationServiceImpl(UserAuthenticationService authService, UserDetailsManager userDetailsManager, ProjectDao projectDao, UserDao userDao, UsersGroupDao groupDao, ConfigurationService configurationService, TeamDao teamDao, ObjectAclService aclService, AdministratorAuthenticationService adminAuthentService, MilestoneManagerService milestoneManagerService, LicenseHelperService licenseHelperService, SessionRegistry sessionRegistry, RemoteSynchronisationDao remoteSynchronisationDao, ProjectFilterModificationService projectFilterModificationService, PermissionEvaluationService permissionEvaluationService, UltimateLicenseAvailabilityService ultimateLicenseAvailabilityService, ProfileDao profileDao, UserContextService userContextService, StoredCredentialsManager storedCredentialsManager, ApiTokenDao apiTokenDao, TeamModificationService teamModificationService, ProjectsPermissionManagementService projectsPermissionManagementService, LoginValidatorService loginValidatorService) {
        this.authService = authService;
        this.userDetailsManager = userDetailsManager;
        this.projectDao = projectDao;
        this.userDao = userDao;
        this.groupDao = groupDao;
        this.configurationService = configurationService;
        this.teamDao = teamDao;
        this.aclService = aclService;
        this.adminAuthentService = adminAuthentService;
        this.milestoneManagerService = milestoneManagerService;
        this.licenseHelperService = licenseHelperService;
        this.sessionRegistry = sessionRegistry;
        this.remoteSynchronisationDao = remoteSynchronisationDao;
        this.projectFilterModificationService = projectFilterModificationService;
        this.permissionEvaluationService = permissionEvaluationService;
        this.ultimateLicenseAvailabilityService = ultimateLicenseAvailabilityService;
        this.profileDao = profileDao;
        this.userContextService = userContextService;
        this.storedCredentialsManager = storedCredentialsManager;
        this.apiTokenDao = apiTokenDao;
        this.teamModificationService = teamModificationService;
        this.projectsPermissionManagementService = projectsPermissionManagementService;
        this.loginValidatorService = loginValidatorService;
    }

    @Override
    public void modifyUserFirstName(long userId, String newName) {
        User user = (User)this.userDao.getReferenceById(userId);
        this.checkPermissions(user);
        user.setFirstName(newName);
    }

    @Override
    public void modifyUserLastName(long userId, String newName) {
        User user = (User)this.userDao.getReferenceById(userId);
        this.checkPermissions(user);
        user.setLastName(newName);
    }

    @Override
    public void modifyUserLogin(long userId, String newLogin) {
        User user;
        String newtrimedLogin = newLogin.trim();
        if (!newtrimedLogin.equals((user = (User)this.userDao.getReferenceById(userId)).getLogin())) {
            LOGGER.debug("Change login for user {} to {}", new Object[]{user.getLogin(), newtrimedLogin});
            this.checkPermissions(user);
            this.loginValidatorService.checkLoginAvailability(newtrimedLogin);
            this.checkMaxLength(newtrimedLogin);
            this.authService.changeUserlogin(newtrimedLogin, user.getLogin());
            user.setLogin(newtrimedLogin);
            this.aclService.refreshAcls();
        } else {
            LOGGER.trace("no change of user login because old and new are the same", new Object[0]);
        }
    }

    @Override
    public void modifyUserEmail(long userId, String newEmail) {
        User user = (User)this.userDao.getReferenceById(userId);
        this.checkPermissions(user);
        user.setEmail(newEmail);
    }

    private void checkMaxLength(String login) {
        if (login.length() > 100) {
            throw new WrongStringSizeException("login", 0, 100);
        }
    }

    private void checkPermissions(User user) {
        user.checkIsNotFromInfrastructureAdminGroup();
        String currentLogin = this.userContextService.getUsername();
        if (!user.getLogin().equals(currentLogin) && !this.userContextService.hasRole("ROLE_ADMIN")) {
            throw new AccessDeniedException("Access is denied");
        }
    }

    @Override
    @PreAuthorize(value="hasRole('ROLE_ADMIN')")
    public AuthenticatedUser findUserById(long userId) {
        User user = (User)this.userDao.getReferenceById(userId);
        boolean hasAuth = this.adminAuthentService.userExists(user.getLogin());
        return new AuthenticatedUser(user, hasAuth);
    }

    @Override
    @PreAuthorize(value="hasRole('ROLE_ADMIN')")
    public List<UsersGroup> findAllUsersGroupOrderedByQualifiedName() {
        return this.groupDao.findAllGroupsOrderByQualifiedName();
    }

    @Override
    @PreAuthorize(value="hasRole('ROLE_ADMIN')")
    public List<UsersGroup> findUsersGroupsOrderedByQualifiedName(Collection<String> qualifiedNames) {
        return this.groupDao.findByQualifiedNamesSorted(qualifiedNames);
    }

    @Override
    @PreAuthorize(value="hasRole('ROLE_ADMIN')")
    public List<UsersGroup> findAllAssignableUsersGroupOrderedByQualifiedName() {
        return this.groupDao.findByQualifiedNamesSorted(UsersGroup.ASSIGNABLE_USER_GROUPS);
    }

    @Override
    @PreAuthorize(value="hasRole('ROLE_ADMIN')")
    public void addUser(User user, String userGroupName, String password) {
        this.licenseHelperService.assertLicenseAllowsToAddOrActivateUser();
        this.createUserWithoutCredentials(user, userGroupName);
        user.checkIsNotFromInfrastructureAdminGroup();
        this.adminAuthentService.createNewUserPassword(user.getLogin(), password, user.getActive(), true, true, true, new ArrayList<GrantedAuthority>());
    }

    @Override
    @PreAuthorize(value="hasRole('ROLE_ADMIN')")
    public void setUserGroupAuthority(long userId, String userGroupName) {
        if (UsersGroup.TECHNICAL_USER_GROUPS.contains(userGroupName)) {
            throw new IllegalUserGroupTransitionException();
        }
        User user = (User)this.userDao.getReferenceById(userId);
        if (UsersGroup.TECHNICAL_USER_GROUPS.contains(user.getGroup().getQualifiedName())) {
            throw new IllegalUserGroupTransitionException();
        }
        UsersGroup group = this.groupDao.findByQualifiedName(userGroupName);
        user.setGroup(group);
        this.aclService.refreshAcls();
        this.expireSessionInformationIfUserIsLogged(user.getLogin());
    }

    private void expireSessionInformationIfUserIsLogged(String login) {
        UserDetails user = this.sessionRegistry.getAllPrincipals().stream().map(springUser -> (UserDetails)springUser).filter(inspectedUser -> login.equals(inspectedUser.getUsername())).findAny().orElse(null);
        if (Objects.nonNull(user)) {
            List targetUserSessionInformationList = this.sessionRegistry.getAllSessions((Object)user, false);
            targetUserSessionInformationList.forEach(SessionInformation::expireNow);
        }
    }

    @Override
    @PreAuthorize(value="hasRole('ROLE_ADMIN')")
    public void deactivateUser(long userId) {
        User user = (User)this.userDao.getReferenceById(userId);
        user.checkIsNotFromInfrastructureAdminGroup();
        this.checkHasSynchronisations(user);
        this.checkActiveUser(user);
        user.setActive(Boolean.valueOf(false));
        this.apiTokenDao.deleteAllByUserId(userId);
        this.adminAuthentService.deactivateAccount(user.getLogin());
        this.aclService.refreshAcls();
    }

    @Override
    @PreAuthorize(value="hasRole('ROLE_ADMIN')")
    public void activateUser(long userId) {
        User user = (User)this.userDao.getReferenceById(userId);
        user.setActive(Boolean.valueOf(true));
        user.checkIsNotFromInfrastructureAdminGroup();
        this.adminAuthentService.activateAccount(user.getLogin());
        this.aclService.refreshAcls();
        this.aclService.refreshAcls();
    }

    @Override
    @PreAuthorize(value="hasRole('ROLE_ADMIN')")
    public void deactivateUsers(Collection<Long> userIds) {
        for (Long id : userIds) {
            this.deactivateUser(id);
        }
    }

    @Override
    @PreAuthorize(value="hasRole('ROLE_ADMIN')")
    public void activateUsers(Collection<Long> userIds) {
        for (Long id : userIds) {
            this.activateUser(id);
        }
    }

    @Override
    @PreAuthorize(value="hasRole('ROLE_ADMIN')")
    public void deleteUsers(Collection<Long> userIds) {
        this.checkUsersOwnMilestones(userIds);
        for (Long id : userIds) {
            User user = (User)this.userDao.getReferenceById(id);
            user.checkIsNotFromInfrastructureAdminGroup();
            this.checkHasSynchronisations(user);
            this.checkActiveUser(user);
            this.projectFilterModificationService.removeProjectFiltersByUserLogin(user.getLogin());
            this.deleteUser(id, user);
        }
        this.aclService.refreshAcls();
    }

    @Override
    public void deleteAllInfrastructureAdminMembers() {
        Set infrastructureAdminIds = this.userDao.findAllUserIdsFromInfrastructureAdminGroup();
        if (infrastructureAdminIds.isEmpty()) {
            LOGGER.debug("No Infrastructure Admin to delete.", new Object[0]);
            return;
        }
        for (Long id : infrastructureAdminIds) {
            User user = (User)this.userDao.getReferenceById(id);
            this.deleteUser(id, user);
        }
        this.aclService.refreshAcls();
    }

    private void deleteUser(Long userId, User user) {
        this.unassignUserFromAllTestPlan(userId);
        this.teamModificationService.removeMemberFromAllTeams(userId);
        this.projectsPermissionManagementService.removeProjectPermissionForAllProjects(userId);
        this.storedCredentialsManager.deleteAllUserCredentials(userId);
        this.apiTokenDao.deleteAllByUserId(userId);
        this.adminAuthentService.deleteAccount(user.getLogin());
        this.userDao.delete(user);
    }

    private void unassignUserFromAllTestPlan(long userId) {
        this.userDao.unassignFromAllCampaignTestPlan(userId);
        this.userDao.unassignFromAllIterationTestPlan(userId);
        this.userDao.unassignFromAllExploratoryExecutions(userId);
    }

    private void checkUsersOwnMilestones(Collection<Long> userIds) {
        if (this.milestoneManagerService.hasMilestone(new ArrayList<Long>(userIds))) {
            throw new MilestoneOwnerDeleteException();
        }
    }

    private void checkHasSynchronisations(User user) {
        if (!this.remoteSynchronisationDao.findByOwnerId(user.getId()).isEmpty()) {
            throw new UserWithSynchronisationsDeleteException();
        }
    }

    private void checkActiveUser(User user) {
        String activeUserName = UserContextHolder.getUsername();
        if (user.getLogin().equals(activeUserName)) {
            throw new ActiveUserDeleteException();
        }
    }

    @Override
    public List<RemoteSynchronisation> getSynchronisationsByUser(Long userId) {
        return this.remoteSynchronisationDao.findByOwnerId(userId);
    }

    @Override
    public List<Project> findAllProjects() {
        return this.projectDao.findAll();
    }

    @Override
    public Map<String, String> findPostLoginInformation() {
        boolean isAdmin;
        String excess;
        HashMap<String, String> result = new HashMap<String, String>();
        String expiration = this.configurationService.findConfiguration(PLUGIN_LICENSE_EXPIRATION);
        if (this.hasInformation(expiration, excess = this.configurationService.findConfiguration(ACTIVATED_USER_EXCESS)) && (isAdmin = this.permissionEvaluationService.hasRole("ROLE_ADMIN"))) {
            if (expiration != null && !expiration.isEmpty()) {
                this.retrieveInformationDate(result, expiration);
            }
            if (excess != null && !excess.isEmpty()) {
                this.retrieveInformationUser(result, excess);
            }
        }
        return result;
    }

    private Map<String, String> retrieveInformationDate(Map<String, String> result, String expiration) {
        Integer expi = Integer.parseInt(expiration);
        if (expi < 0) {
            String messageDate = "warning3";
            result.put("messageDate", messageDate);
            result.put("daysRemaining", expi.toString());
        }
        return result;
    }

    private Map<String, String> retrieveInformationUser(Map<String, String> result, String excess) {
        String[] excesses = excess.split("-");
        if (excesses.length == 3 && !Boolean.parseBoolean(excesses[2])) {
            result.put("messageUser", "warning2");
            result.put("currentUserNb", excesses[0]);
            result.put("maxUserNb", excesses[1]);
        }
        return result;
    }

    private boolean hasInformation(String informationDate, String informationUser) {
        return informationDate != null && !informationDate.isEmpty() || informationUser != null && !informationUser.isEmpty();
    }

    @Override
    @PreAuthorize(value="hasRole('ROLE_ADMIN')")
    public void resetUserPassword(long userId, String newPassword) {
        User user = (User)this.userDao.getReferenceById(userId);
        user.checkIsNotFromInfrastructureAdminGroup();
        this.adminAuthentService.resetUserPassword(user.getLogin(), newPassword);
    }

    @Override
    @PreAuthorize(value="hasRole('ROLE_ADMIN')")
    public void deassociateTeams(long userId, List<Long> teamIds) {
        User user = (User)this.userDao.getReferenceById(userId);
        user.checkIsNotFromInfrastructureAdminGroup();
        List teams = this.teamDao.findAllById(teamIds);
        for (Team team : teams) {
            team.removeMember(user);
        }
        user.removeTeams(teamIds);
        this.aclService.refreshAcls();
    }

    @Override
    @PreAuthorize(value="hasRole('ROLE_ADMIN')")
    public Set<String> associateToTeams(long userId, List<Long> teamIds) {
        User user = (User)this.userDao.getReferenceById(userId);
        user.checkIsNotFromInfrastructureAdminGroup();
        List teams = this.teamDao.findAllById(teamIds);
        Set<String> teamsWithCustomProfiles = this.removeTeamsWithCustomProfile(teams, teamIds);
        for (Team team : teams) {
            team.addMember(user);
            user.addTeam(team);
        }
        this.aclService.refreshAcls();
        return teamsWithCustomProfiles;
    }

    private Set<String> removeTeamsWithCustomProfile(List<Team> teams, List<Long> teamIds) {
        if (this.ultimateLicenseAvailabilityService.isAvailable()) {
            return Collections.emptySet();
        }
        HashSet<String> teamsWithCustomProfiles = new HashSet<String>();
        Map teamsAndProfileNames = this.profileDao.findProfileNamesByPartyIds(teamIds);
        teamsAndProfileNames.forEach((teamId, profileNames) -> this.removeTeamWithCustomProfile(teams, (long)teamId, (List<String>)profileNames, (Set<String>)teamsWithCustomProfiles));
        return teamsWithCustomProfiles;
    }

    private void removeTeamWithCustomProfile(List<Team> teams, long teamId, List<String> profileNames, Set<String> teamsWithCustomProfiles) {
        String teamName;
        if (profileNames.stream().anyMatch(profileName -> !AclGroup.isSystem((String)profileName)) && Objects.nonNull(teamName = this.findTeamNameById(teams, teamId))) {
            teamsWithCustomProfiles.add(teamName);
            teams.removeIf(team -> team.getId().equals(teamId));
        }
    }

    private String findTeamNameById(List<Team> teams, Long teamId) {
        return teams.stream().filter(team -> team.getId().equals(teamId)).map(Team::getName).findFirst().orElse(null);
    }

    @Override
    @PreAuthorize(value="hasRole('ROLE_ADMIN')")
    public List<Team> findAllNonAssociatedTeams(long userId) {
        return this.teamDao.findAllNonAssociatedTeams(userId);
    }

    @Override
    public User findByLogin(String login) {
        String string = login;
        NotNullValidatorAspect.aspectOf().ajc$before$org_squashtest_tm_aspect_validation_NotNullValidatorAspect$1$53d01289((Object)string);
        return this.userDao.findUserByLogin(login);
    }

    @Override
    public User createUserFromLogin(@NotNull String login) throws LoginAlreadyExistsException {
        String string = login;
        NotNullValidatorAspect.aspectOf().ajc$before$org_squashtest_tm_aspect_validation_NotNullValidatorAspect$1$53d01289((Object)string);
        this.licenseHelperService.assertLicenseAllowsToAddOrActivateUser();
        String loginTrim = login.trim();
        this.loginValidatorService.checkLoginAvailability(loginTrim);
        User user = User.createFromLogin((String)loginTrim);
        UsersGroup defaultGroup = this.groupDao.findByQualifiedName("squashtest.authz.group.tm.User");
        user.setGroup(defaultGroup);
        this.userDao.save(user);
        return user;
    }

    @Override
    public void createUserWithoutCredentials(User user, long groupId) {
        this.loginValidatorService.checkLoginAvailability(user.getLogin());
        UsersGroup group = (UsersGroup)this.groupDao.getReferenceById(groupId);
        user.setGroup(group);
        this.userDao.save(user);
    }

    @Override
    public void createUserWithoutCredentials(User user, String userGroupeName) {
        this.loginValidatorService.checkLoginAvailability(user.getLogin());
        UsersGroup group = this.groupDao.findByQualifiedName(userGroupeName);
        user.setGroup(group);
        this.userDao.save(user);
    }

    @Override
    public User createInfrastructureAdmin() {
        User user = User.createInfrastructureAdmin();
        Long infraAdminGroupId = this.groupDao.findByQualifiedName("squashtest.authz.group.tm.InfrastructureAdmin").getId();
        this.createUserWithoutCredentials(user, infraAdminGroupId);
        org.springframework.security.core.userdetails.User springUser = new org.springframework.security.core.userdetails.User(user.getLogin(), "", new ArrayList());
        this.userDetailsManager.createUser((UserDetails)springUser);
        return user;
    }

    @Override
    public List<MilestonePossibleOwnerDto> findAllAdminOrManager() {
        this.permissionEvaluationService.checkAtLeastOneMilestoneManagementPermissionOrAdmin();
        return this.userDao.findAllAdminOrManager();
    }

    @Override
    public List<String> findAllDuplicateLogins() {
        return this.em.createNamedQuery("User.findAllDuplicateLogins").getResultList();
    }

    @Override
    public String findCaseAwareLogin(String login) {
        Query query = ((Session)this.em.unwrap(Session.class)).createNamedQuery("User.findCaseAwareLogin", String.class);
        query.setParameter("login", (Object)login);
        return (String)query.uniqueResult();
    }

    @Override
    @PreAuthorize(value="hasRole('ROLE_ADMIN')")
    public int countAllActiveUsers() {
        return this.userDao.countAllActiveUsers();
    }

    @Override
    public void changeCanDeleteFromFront(List<Long> userIds, boolean canDeleteFromFront) {
        List users = this.userDao.findAllById(userIds);
        users.forEach(user -> user.setCanDeleteFromFront(canDeleteFromFront));
    }

    @Override
    public void changeCanDeleteFromFront(long userId, boolean canDeleteFromFront) {
        User user = (User)this.userDao.getReferenceById(userId);
        user.checkIsNotFromInfrastructureAdminGroup();
        user.setCanDeleteFromFront(canDeleteFromFront);
    }

    @Override
    public String findLoginByUserId(long userId) {
        return this.userDao.findUserLoginById(userId);
    }

    @Override
    public String getDefaultAuthenticatedRedirectUrlForUserAuthority() {
        return this.isUserProgrammerButNotTester() ? AUTOMATION_WORKSPACE_URL : HOME_WORKSPACE_URL;
    }

    @Override
    public String findUserGroupQualifiedName(@NotNull String login) {
        String string = login;
        NotNullValidatorAspect.aspectOf().ajc$before$org_squashtest_tm_aspect_validation_NotNullValidatorAspect$1$53d01289((Object)string);
        return this.userDao.findUserGroupQualifiedName(login);
    }

    private boolean isUserProgrammerButNotTester() {
        Set<AccessPermission> accessPermissions = this.permissionEvaluationService.findAccessPermissions();
        return accessPermissions.contains((Object)AccessPermission.WRITE_AS_AUTOMATION) && !accessPermissions.contains((Object)AccessPermission.WRITE_AS_FUNCTIONAL);
    }
}

