/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.repository.hibernate;

import jakarta.inject.Inject;
import jakarta.persistence.EntityManager;
import jakarta.persistence.PersistenceContext;
import jakarta.persistence.Query;
import java.util.List;
import java.util.Map;
import org.jooq.DSLContext;
import org.jooq.Field;
import org.jooq.SelectField;
import org.jooq.TableLike;
import org.squashtest.tm.domain.environmenttag.AutomationEnvironmentTagHolder;
import org.squashtest.tm.domain.testautomation.TestAutomationServerKind;
import org.squashtest.tm.jooq.domain.Tables;
import org.squashtest.tm.jooq.domain.tables.AutomationEnvironmentTag;
import org.squashtest.tm.jooq.domain.tables.Project;
import org.squashtest.tm.jooq.domain.tables.TestAutomationServer;
import org.squashtest.tm.service.internal.repository.CustomTestAutomationServerDao;
import org.squashtest.tm.service.internal.repository.display.utils.ConditionsConstants;

public class TestAutomationServerDaoImpl
implements CustomTestAutomationServerDao {
    @PersistenceContext
    private EntityManager em;
    @Inject
    private DSLContext dsl;

    @Override
    public boolean hasBoundProjects(long serverId) {
        Query q = this.em.createNamedQuery("testAutomationServer.hasBoundProjects");
        q.setParameter("serverId", (Object)serverId);
        Long count = (Long)q.getSingleResult();
        return count > 0L;
    }

    @Override
    public void deleteServer(long serverId) {
        this.dereferenceProjects(serverId);
        this.em.flush();
        this.deleteServerById(serverId);
        this.em.flush();
    }

    @Override
    public List<String> getEnvironmentTags(long testAutomationServerId) {
        return this.dsl.select((SelectField)AutomationEnvironmentTag.AUTOMATION_ENVIRONMENT_TAG.VALUE).from((TableLike)AutomationEnvironmentTag.AUTOMATION_ENVIRONMENT_TAG).where(AutomationEnvironmentTag.AUTOMATION_ENVIRONMENT_TAG.ENTITY_TYPE.eq((Object)AutomationEnvironmentTagHolder.TEST_AUTOMATION_SERVER.name()).and(AutomationEnvironmentTag.AUTOMATION_ENVIRONMENT_TAG.ENTITY_ID.eq((Object)testAutomationServerId))).fetchInto(String.class);
    }

    @Override
    public String getAdditionalConfigurationByProjectId(long projectId) {
        return (String)this.dsl.select((SelectField)TestAutomationServer.TEST_AUTOMATION_SERVER.ADDITIONAL_CONFIGURATION).from((TableLike)TestAutomationServer.TEST_AUTOMATION_SERVER).join((TableLike)Project.PROJECT).on(Project.PROJECT.TA_SERVER_ID.eq((Field)TestAutomationServer.TEST_AUTOMATION_SERVER.SERVER_ID)).and(Project.PROJECT.PROJECT_ID.eq((Object)projectId)).fetchOneInto(String.class);
    }

    @Override
    public Map<Long, Long> findIdsByIterationId(Long iterationId) {
        return this.dsl.selectDistinct((SelectField)Project.PROJECT.PROJECT_ID, (SelectField)TestAutomationServer.TEST_AUTOMATION_SERVER.SERVER_ID).from((TableLike)TestAutomationServer.TEST_AUTOMATION_SERVER).join((TableLike)Project.PROJECT).on(Project.PROJECT.TA_SERVER_ID.eq((Field)TestAutomationServer.TEST_AUTOMATION_SERVER.SERVER_ID)).join((TableLike)Tables.TEST_CASE_LIBRARY_NODE).on(Tables.TEST_CASE_LIBRARY_NODE.PROJECT_ID.eq((Field)Project.PROJECT.PROJECT_ID).and(ConditionsConstants.TCLN_NOT_IN_BIN)).join((TableLike)Tables.TEST_CASE).on(Tables.TEST_CASE.TCLN_ID.eq((Field)Tables.TEST_CASE_LIBRARY_NODE.TCLN_ID)).join((TableLike)Tables.TEST_PLAN_ITEM).on(Tables.TEST_PLAN_ITEM.TCLN_ID.eq((Field)Tables.TEST_CASE_LIBRARY_NODE.TCLN_ID)).join((TableLike)Tables.ITERATION).on(Tables.TEST_PLAN_ITEM.TEST_PLAN_ID.eq((Field)Tables.ITERATION.TEST_PLAN_ID)).where(Tables.ITERATION.ITERATION_ID.eq((Object)iterationId)).and(TestAutomationServer.TEST_AUTOMATION_SERVER.KIND.eq((Object)"squashOrchestrator")).and(Tables.TEST_CASE.AUTOMATED_TEST_REFERENCE.isNotNull()).and(Tables.TEST_CASE.AUTOMATED_TEST_TECHNOLOGY.isNotNull()).and(Tables.TEST_CASE.SCM_REPOSITORY_ID.isNotNull()).fetchMap((Field)Project.PROJECT.PROJECT_ID, (Field)TestAutomationServer.TEST_AUTOMATION_SERVER.SERVER_ID);
    }

    @Override
    public Map<Long, Long> findIdsByTestSuiteId(Long testSuiteId) {
        return this.dsl.selectDistinct((SelectField)Project.PROJECT.PROJECT_ID, (SelectField)TestAutomationServer.TEST_AUTOMATION_SERVER.SERVER_ID).from((TableLike)TestAutomationServer.TEST_AUTOMATION_SERVER).join((TableLike)Project.PROJECT).on(Project.PROJECT.TA_SERVER_ID.eq((Field)TestAutomationServer.TEST_AUTOMATION_SERVER.SERVER_ID)).join((TableLike)Tables.TEST_CASE_LIBRARY_NODE).on(Tables.TEST_CASE_LIBRARY_NODE.PROJECT_ID.eq((Field)Project.PROJECT.PROJECT_ID).and(ConditionsConstants.TCLN_NOT_IN_BIN)).join((TableLike)Tables.TEST_CASE).on(Tables.TEST_CASE.TCLN_ID.eq((Field)Tables.TEST_CASE_LIBRARY_NODE.TCLN_ID)).join((TableLike)Tables.TEST_PLAN_ITEM).on(Tables.TEST_PLAN_ITEM.TCLN_ID.eq((Field)Tables.TEST_CASE_LIBRARY_NODE.TCLN_ID)).join((TableLike)Tables.TEST_SUITE_TEST_PLAN_ITEM).on(Tables.TEST_SUITE_TEST_PLAN_ITEM.TPI_ID.eq((Field)Tables.TEST_PLAN_ITEM.TEST_PLAN_ITEM_ID)).where(Tables.TEST_SUITE_TEST_PLAN_ITEM.SUITE_ID.eq((Object)testSuiteId)).and(TestAutomationServer.TEST_AUTOMATION_SERVER.KIND.eq((Object)TestAutomationServerKind.squashOrchestrator.name())).and(Tables.TEST_CASE.AUTOMATED_TEST_REFERENCE.isNotNull()).and(Tables.TEST_CASE.AUTOMATED_TEST_TECHNOLOGY.isNotNull()).and(Tables.TEST_CASE.SCM_REPOSITORY_ID.isNotNull()).fetchMap((Field)Project.PROJECT.PROJECT_ID, (Field)TestAutomationServer.TEST_AUTOMATION_SERVER.SERVER_ID);
    }

    @Override
    public Long findTestAutomationServerIdByGenericProjectId(Long genericProjectId) {
        return (Long)this.dsl.select((SelectField)Project.PROJECT.TA_SERVER_ID).from((TableLike)Project.PROJECT).where(Project.PROJECT.PROJECT_ID.eq((Object)genericProjectId)).fetchOneInto(Long.class);
    }

    private void dereferenceProjects(long serverId) {
        Query q = this.em.createNamedQuery("testAutomationServer.dereferenceProjects");
        q.setParameter("serverId", (Object)serverId);
        q.executeUpdate();
    }

    private void deleteServerById(long serverId) {
        Query q = this.em.createNamedQuery("testAutomationServer.deleteServer");
        q.setParameter("serverId", (Object)serverId);
        q.executeUpdate();
    }
}

