/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.repository.display.impl.collectors.libraries;

import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.jooq.DSLContext;
import org.jooq.Field;
import org.jooq.GroupField;
import org.jooq.SelectField;
import org.jooq.Table;
import org.jooq.TableField;
import org.jooq.TableLike;
import org.jooq.impl.DSL;
import org.springframework.stereotype.Component;
import org.squashtest.tm.domain.NodeReference;
import org.squashtest.tm.domain.NodeType;
import org.squashtest.tm.domain.customreport.CustomReportTreeDefinition;
import org.squashtest.tm.jooq.domain.Tables;
import org.squashtest.tm.jooq.domain.tables.records.ProjectRecord;
import org.squashtest.tm.service.internal.display.grid.DataRow;
import org.squashtest.tm.service.internal.repository.display.CustomFieldValueDisplayDao;
import org.squashtest.tm.service.internal.repository.display.MilestoneDisplayDao;
import org.squashtest.tm.service.internal.repository.display.TreeNodeCollector;
import org.squashtest.tm.service.internal.repository.display.impl.collectors.libraries.AbstractLibraryCollector;
import org.squashtest.tm.service.milestone.ActiveMilestoneHolder;

@Component
public class CustomReportLibraryCollector
extends AbstractLibraryCollector
implements TreeNodeCollector {
    public CustomReportLibraryCollector(DSLContext dsl, CustomFieldValueDisplayDao customFieldValueDisplayDao, ActiveMilestoneHolder activeMilestoneHolder, MilestoneDisplayDao milestoneDisplayDao) {
        super(dsl, customFieldValueDisplayDao, activeMilestoneHolder, milestoneDisplayDao);
    }

    @Override
    protected Map<Long, DataRow> doCollect(List<Long> ids) {
        Map<Long, DataRow> libraryRows = this.dsl.select((SelectField)Tables.PROJECT.PROJECT_ID.as("projectId"), (SelectField)Tables.PROJECT.NAME, (SelectField)Tables.CUSTOM_REPORT_LIBRARY_NODE.CRLN_ID, (SelectField)Tables.CUSTOM_REPORT_LIBRARY.CRL_ID, (SelectField)DSL.count((Field)Tables.CRLN_RELATIONSHIP.DESCENDANT_ID).as("CHILD_COUNT")).from((TableLike)Tables.CUSTOM_REPORT_LIBRARY_NODE).innerJoin((TableLike)Tables.CUSTOM_REPORT_LIBRARY).on(Tables.CUSTOM_REPORT_LIBRARY_NODE.ENTITY_ID.eq((Field)Tables.CUSTOM_REPORT_LIBRARY.CRL_ID)).and(Tables.CUSTOM_REPORT_LIBRARY_NODE.ENTITY_TYPE.eq((Object)CustomReportTreeDefinition.LIBRARY.name())).innerJoin((TableLike)Tables.PROJECT).on(Tables.PROJECT.CRL_ID.eq((Field)Tables.CUSTOM_REPORT_LIBRARY.CRL_ID)).leftJoin((TableLike)Tables.CRLN_RELATIONSHIP).on(Tables.CRLN_RELATIONSHIP.ANCESTOR_ID.eq((Field)Tables.CUSTOM_REPORT_LIBRARY_NODE.CRLN_ID)).where(Tables.CUSTOM_REPORT_LIBRARY_NODE.CRLN_ID.in(ids)).groupBy(new GroupField[]{Tables.CUSTOM_REPORT_LIBRARY_NODE.CRLN_ID, Tables.CUSTOM_REPORT_LIBRARY.CRL_ID, Tables.PROJECT.PROJECT_ID, Tables.CRLN_RELATIONSHIP.ANCESTOR_ID}).fetch().stream().collect(Collectors.toMap(tuple -> (Long)tuple.get((Field)Tables.CUSTOM_REPORT_LIBRARY_NODE.CRLN_ID), tuple -> {
            DataRow dataRow = new DataRow();
            dataRow.setId(new NodeReference(this.getHandledEntityType(), (Long)tuple.get((Field)Tables.CUSTOM_REPORT_LIBRARY_NODE.CRLN_ID)).toNodeId());
            dataRow.setProjectId((Long)tuple.get("projectId", Long.class));
            dataRow.setState((Integer)tuple.get("CHILD_COUNT", Integer.class) > 0 ? DataRow.State.closed : DataRow.State.leaf);
            dataRow.setData(tuple.intoMap());
            return dataRow;
        }));
        this.appendMilestonesByProject(libraryRows);
        return libraryRows;
    }

    @Override
    protected TableField<ProjectRecord, Long> getLibraryColumnInProjectTable() {
        return Tables.PROJECT.CRL_ID;
    }

    @Override
    protected Field<Long> getLibraryIdColumnInContentTable() {
        return Tables.CRLN_RELATIONSHIP.ANCESTOR_ID;
    }

    @Override
    protected Field<Long> getContentIdColumnInContentTable() {
        return Tables.CRLN_RELATIONSHIP.DESCENDANT_ID;
    }

    @Override
    protected Table<?> getLibraryContentTable() {
        return Tables.CRLN_RELATIONSHIP;
    }

    @Override
    protected Table<?> getLibraryTable() {
        return Tables.CUSTOM_REPORT_LIBRARY;
    }

    @Override
    protected TableField<?, Long> getLibraryPrimaryKeyColumn() {
        return Tables.CUSTOM_REPORT_LIBRARY.CRL_ID;
    }

    @Override
    public NodeType getHandledEntityType() {
        return NodeType.CUSTOM_REPORT_LIBRARY;
    }
}

