/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.pivot.projectimporter.xrayimporter;

import org.squashtest.tm.core.foundation.logger.Logger;
import org.squashtest.tm.core.foundation.logger.LoggerFactory;
import org.squashtest.tm.exception.pivot.projectimporter.xrayimporter.XrayParsingException;
import org.squashtest.tm.service.internal.pivot.projectimporter.xrayimporter.ProjectImporterXrayToTableServiceImpl;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public record XrayValidationErrorHandler(String fileName) implements ErrorHandler
{
    private static final Logger LOGGER = LoggerFactory.getLogger(ProjectImporterXrayToTableServiceImpl.class);

    @Override
    public void warning(SAXParseException exception) throws SAXException {
        LOGGER.warn("Xray import warning in file {} at line {}, column {}:", new Object[]{this.fileName, exception.getLineNumber(), exception.getColumnNumber(), exception});
    }

    @Override
    public void error(SAXParseException exception) throws SAXException {
        throw new XrayParsingException(this.fileName, exception.getLineNumber(), exception.getColumnNumber(), false, (Throwable)exception);
    }

    @Override
    public void fatalError(SAXParseException exception) throws SAXException {
        throw new XrayParsingException(this.fileName, exception.getLineNumber(), exception.getColumnNumber(), true, (Throwable)exception);
    }
}

