/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.campaign.export;

import java.io.File;
import java.io.IOException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Stream;
import org.jooq.Field;
import org.jooq.Record;
import org.jooq.ResultQuery;
import org.squashtest.tm.core.foundation.exception.ActionException;
import org.squashtest.tm.core.foundation.lang.DateUtils;
import org.squashtest.tm.domain.customfield.BindableEntity;
import org.squashtest.tm.jooq.domain.Tables;
import org.squashtest.tm.service.feature.FeatureManager;
import org.squashtest.tm.service.internal.campaign.export.CampaignExportHeader;
import org.squashtest.tm.service.internal.campaign.export.CampaignExportMode;
import org.squashtest.tm.service.internal.campaign.export.CampaignExportRows;
import org.squashtest.tm.service.internal.dto.CustomFieldValueDto;
import org.squashtest.tm.service.internal.dto.FileDto;
import org.squashtest.tm.service.internal.filemanagement.writer.CSVWriter;
import org.squashtest.tm.service.internal.filemanagement.writer.WriterFactory;
import org.squashtest.tm.service.internal.jooq.SubElementRecordProcessor;

public abstract class AbstractCampaignExport {
    protected final FeatureManager featureManager;
    private final WriterFactory writerFactory;

    protected AbstractCampaignExport(FeatureManager featureManager, WriterFactory writerFactory) {
        this.featureManager = featureManager;
        this.writerFactory = writerFactory;
    }

    protected boolean milestoneIsEnabled() {
        return this.featureManager.isEnabled(FeatureManager.Feature.MILESTONE);
    }

    public void doExport(Appendable appendable, Long campaignId, CampaignExportMode exportMode) {
        boolean milestonesEnabled = this.milestoneIsEnabled();
        Map<BindableEntity, List<String>> cufHeaders = this.getCufHeader(campaignId);
        CampaignExportRows campaignExportRows = new CampaignExportRows(exportMode, cufHeaders, milestonesEnabled);
        Throwable throwable = null;
        Object var8_9 = null;
        try (CSVWriter csvWriter = this.writerFactory.createDefaultCSVWriter(appendable);){
            csvWriter.write(campaignExportRows.getHeaderNames());
            this.processExport(campaignId, campaignExportRows, csvWriter);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private Map<BindableEntity, List<String>> getCufHeader(Long campaignId) {
        List<BindableEntity> bindableEntities = this.getBindableEntities();
        if (bindableEntities.isEmpty()) {
            return Map.of();
        }
        return this.getCufHeader(campaignId, bindableEntities);
    }

    private void processExport(Long campaignId, CampaignExportRows campaignExportRows, CSVWriter csvWriter) {
        CalculateOrder calculateOrder = new CalculateOrder();
        Map<BindableEntity, SubElementRecordProcessor<CustomFieldValueDto>> cufProcessors = null;
        HashMap cufStorages = new HashMap();
        try {
            cufProcessors = this.getCufProcessors(campaignId);
            Throwable throwable = null;
            Object var8_9 = null;
            try (Stream recordStream = this.getQuery(campaignId).fetchStream();){
                Map<BindableEntity, SubElementRecordProcessor<CustomFieldValueDto>> finalCufProcessors = cufProcessors;
                recordStream.forEach(record -> {
                    this.computeRecordToExportRow((Record)record, campaignExportRows, finalCufProcessors, cufStorages, calculateOrder);
                    csvWriter.write(campaignExportRows.getRow().values());
                });
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        finally {
            if (cufProcessors != null) {
                cufProcessors.values().forEach(SubElementRecordProcessor::close);
            }
        }
    }

    private void computeRecordToExportRow(Record record, CampaignExportRows campaignExportRows, Map<BindableEntity, SubElementRecordProcessor<CustomFieldValueDto>> cufProcessors, Map<BindableEntity, CufStorage> cufStorages, CalculateOrder calculateOrder) {
        campaignExportRows.getHeaderNames().forEach(headerName -> {
            CampaignExportHeader header = campaignExportRows.getHeaderColumn((String)headerName);
            if (CampaignExportHeader.isCufHeader(header)) {
                this.computeCufToExportRow(record, (String)headerName, header, campaignExportRows, cufProcessors, cufStorages);
                return;
            }
            this.computeValueToExportRow(record, (String)headerName, header, campaignExportRows, calculateOrder);
        });
    }

    private void computeValueToExportRow(Record record, String headerName, CampaignExportHeader header, CampaignExportRows campaignExportRows, CalculateOrder calculateOrder) {
        Object value = switch (header) {
            case CampaignExportHeader.STEP_NUM -> calculateOrder.getNextStep((Long)record.get(header.getField()));
            case CampaignExportHeader.EXEC_STEP_DATE, CampaignExportHeader.EXEC_STEP_USER, CampaignExportHeader.COUNT_EXEC_STEP_ISSUES, CampaignExportHeader.EXEC_STEP_COMMENT -> this.computeExecStepValue(record, header);
            default -> record.get(header.getField());
        };
        campaignExportRows.addValue(header, headerName, value);
    }

    private Object computeExecStepValue(Record record, CampaignExportHeader header) {
        if (record.get((Field)Tables.EXECUTION_STEP.EXECUTION_STEP_ID) == null) {
            return "n/a";
        }
        return record.get(header.getField());
    }

    private void computeCufToExportRow(Record record, String headerName, CampaignExportHeader header, CampaignExportRows campaignExportRows, Map<BindableEntity, SubElementRecordProcessor<CustomFieldValueDto>> cufProcessors, Map<BindableEntity, CufStorage> cufStorages) {
        Long id = (Long)record.get(header.getField());
        BindableEntity bindableEntity = CampaignExportHeader.toBindableEntity(header);
        if (Objects.isNull(id) || !cufProcessors.containsKey(bindableEntity)) {
            return;
        }
        String cufCode = campaignExportRows.getCufCodeFromHeader(headerName);
        SubElementRecordProcessor<CustomFieldValueDto> cufProcessor = cufProcessors.get(bindableEntity);
        CufStorage cufStorage = cufStorages.get(bindableEntity);
        if (Objects.isNull(cufStorage) || !Objects.equals(cufStorage.entityId(), id)) {
            cufStorage = new CufStorage(id, cufProcessor.getSubElements(id, false));
            cufStorages.put(bindableEntity, cufStorage);
        }
        String value = cufStorage.getValue(cufCode);
        campaignExportRows.addValue(header, headerName, value);
    }

    protected abstract Map<BindableEntity, List<String>> getCufHeader(Long var1, List<BindableEntity> var2);

    protected abstract ResultQuery<Record> getQuery(Long var1);

    protected abstract List<BindableEntity> getBindableEntities();

    protected abstract Map<BindableEntity, SubElementRecordProcessor<CustomFieldValueDto>> getCufProcessors(Long var1);

    public FileDto getExportFile(CampaignExportMode exportMode, String campaignName) {
        try {
            String fileName = AbstractCampaignExport.buildFileName(exportMode, campaignName);
            String extension = ".csv";
            File file = File.createTempFile(fileName, extension);
            file.deleteOnExit();
            return new FileDto(fileName, file, extension);
        }
        catch (IOException e) {
            throw new ActionException("campaign export : I/O failure while creating the temporary file", (Throwable)e);
        }
    }

    private static String buildFileName(CampaignExportMode exportMode, String campaignName) {
        String encodedCampaignName = URLEncoder.encode(campaignName, StandardCharsets.UTF_8).replace(" ", "_");
        return String.format("EXPORT_CPG_%s_%s_%s", exportMode.getCode(), encodedCampaignName, DateUtils.getFormatedLongDate());
    }

    private static class CalculateOrder {
        private Long stepOrder = 1L;
        private Long tpiId;

        private CalculateOrder() {
        }

        public Long getNextStep(Long tpiId) {
            if (Objects.isNull(tpiId) || !tpiId.equals(this.tpiId)) {
                this.setTpiId(tpiId);
                this.resetStepOrder();
            }
            Long l = this.stepOrder;
            this.stepOrder = l + 1L;
            return l;
        }

        private void setTpiId(Long tpiId) {
            this.tpiId = tpiId;
        }

        private void resetStepOrder() {
            this.stepOrder = 1L;
        }
    }

    private record CufStorage(Long entityId, Map<String, String> valueByCode) {
        CufStorage(Long entityId, List<CustomFieldValueDto> dtos) {
            this(entityId, new HashMap<String, String>());
            this.appendCufValues(dtos, this.valueByCode);
        }

        private void appendCufValues(List<CustomFieldValueDto> dtos, Map<String, String> valueByCode) {
            dtos.forEach(dto -> {
                String string = valueByCode.put(dto.getCufCode(), dto.getValue());
            });
        }

        private String getValue(String code) {
            return this.valueByCode.get(code);
        }
    }
}

