/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.api.repository;

import jakarta.annotation.PostConstruct;
import jakarta.persistence.EntityManager;
import jakarta.persistence.EntityManagerFactory;
import java.util.Objects;
import org.hibernate.Session;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.event.service.spi.EventListenerRegistry;
import org.hibernate.event.spi.EventType;
import org.jooq.ExecuteContext;
import org.jooq.ExecuteListener;
import org.springframework.orm.jpa.EntityManagerFactoryUtils;
import org.squashtest.tm.core.foundation.logger.Logger;
import org.squashtest.tm.core.foundation.logger.LoggerFactory;
import org.squashtest.tm.service.internal.api.repository.CustomDirtyCheckEventListener;

public class JooqSessionGuard
implements ExecuteListener {
    private static final long serialVersionUID = -1160353334489824965L;
    private static final Logger LOGGER = LoggerFactory.getLogger(JooqSessionGuard.class);
    private final EntityManagerFactory entityManagerFactory;

    public JooqSessionGuard(EntityManagerFactory entityManagerFactory) {
        this.entityManagerFactory = entityManagerFactory;
    }

    @PostConstruct
    public void registerCustomListeners() {
        SessionFactoryImplementor sessionFactory = (SessionFactoryImplementor)this.entityManagerFactory.unwrap(SessionFactoryImplementor.class);
        EventListenerRegistry registry = (EventListenerRegistry)sessionFactory.getServiceRegistry().getService(EventListenerRegistry.class);
        assert (registry != null);
        registry.getEventListenerGroup(EventType.DIRTY_CHECK).clearListeners();
        registry.getEventListenerGroup(EventType.DIRTY_CHECK).appendListener((Object)new CustomDirtyCheckEventListener());
    }

    public void executeStart(ExecuteContext ctx) {
        Session currentSession;
        LOGGER.trace("Checking Hibernate Session before executing a request through jooq execution pipeline", new Object[0]);
        EntityManager entityManager = EntityManagerFactoryUtils.getTransactionalEntityManager((EntityManagerFactory)this.entityManagerFactory);
        if (Objects.nonNull(entityManager) && (currentSession = (Session)entityManager.unwrap(Session.class)).isOpen() && currentSession.isDirty()) {
            LOGGER.debug("Hibernate Session is open and dirty. Will force a flush to prevent stale results of jooq request", new Object[0]);
            currentSession.flush();
        }
    }
}

