/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.deletion;

import java.util.ArrayList;
import java.util.Collection;
import org.squashtest.tm.service.deletion.Node;
import org.squashtest.tm.service.deletion.NodeMovement;
import org.squashtest.tm.service.deletion.NodeReferenceChanged;
import org.squashtest.tm.service.deletion.NodeRenaming;

public class OperationReport {
    private final Collection<Node> removed = new ArrayList<Node>();
    private final Collection<NodeRenaming> renamed = new ArrayList<NodeRenaming>();
    private final Collection<NodeMovement> moved = new ArrayList<NodeMovement>();
    private final Collection<NodeReferenceChanged> refchanges = new ArrayList<NodeReferenceChanged>();
    private final Collection<Node> restored = new ArrayList<Node>();

    public Collection<Node> getRemoved() {
        return this.removed;
    }

    public Collection<NodeRenaming> getRenamed() {
        return this.renamed;
    }

    public Collection<NodeMovement> getMoved() {
        return this.moved;
    }

    public Collection<Node> getRestored() {
        return this.restored;
    }

    public Collection<NodeReferenceChanged> getReferenceChanges() {
        return this.refchanges;
    }

    public void mergeWith(OperationReport other) {
        this.removed.addAll(other.getRemoved());
        this.renamed.addAll(other.getRenamed());
        this.moved.addAll(other.getMoved());
        this.refchanges.addAll(other.getReferenceChanges());
    }

    public void addRemoved(Node removednode) {
        this.removed.add(removednode);
    }

    public void addRemoved(String nodetype, Long nodeId) {
        this.addRemoved(new Node(nodeId, nodetype));
    }

    public void addRemoved(Collection<Node> toRemove) {
        this.removed.addAll(toRemove);
    }

    public void addRemoved(Collection<Long> ids, String nodeType) {
        for (Long id : ids) {
            this.addRemoved(new Node(id, nodeType));
        }
    }

    public void addRenamed(NodeRenaming renaming) {
        this.renamed.add(renaming);
    }

    public void addRenamed(String nodetype, Long nodeid, String newName) {
        this.addRenamed(new NodeRenaming(new Node(nodeid, nodetype), newName));
    }

    public void addRenamed(Collection<NodeRenaming> renamings) {
        this.renamed.addAll(renamings);
    }

    public void addMoved(NodeMovement movement) {
        this.moved.add(movement);
    }

    public void addMoved(Collection<NodeMovement> movements) {
        this.moved.addAll(movements);
    }

    public void addReferenceChanges(NodeReferenceChanged rerefs) {
        this.refchanges.add(rerefs);
    }

    public void addReferenceChanges(Collection<NodeReferenceChanged> rerefs) {
        this.refchanges.addAll(rerefs);
    }

    public void addRestored(Collection<Long> ids, String nodeType) {
        for (Long id : ids) {
            this.addRestored(new Node(id, nodeType));
        }
    }

    private void addRestored(Node node) {
        this.restored.add(node);
    }
}

