/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.repository.hibernate;

import jakarta.persistence.EntityManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.springframework.stereotype.Repository;
import org.squashtest.tm.domain.testcase.Parameter;
import org.squashtest.tm.service.internal.repository.CustomParameterDao;
import org.squashtest.tm.service.internal.repository.JooqCallTestCaseDao;

@Repository
public class ParameterDaoImpl
implements CustomParameterDao {
    private final EntityManager em;
    private final JooqCallTestCaseDao jooqCallTestCaseDao;

    public ParameterDaoImpl(EntityManager em, JooqCallTestCaseDao jooqCallTestCaseDao) {
        this.em = em;
        this.jooqCallTestCaseDao = jooqCallTestCaseDao;
    }

    @Override
    public List<Parameter> findAllParametersByTestCase(Long testcaseId) {
        return this.findAllParametersByTestCaseIds(List.of(testcaseId)).getOrDefault(testcaseId, Collections.emptyList());
    }

    @Override
    public Map<Long, List<Parameter>> findOwnParametersByTestCaseIds(Collection<Long> testCaseIds) {
        return this.em.createQuery("select testCase.id, parameter, parameter.name\nfrom Parameter parameter\njoin parameter.testCase testCase\nwhere testCase.id in :ids\norder by parameter.name", Object[].class).setParameter("ids", testCaseIds).getResultStream().collect(Collectors.groupingBy(result -> (Long)result[0], Collectors.mapping(result -> (Parameter)result[1], Collectors.toList())));
    }

    @Override
    public Map<Long, List<Parameter>> findAllParametersByTestCaseIds(Collection<Long> sourceTestCaseIds) {
        Map<Long, List<Long>> calledTestCaseIdsByCaller = this.jooqCallTestCaseDao.findTestCasesThatDelegatesParameters(sourceTestCaseIds);
        Set<Long> allTestCaseIds = Stream.concat(sourceTestCaseIds.stream(), calledTestCaseIdsByCaller.values().stream().flatMap(Collection::stream)).collect(Collectors.toSet());
        Map<Long, List<Parameter>> parametersByTestCaseId = this.findParametersByTestCaseIds(allTestCaseIds);
        return sourceTestCaseIds.stream().map(testCaseId -> {
            ArrayList parameters = new ArrayList(parametersByTestCaseId.getOrDefault(testCaseId, List.of()));
            calledTestCaseIdsByCaller.getOrDefault(testCaseId, Collections.emptyList()).stream().map(calledId -> parametersByTestCaseId.getOrDefault(calledId, List.of())).forEach(parameters::addAll);
            return parameters.isEmpty() ? null : Map.entry(testCaseId, parameters);
        }).filter(Objects::nonNull).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    @Override
    public Map<Long, List<Parameter>> findParametersByTestCaseIds(Collection<Long> testCaseIds) {
        return this.em.createQuery("select p\nfrom Parameter p\njoin fetch p.testCase tc\nwhere tc.id in :ids", Parameter.class).setParameter("ids", testCaseIds).getResultStream().collect(Collectors.groupingBy(parameter -> parameter.getTestCase().getId()));
    }
}

