/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.repository.display.impl.collectors;

import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.jooq.Condition;
import org.jooq.DSLContext;
import org.jooq.Field;
import org.jooq.GroupField;
import org.jooq.SelectField;
import org.jooq.TableLike;
import org.jooq.impl.DSL;
import org.springframework.stereotype.Component;
import org.squashtest.tm.domain.NodeReference;
import org.squashtest.tm.domain.NodeType;
import org.squashtest.tm.domain.requirement.RemoteRequirementPerimeterStatus;
import org.squashtest.tm.jooq.domain.Tables;
import org.squashtest.tm.service.internal.display.grid.DataRow;
import org.squashtest.tm.service.internal.repository.display.CustomFieldValueDisplayDao;
import org.squashtest.tm.service.internal.repository.display.MilestoneDisplayDao;
import org.squashtest.tm.service.internal.repository.display.TreeNodeCollector;
import org.squashtest.tm.service.internal.repository.display.impl.collectors.AbstractTreeNodeCollector;
import org.squashtest.tm.service.milestone.ActiveMilestoneHolder;

@Component
public class RequirementFolderCollector
extends AbstractTreeNodeCollector
implements TreeNodeCollector {
    private static final String HAS_OUT_OF_PERIMETER_OR_DELETED_REMOTE_REQ = "HAS_OUT_OF_PERIMETER_OR_DELETED_REMOTE_REQ";
    private static final String IS_SYNCHRONIZED = "IS_SYNCHRONIZED";

    public RequirementFolderCollector(DSLContext dsl, CustomFieldValueDisplayDao customFieldValueDisplayDao, MilestoneDisplayDao milestoneDisplayDao, ActiveMilestoneHolder activeMilestoneHolder) {
        super(dsl, customFieldValueDisplayDao, activeMilestoneHolder, milestoneDisplayDao);
    }

    @Override
    protected Map<Long, DataRow> doCollect(List<Long> ids) {
        Map<Long, DataRow> requirementFolders = this.collectRequirementFolderRows(ids);
        this.appendMilestonesByProject(requirementFolders);
        this.appendHasOutOfPerimeterOrDeletedRemoteReq(requirementFolders);
        return requirementFolders;
    }

    private Map<Long, DataRow> collectRequirementFolderRows(List<Long> ids) {
        return this.dsl.select((SelectField)Tables.REQUIREMENT_LIBRARY_NODE.RLN_ID, (SelectField)Tables.REQUIREMENT_LIBRARY_NODE.PROJECT_ID.as("projectId"), (SelectField)Tables.RESOURCE.NAME, (SelectField)DSL.count((Field)Tables.RLN_RELATIONSHIP.ANCESTOR_ID).as("CHILD_COUNT"), (SelectField)DSL.field((Condition)Tables.REQUIREMENT_FOLDER_SYNC_EXTENDER.RF_SYNC_EXTENDER_ID.isNotNull()).as(IS_SYNCHRONIZED), (SelectField)Tables.REMOTE_SYNCHRONISATION.LAST_SYNC_STATUS, (SelectField)Tables.REMOTE_SYNCHRONISATION.REMOTE_SYNCHRONISATION_NAME).from((TableLike)Tables.REQUIREMENT_LIBRARY_NODE).leftJoin((TableLike)Tables.RLN_RELATIONSHIP).on(Tables.REQUIREMENT_LIBRARY_NODE.RLN_ID.eq((Field)Tables.RLN_RELATIONSHIP.ANCESTOR_ID)).innerJoin((TableLike)Tables.REQUIREMENT_FOLDER).on(Tables.REQUIREMENT_LIBRARY_NODE.RLN_ID.eq((Field)Tables.REQUIREMENT_FOLDER.RLN_ID)).innerJoin((TableLike)Tables.RESOURCE).on(Tables.REQUIREMENT_FOLDER.RES_ID.eq((Field)Tables.RESOURCE.RES_ID)).leftJoin((TableLike)Tables.REQUIREMENT_FOLDER_SYNC_EXTENDER).on(Tables.REQUIREMENT_FOLDER_SYNC_EXTENDER.REQUIREMENT_FOLDER_ID.eq((Field)Tables.REQUIREMENT_FOLDER.RLN_ID)).leftJoin((TableLike)Tables.REMOTE_SYNCHRONISATION).on(Tables.REQUIREMENT_FOLDER_SYNC_EXTENDER.REMOTE_SYNCHRONISATION_ID.eq((Field)Tables.REMOTE_SYNCHRONISATION.REMOTE_SYNCHRONISATION_ID)).where(Tables.REQUIREMENT_LIBRARY_NODE.RLN_ID.in(ids)).groupBy(new GroupField[]{Tables.REQUIREMENT_LIBRARY_NODE.RLN_ID, Tables.RESOURCE.RES_ID, Tables.RLN_RELATIONSHIP.ANCESTOR_ID, Tables.REQUIREMENT_FOLDER_SYNC_EXTENDER.RF_SYNC_EXTENDER_ID, Tables.REMOTE_SYNCHRONISATION.REMOTE_SYNCHRONISATION_ID}).fetch().stream().collect(Collectors.toMap(tuple -> (Long)tuple.get((Field)Tables.REQUIREMENT_LIBRARY_NODE.RLN_ID), tuple -> {
            DataRow dataRow = new DataRow();
            dataRow.setId(new NodeReference(NodeType.REQUIREMENT_FOLDER, (Long)tuple.get((Field)Tables.REQUIREMENT_LIBRARY_NODE.RLN_ID)).toNodeId());
            dataRow.setProjectId((Long)tuple.get("projectId", Long.class));
            dataRow.setState((Integer)tuple.get("CHILD_COUNT", Integer.class) > 0 ? DataRow.State.closed : DataRow.State.leaf);
            dataRow.setData(tuple.intoMap());
            return dataRow;
        }));
    }

    private void appendHasOutOfPerimeterOrDeletedRemoteReq(Map<Long, DataRow> folders) {
        List<Long> synchronizedFolders = folders.entrySet().stream().filter(entry -> (Boolean)((DataRow)entry.getValue()).getData().get(IS_SYNCHRONIZED)).map(Map.Entry::getKey).toList();
        List<Long> folderIdsContainsOutOfPerimeterOrDeletedRemoteReq = this.checkIfFoldersHaveOutOfPerimeterOrDeletedRemoteReq(synchronizedFolders);
        folders.forEach((id, dataRow) -> {
            boolean isSynchronized = (Boolean)dataRow.getData().get(IS_SYNCHRONIZED);
            boolean hasOutOfPerimeterOrDeletedRemoteReq = isSynchronized && folderIdsContainsOutOfPerimeterOrDeletedRemoteReq.contains(id);
            dataRow.addData(HAS_OUT_OF_PERIMETER_OR_DELETED_REMOTE_REQ, hasOutOfPerimeterOrDeletedRemoteReq);
        });
    }

    private List<Long> checkIfFoldersHaveOutOfPerimeterOrDeletedRemoteReq(List<Long> folderIds) {
        return this.dsl.select((SelectField)Tables.RLN_RELATIONSHIP_CLOSURE.ANCESTOR_ID).from((TableLike)Tables.RLN_RELATIONSHIP_CLOSURE).innerJoin((TableLike)Tables.REQUIREMENT_SYNC_EXTENDER).on(Tables.RLN_RELATIONSHIP_CLOSURE.DESCENDANT_ID.eq((Field)Tables.REQUIREMENT_SYNC_EXTENDER.REQUIREMENT_ID)).where(Tables.RLN_RELATIONSHIP_CLOSURE.ANCESTOR_ID.in(folderIds).and(Tables.RLN_RELATIONSHIP_CLOSURE.DEPTH.notEqual((Object)0)).and(Tables.REQUIREMENT_SYNC_EXTENDER.REMOTE_REQ_PERIMETER_STATUS.in((Object[])new String[]{RemoteRequirementPerimeterStatus.OUT_OF_CURRENT_PERIMETER.name(), RemoteRequirementPerimeterStatus.NOT_FOUND.name()}))).groupBy(new GroupField[]{Tables.RLN_RELATIONSHIP_CLOSURE.ANCESTOR_ID}).having(DSL.count((Field)Tables.REQUIREMENT_SYNC_EXTENDER.REQUIREMENT_ID).greaterThan((Object)0)).fetch((Field)Tables.RLN_RELATIONSHIP_CLOSURE.ANCESTOR_ID);
    }

    @Override
    public NodeType getHandledEntityType() {
        return NodeType.REQUIREMENT_FOLDER;
    }
}

