/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.pivot.projectimporter.pivotimporter;

import jakarta.persistence.EntityManager;
import jakarta.persistence.PersistenceContext;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.zip.ZipFile;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.springframework.stereotype.Service;
import org.squashtest.tm.aspect.validation.CleanHtmlAspect;
import org.squashtest.tm.core.foundation.logger.Logger;
import org.squashtest.tm.core.foundation.logger.LoggerFactory;
import org.squashtest.tm.domain.customfield.BoundEntity;
import org.squashtest.tm.domain.customfield.RawValue;
import org.squashtest.tm.domain.library.NodeContainer;
import org.squashtest.tm.domain.library.TreeNode;
import org.squashtest.tm.domain.milestone.Milestone;
import org.squashtest.tm.domain.projectimporter.PivotFormatImport;
import org.squashtest.tm.domain.requirement.RequirementCriticality;
import org.squashtest.tm.domain.requirement.RequirementVersion;
import org.squashtest.tm.domain.resource.Resource;
import org.squashtest.tm.domain.testcase.ActionTestStep;
import org.squashtest.tm.domain.testcase.CallTestStep;
import org.squashtest.tm.domain.testcase.Dataset;
import org.squashtest.tm.domain.testcase.ExploratoryTestCase;
import org.squashtest.tm.domain.testcase.KeywordTestStep;
import org.squashtest.tm.domain.testcase.Parameter;
import org.squashtest.tm.domain.testcase.ParameterAssignationMode;
import org.squashtest.tm.domain.testcase.RequirementVersionCoverage;
import org.squashtest.tm.domain.testcase.TestCase;
import org.squashtest.tm.domain.testcase.TestCaseImportance;
import org.squashtest.tm.domain.testcase.TestCaseKind;
import org.squashtest.tm.domain.testcase.TestCaseLibrary;
import org.squashtest.tm.domain.testcase.TestStep;
import org.squashtest.tm.exception.DuplicateNameException;
import org.squashtest.tm.exception.requirement.RequirementAlreadyVerifiedException;
import org.squashtest.tm.service.annotation.Id;
import org.squashtest.tm.service.annotation.TransientlyRestore;
import org.squashtest.tm.service.internal.customfield.PrivateCustomFieldValueService;
import org.squashtest.tm.service.internal.dto.pivotdefinition.AbstractPivotObject;
import org.squashtest.tm.service.internal.dto.pivotdefinition.PivotBoundEntity;
import org.squashtest.tm.service.internal.dto.pivotdefinition.testcaseworkspace.TestCasePivot;
import org.squashtest.tm.service.internal.dto.pivotdefinition.testcaseworkspace.testcasepart.ActionStepPivot;
import org.squashtest.tm.service.internal.dto.pivotdefinition.testcaseworkspace.testcasepart.CalledTestCasesPivot;
import org.squashtest.tm.service.internal.dto.pivotdefinition.testcaseworkspace.testcasepart.DatasetParamPivot;
import org.squashtest.tm.service.internal.dto.pivotdefinition.testcaseworkspace.testcasepart.DatasetPivot;
import org.squashtest.tm.service.internal.dto.pivotdefinition.testcaseworkspace.testcasepart.KeywordPivot;
import org.squashtest.tm.service.internal.dto.projectimporter.AttachmentPivotHolder;
import org.squashtest.tm.service.internal.dto.projectimporter.ImportWarningEntry;
import org.squashtest.tm.service.internal.dto.projectimporter.JsonImportFile;
import org.squashtest.tm.service.internal.dto.projectimporter.PivotImportMetadata;
import org.squashtest.tm.service.internal.dto.projectimporter.ProjectIdsReferences;
import org.squashtest.tm.service.internal.pivot.projectimporter.pivotimporter.AbstractPivotImport;
import org.squashtest.tm.service.internal.pivot.projectimporter.pivotimporter.PivotFormatLoggerHelper;
import org.squashtest.tm.service.internal.pivot.projectimporter.pivotimporter.PivotImportStrategy;
import org.squashtest.tm.service.internal.pivot.projectimporter.pivotimporter.TestCasePivotImporterServiceImpl$AjcClosure1;
import org.squashtest.tm.service.internal.pivot.projectimporter.pivotimporter.containerloader.ContainerLoader;
import org.squashtest.tm.service.internal.pivot.projectimporter.pivotimporter.containerloader.ContainerLoaderFactory;
import org.squashtest.tm.service.internal.repository.MilestoneDao;
import org.squashtest.tm.service.internal.repository.RequirementVersionDao;
import org.squashtest.tm.service.internal.repository.TestCaseDao;
import org.squashtest.tm.service.internal.testcase.NatureTypeChainFixer;
import org.squashtest.tm.service.internal.testcase.ParameterNamesFinder;
import org.squashtest.tm.service.pivot.converters.AdminPivotConverterService;
import org.squashtest.tm.service.pivot.converters.TestCasePivotConverterService;
import org.squashtest.tm.service.pivot.projectimporter.pivotimporter.AttachmentPivotImportService;
import org.squashtest.tm.service.pivot.projectimporter.pivotimporter.TestCasePivotImporterService;
import org.squashtest.tm.service.testcase.CallStepManagerService;
import org.squashtest.tm.service.testcase.TestCaseModificationService;

@Service
public class TestCasePivotImporterServiceImpl
extends AbstractPivotImport
implements TestCasePivotImporterService {
    private static final Logger LOGGER;
    private final TestCasePivotConverterService testCasePivotConverterService;
    private final AdminPivotConverterService adminPivotConverterService;
    private final TestCaseDao testCaseDao;
    private final PrivateCustomFieldValueService customFieldValueService;
    private final TestCaseModificationService testCaseModificationService;
    private final CallStepManagerService callStepManager;
    private final MilestoneDao milestoneDao;
    private final ContainerLoaderFactory containerLoaderFactory;
    private final RequirementVersionDao requirementVersionDao;
    private final AttachmentPivotImportService attachmentPivotImportService;
    @PersistenceContext
    private EntityManager entityManager;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;

    static {
        TestCasePivotImporterServiceImpl.ajc$preClinit();
        LOGGER = LoggerFactory.getLogger(TestCasePivotImporterService.class);
    }

    public TestCasePivotImporterServiceImpl(TestCasePivotConverterService testCasePivotConverterService, AdminPivotConverterService adminPivotConverterService, TestCaseDao testCaseDao, PrivateCustomFieldValueService customFieldValueService, TestCaseModificationService testCaseModificationService, CallStepManagerService callStepManager, MilestoneDao milestoneDao, ContainerLoaderFactory containerLoaderFactory, RequirementVersionDao requirementVersionDao, AttachmentPivotImportService attachmentPivotImportService) {
        super(LOGGER);
        this.testCasePivotConverterService = testCasePivotConverterService;
        this.adminPivotConverterService = adminPivotConverterService;
        this.testCaseDao = testCaseDao;
        this.customFieldValueService = customFieldValueService;
        this.testCaseModificationService = testCaseModificationService;
        this.callStepManager = callStepManager;
        this.milestoneDao = milestoneDao;
        this.containerLoaderFactory = containerLoaderFactory;
        this.requirementVersionDao = requirementVersionDao;
        this.attachmentPivotImportService = attachmentPivotImportService;
    }

    @Override
    @TransientlyRestore(entityType=TestCaseLibrary.class)
    public void importTestCasesFromZipArchive(ZipFile zipFile, @Id ProjectIdsReferences projectIdsReferences, PivotImportMetadata pivotImportMetadata, PivotFormatImport pivotFormatImport) {
        this.importEntitiesFromZipArchive(zipFile, JsonImportFile.TEST_CASES, pivotFormatImport, pivotImportMetadata, "test cases", "test case", this.getTestCasePivotImporterStrategy(projectIdsReferences, pivotImportMetadata, pivotFormatImport));
    }

    private PivotImportStrategy<TestCasePivot> getTestCasePivotImporterStrategy(final ProjectIdsReferences projectIdsReferences, final PivotImportMetadata pivotImportMetadata, final PivotFormatImport pivotFormatImport) {
        return new PivotImportStrategy<TestCasePivot>(){

            @Override
            public Class<TestCasePivot> getPivotClazz() {
                return TestCasePivot.class;
            }

            @Override
            public void create(List<TestCasePivot> entities) {
                TestCasePivotImporterServiceImpl.this.createTestCases(entities, projectIdsReferences, pivotImportMetadata, pivotFormatImport);
            }
        };
    }

    private void createTestCases(List<TestCasePivot> testCasePivots, ProjectIdsReferences projectIdsReferences, PivotImportMetadata pivotImportMetadata, PivotFormatImport pivotFormatImport) {
        TestCaseBindingLoader testCaseBindingLoader = this.loadBindings(testCasePivots, pivotImportMetadata);
        this.createEntities(testCasePivots, projectIdsReferences, pivotImportMetadata, this.containerLoaderFactory, (testCasePivot, containerLoader) -> this.createTestCases((TestCasePivot)testCasePivot, (ContainerLoader)containerLoader, testCaseBindingLoader, pivotImportMetadata, pivotFormatImport));
        this.createAllCustomFields(this.customFieldValueService, pivotFormatImport, pivotImportMetadata);
        testCasePivots.clear();
        this.entityManager.flush();
        this.entityManager.clear();
    }

    private void createTestCases(TestCasePivot testCasePivot, ContainerLoader containerLoader, TestCaseBindingLoader testCaseBindingLoader, PivotImportMetadata pivotImportMetadata, PivotFormatImport pivotFormatImport) {
        NodeContainer container = containerLoader.getContainer(testCasePivot);
        this.fixConflictNames(container, testCasePivot.getName(), testCasePivot::setName);
        TestCase testCase = this.testCasePivotConverterService.pivotToTestCase(testCasePivot, pivotImportMetadata);
        container.addContent((TreeNode)testCase);
        NatureTypeChainFixer.fix(testCase);
        this.testCaseDao.safePersist(testCase);
        testCase.setReadOnlyModifyAudit(testCasePivot.getLastModifiedBy(), testCasePivot.getLastModifiedOn());
        Map<Long, Long> attachmentConversion = this.handleAttachment(testCase, testCasePivot, pivotImportMetadata, pivotFormatImport);
        this.handleCustomFields((BoundEntity)testCase, testCasePivot, attachmentConversion, pivotImportMetadata);
        Map<String, Parameter> parameterByPivotId = this.handleParameters(testCase, testCasePivot, attachmentConversion, pivotImportMetadata);
        HashMap<Long, List<ActionTestStep>> stepsCoverageByVersionId = new HashMap<Long, List<ActionTestStep>>();
        this.createTestStepsForTestCase(testCasePivot, testCase, parameterByPivotId, stepsCoverageByVersionId, pivotImportMetadata, pivotFormatImport);
        this.handleDataset(testCase, testCasePivot, parameterByPivotId, pivotImportMetadata);
        this.handleMilestone(testCase, testCasePivot, testCaseBindingLoader, pivotImportMetadata);
        this.handleCoverage(testCase, testCasePivot, stepsCoverageByVersionId, testCaseBindingLoader, pivotImportMetadata);
        pivotImportMetadata.getTestCaseIdByPivotId().put(testCasePivot.getPivotId(), testCase.getId());
    }

    private Map<String, Parameter> handleParameters(TestCase testCase, TestCasePivot testCasePivot, Map<Long, Long> attachmentsConversion, PivotImportMetadata pivotImportMetadata) {
        return testCasePivot.getDatasetParams().stream().collect(Collectors.toMap(AbstractPivotObject::getPivotId, datasetParamPivot -> this.createParameter(testCase, (DatasetParamPivot)datasetParamPivot, attachmentsConversion, pivotImportMetadata)));
    }

    private void handleDataset(TestCase testCase, TestCasePivot testCasePivot, Map<String, Parameter> parameterByPivotId, PivotImportMetadata pivotImportMetadata) {
        testCasePivot.getDatasets().stream().collect(Collectors.groupingBy(DatasetPivot::getName)).entrySet().stream().filter(e -> ((List)e.getValue()).size() > 1).findFirst().ifPresent(e -> {
            throw new DuplicateNameException((String)e.getKey(), (String)e.getKey());
        });
        testCasePivot.getDatasets().forEach(datasetPivot -> {
            Dataset dataset = this.testCasePivotConverterService.pivotToDataset((DatasetPivot)datasetPivot, parameterByPivotId);
            dataset.setTestCase(testCase);
            testCase.addDataset(dataset);
            this.entityManager.persist((Object)dataset);
            pivotImportMetadata.getDatasetIdByPivotId().put(datasetPivot.getPivotId(), dataset.getId());
        });
    }

    private Parameter createParameter(TestCase testCase, DatasetParamPivot datasetParamPivot, Map<Long, Long> attachmentsConversion, PivotImportMetadata pivotImportMetadata) {
        Parameter parameter = this.testCasePivotConverterService.pivotToDatasetParameter(datasetParamPivot);
        String description = parameter.getDescription();
        parameter.setDescription(this.attachmentPivotImportService.updateRichText(description, testCase.getAttachmentList(), attachmentsConversion, pivotImportMetadata));
        parameter.setTestCase(testCase);
        this.entityManager.persist((Object)parameter);
        return parameter;
    }

    private void handleCustomFields(BoundEntity boundEntity, PivotBoundEntity pivotBoundEntity, Map<Long, Long> attachmentsConversion, PivotImportMetadata pivotImportMetadata) {
        Map<Long, RawValue> customfields = this.adminPivotConverterService.pivotToCustomFieldValues(pivotBoundEntity, boundEntity, attachmentsConversion, pivotImportMetadata);
        pivotImportMetadata.getCufByEntity().put(boundEntity, customfields);
    }

    private Map<Long, Long> handleAttachment(TestCase testCase, TestCasePivot testCasePivot, PivotImportMetadata pivotImportMetadata, PivotFormatImport pivotFormatImport) {
        Map<Long, Long> attachmentsConversion = this.attachmentPivotImportService.addAttachmentsToEntity(new AttachmentPivotHolder<TestCase, TestCasePivot>(testCasePivot, testCase), pivotImportMetadata, pivotFormatImport);
        this.updateTestCaseRichText(testCase, attachmentsConversion, pivotImportMetadata);
        return attachmentsConversion;
    }

    private void updateTestCaseRichText(TestCase testCase, Map<Long, Long> attachmentsConversion, PivotImportMetadata pivotImportMetadata) {
        String description = testCase.getDescription();
        testCase.setDescription(this.attachmentPivotImportService.updateRichText(description, testCase.getAttachmentList(), attachmentsConversion, pivotImportMetadata));
        String prerequisite = testCase.getPrerequisite();
        testCase.setPrerequisite(this.attachmentPivotImportService.updateRichText(prerequisite, testCase.getAttachmentList(), attachmentsConversion, pivotImportMetadata));
        if (testCase instanceof ExploratoryTestCase) {
            ExploratoryTestCase exploratoryTestCase = (ExploratoryTestCase)testCase;
            String charter = exploratoryTestCase.getCharter();
            exploratoryTestCase.setCharter(this.attachmentPivotImportService.updateRichText(charter, testCase.getAttachmentList(), attachmentsConversion, pivotImportMetadata));
        }
    }

    private void handleMilestone(TestCase testCase, TestCasePivot testCasePivot, TestCaseBindingLoader testCaseBindingLoader, PivotImportMetadata pivotImportMetadata) {
        if (pivotImportMetadata.isMilestoneDisabled()) {
            return;
        }
        testCasePivot.getMilestones().forEach(pivotId -> {
            Long milestoneId = pivotImportMetadata.getMilestoneIdByPivotId().get(pivotId);
            Milestone milestone = testCaseBindingLoader.getMilestoneById(milestoneId);
            testCase.bindMilestone(milestone);
        });
    }

    private void handleCoverage(TestCase testCase, TestCasePivot testCasePivot, Map<Long, List<ActionTestStep>> stepsCoverageByVersionId, TestCaseBindingLoader testCaseBindingLoader, PivotImportMetadata pivotImportMetadata) {
        HashSet criticalities = new HashSet();
        testCasePivot.getVerifiedRequirementVersions().forEach(pivotId -> {
            Long versionId = pivotImportMetadata.getRequirementVersionIdByPivotId().get(pivotId);
            List stepCoverages = (List)stepsCoverageByVersionId.remove(versionId);
            RequirementVersion versionCovered = this.handleCoverage(testCase, versionId, stepCoverages, testCaseBindingLoader, pivotImportMetadata);
            criticalities.add(versionCovered.getCriticality());
        });
        stepsCoverageByVersionId.forEach((versionId, stepCoverages) -> {
            RequirementVersion versionCovered = this.handleCoverage(testCase, (Long)versionId, (List<ActionTestStep>)stepCoverages, testCaseBindingLoader, pivotImportMetadata);
            criticalities.add(versionCovered.getCriticality());
        });
        if (testCase.isImportanceAuto().booleanValue()) {
            Optional highestCriticalityOpt = RequirementCriticality.findStrongestCriticality(criticalities);
            if (highestCriticalityOpt.isEmpty()) {
                return;
            }
            TestCaseImportance importance = testCase.getImportance().deduceNewImporanceWhenAddCriticality((RequirementCriticality)highestCriticalityOpt.get());
            testCase.setImportance(importance);
        }
    }

    private RequirementVersion handleCoverage(TestCase testCase, Long versionId, List<ActionTestStep> stepCoverages, TestCaseBindingLoader testCaseBindingLoader, PivotImportMetadata pivotImportMetadata) {
        RequirementVersion version = testCaseBindingLoader.getVersionById(versionId);
        try {
            RequirementVersionCoverage coverage = new RequirementVersionCoverage(version, testCase, false);
            if (stepCoverages != null && !stepCoverages.isEmpty()) {
                coverage.addAllVerifyingSteps(stepCoverages);
            }
            this.entityManager.persist((Object)coverage);
        }
        catch (RequirementAlreadyVerifiedException ex) {
            LOGGER.warn(ex.getMessage(), (Throwable)ex);
            pivotImportMetadata.addImportWarningEntry(ImportWarningEntry.requirementAlreadyVerified(testCase.getName(), version.getName()));
        }
        return version;
    }

    private void createTestStepsForTestCase(TestCasePivot testCasePivot, TestCase testCase, Map<String, Parameter> parameterByPivotId, Map<Long, List<ActionTestStep>> stepsCoverageByVersionId, PivotImportMetadata pivotImportMetadata, PivotFormatImport pivotFormatImport) {
        Map parameterByName = parameterByPivotId.values().stream().collect(Collectors.toMap(Parameter::getName, Function.identity()));
        if (TestCaseKind.STANDARD.equals((Object)testCasePivot.getTestCaseKind())) {
            ParameterNamesFinder parameterNamesFinder = new ParameterNamesFinder();
            testCasePivot.getActionSteps().forEach(actionStepPivot -> {
                ActionTestStep step = this.createActionTestStep(testCase, (ActionStepPivot)actionStepPivot, pivotFormatImport, pivotImportMetadata);
                this.handleTestStepCoverage(step, (ActionStepPivot)actionStepPivot, stepsCoverageByVersionId, pivotImportMetadata);
                parameterNamesFinder.findParametersNamesInActionAndExpectedResult((TestStep)step).forEach(parameterName -> this.handleMissingParameters((String)parameterName, parameterByName, testCase, parameterByPivotId));
            });
        } else if (TestCaseKind.KEYWORD.equals((Object)testCasePivot.getTestCaseKind())) {
            this.createKeywordTestSteps(testCasePivot.getKeywordSteps(), testCase, pivotImportMetadata);
            testCase.getParameters().forEach(parameter -> this.handleMissingParameters(parameter.getName(), parameterByName, testCase, parameterByPivotId));
        }
    }

    private ActionTestStep createActionTestStep(TestCase testCase, ActionStepPivot actionStepPivot, PivotFormatImport pivotFormatImport, PivotImportMetadata pivotImportMetadata) {
        ActionTestStep step = this.testCasePivotConverterService.pivotToActionTestStep(actionStepPivot);
        testCase.addStep((TestStep)step);
        this.entityManager.persist((Object)step);
        Map<Long, Long> attachmentsConversion = this.handleAttachmentTestStep(actionStepPivot, step, pivotImportMetadata, pivotFormatImport);
        this.handleCustomFields((BoundEntity)step, actionStepPivot, attachmentsConversion, pivotImportMetadata);
        return step;
    }

    private void handleTestStepCoverage(ActionTestStep testStep, ActionStepPivot actionStepPivot, Map<Long, List<ActionTestStep>> stepsCoverageByVersionId, PivotImportMetadata pivotImportMetadata) {
        actionStepPivot.getVerifiedRequirementVersions().forEach(pivotId -> {
            Long versionId = pivotImportMetadata.getRequirementVersionIdByPivotId().get(pivotId);
            if (versionId == null) {
                return;
            }
            stepsCoverageByVersionId.computeIfAbsent(versionId, k -> new ArrayList()).add(testStep);
        });
    }

    private void handleMissingParameters(String missingParameterName, Map<String, Parameter> parameterByName, TestCase testCase, Map<String, Parameter> parameterByPivotId) {
        if (parameterByName.containsKey(missingParameterName)) {
            return;
        }
        Parameter parameter = new Parameter(missingParameterName);
        parameter.setTestCase(testCase);
        this.entityManager.persist((Object)parameter);
        String pivotIdMissingParameter = "%s_%s".formatted(testCase.getName(), parameter.getName());
        parameterByPivotId.put(pivotIdMissingParameter, parameter);
    }

    private Map<Long, Long> handleAttachmentTestStep(ActionStepPivot actionStepPivot, ActionTestStep testStep, PivotImportMetadata pivotImportMetadata, PivotFormatImport pivotFormatImport) {
        Map<Long, Long> attachmentsConversion = this.attachmentPivotImportService.addAttachmentsToEntity(new AttachmentPivotHolder<ActionTestStep, ActionStepPivot>(actionStepPivot, testStep), pivotImportMetadata, pivotFormatImport);
        String action = testStep.getAction();
        testStep.setAction(this.attachmentPivotImportService.updateRichText(action, testStep.getAttachmentList(), attachmentsConversion, pivotImportMetadata));
        String expectedResult = testStep.getExpectedResult();
        testStep.setExpectedResult(this.attachmentPivotImportService.updateRichText(expectedResult, testStep.getAttachmentList(), attachmentsConversion, pivotImportMetadata));
        return attachmentsConversion;
    }

    private void createKeywordTestSteps(List<KeywordPivot> keywordPivots, TestCase testCase, PivotImportMetadata pivotImportMetadata) {
        keywordPivots.forEach(keywordStep -> {
            KeywordTestStep testStep = this.testCaseModificationService.addKeywordTestStep((long)testCase.getId(), keywordStep.getKeyword().name(), keywordStep.getActionWord());
            testStep.setDocstring(keywordStep.getDocString());
            KeywordPivot keywordPivot = keywordStep;
            JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)keywordPivot);
            Object[] objectArray = new Object[]{this, keywordPivot, joinPoint};
            TestCasePivotImporterServiceImpl$AjcClosure1 testCasePivotImporterServiceImpl$AjcClosure1 = new TestCasePivotImporterServiceImpl$AjcClosure1(objectArray);
            testStep.setComment((String)CleanHtmlAspect.aspectOf().aroundCleanHtmlMethodExecution(testCasePivotImporterServiceImpl$AjcClosure1.linkClosureAndJoinPoint(4112)));
            testStep.setDatatable(keywordStep.getDataTable());
            pivotImportMetadata.getTestStepsIdByPivotId().put(keywordStep.getPivotId(), testStep.getId());
        });
    }

    private TestCaseBindingLoader loadBindings(List<TestCasePivot> testCasePivots, PivotImportMetadata pivotImportMetadata) {
        HashSet<Long> milestoneIds = new HashSet<Long>();
        HashSet<Long> requirementVersionIds = new HashSet<Long>();
        for (TestCasePivot testCasePivot : testCasePivots) {
            milestoneIds.addAll(testCasePivot.getMilestones().stream().map(pivotId -> pivotImportMetadata.getMilestoneIdByPivotId().get(pivotId)).filter(Objects::nonNull).toList());
            requirementVersionIds.addAll(testCasePivot.getVerifiedRequirementVersions().stream().map(pivotId -> pivotImportMetadata.getRequirementVersionIdByPivotId().get(pivotId)).filter(Objects::nonNull).toList());
            testCasePivot.getActionSteps().stream().flatMap(actionStepPivot -> actionStepPivot.getVerifiedRequirementVersions().stream()).map(pivotId -> pivotImportMetadata.getRequirementVersionIdByPivotId().get(pivotId)).filter(Objects::nonNull).forEach(requirementVersionIds::add);
        }
        Map<Object, Object> milestonesById = pivotImportMetadata.isMilestoneDisabled() ? Map.of() : this.milestoneDao.findAllById(milestoneIds).stream().collect(Collectors.toMap(Milestone::getId, Function.identity()));
        Map<Long, RequirementVersion> versionsById = this.requirementVersionDao.loadForCoverageAddition(requirementVersionIds).stream().collect(Collectors.toMap(Resource::getId, Function.identity()));
        return new TestCaseBindingLoader(milestonesById, versionsById);
    }

    @Override
    public void importCalledTestCasesFromZipArchive(ZipFile zipFile, PivotImportMetadata pivotImportMetadata, PivotFormatImport pivotFormatImport) {
        this.importEntitiesFromZipArchive(zipFile, JsonImportFile.CALLED_TEST_CASES, pivotFormatImport, pivotImportMetadata, "called test cases", "called test case", this.getCalledTestCasePivotImporterStrategy(pivotImportMetadata, pivotFormatImport));
    }

    private PivotImportStrategy<CalledTestCasesPivot> getCalledTestCasePivotImporterStrategy(final PivotImportMetadata pivotImportMetadata, final PivotFormatImport pivotFormatImport) {
        return new PivotImportStrategy<CalledTestCasesPivot>(){

            @Override
            public Class<CalledTestCasesPivot> getPivotClazz() {
                return CalledTestCasesPivot.class;
            }

            @Override
            public void create(List<CalledTestCasesPivot> entities) {
                TestCasePivotImporterServiceImpl.this.createCalledTestCases(entities, pivotImportMetadata, pivotFormatImport);
            }
        };
    }

    private void createCalledTestCases(List<CalledTestCasesPivot> calledTestCasesPivotList, PivotImportMetadata pivotImportMetadata, PivotFormatImport pivotFormatImport) {
        for (CalledTestCasesPivot calledTestCasesPivot : calledTestCasesPivotList) {
            PivotFormatLoggerHelper.logEntityCreationStarted(LOGGER, "called test case", calledTestCasesPivot.getPivotId(), pivotFormatImport);
            try {
                this.createCalledTestCase(calledTestCasesPivot, pivotImportMetadata);
                PivotFormatLoggerHelper.logEntityCreatedSuccessfully(LOGGER, "called test case", calledTestCasesPivot.getPivotId(), pivotFormatImport);
            }
            catch (Exception e) {
                PivotFormatLoggerHelper.handleEntityCreationFailed(LOGGER, "called test case", calledTestCasesPivot.getPivotId(), pivotFormatImport, e);
            }
        }
        calledTestCasesPivotList.clear();
        this.entityManager.flush();
        this.entityManager.clear();
    }

    private void createCalledTestCase(CalledTestCasesPivot calledTestCasesPivot, PivotImportMetadata pivotImportMetadata) {
        Long squashCallerTestCaseId = pivotImportMetadata.getTestCaseIdByPivotId().get(calledTestCasesPivot.getCallerId());
        Long squashCalledTestCaseId = pivotImportMetadata.getTestCaseIdByPivotId().get(calledTestCasesPivot.getCalledId());
        CallTestStep callTestStep = Objects.nonNull(calledTestCasesPivot.getIndex()) ? this.callStepManager.addCallTestStepUnsecured(squashCallerTestCaseId, squashCalledTestCaseId, calledTestCasesPivot.getIndex()) : this.callStepManager.addCallTestStepUnsecured(squashCallerTestCaseId, squashCalledTestCaseId);
        this.handleCalledTestCaseDataset(callTestStep, squashCallerTestCaseId, calledTestCasesPivot, pivotImportMetadata.getDatasetIdByPivotId());
        pivotImportMetadata.getTestStepsIdByPivotId().put(calledTestCasesPivot.getPivotId(), callTestStep.getId());
    }

    private void handleCalledTestCaseDataset(CallTestStep callTestStep, Long squashCallerTestCaseId, CalledTestCasesPivot calledTestCaseStepToImport, Map<String, Long> datasetIdsMap) {
        if (ParameterAssignationMode.CALLED_DATASET.equals((Object)calledTestCaseStepToImport.getParameterAssignationMode()) && Objects.nonNull(calledTestCaseStepToImport.getDatasetId())) {
            Long squashDatasetId = datasetIdsMap.get(calledTestCaseStepToImport.getDatasetId());
            this.callStepManager.setParameterAssignationModeUnsecured(callTestStep, squashCallerTestCaseId, calledTestCaseStepToImport.getParameterAssignationMode(), squashDatasetId);
        } else {
            this.callStepManager.setParameterAssignationModeUnsecured(callTestStep, squashCallerTestCaseId, calledTestCaseStepToImport.getParameterAssignationMode(), null);
        }
    }

    static final /* synthetic */ String getComment_aroundBody0(TestCasePivotImporterServiceImpl testCasePivotImporterServiceImpl, KeywordPivot keywordPivot, JoinPoint joinPoint) {
        return keywordPivot.getComment();
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("TestCasePivotImporterServiceImpl.java", TestCasePivotImporterServiceImpl.class);
        ajc$tjp_0 = factory.makeSJP("method-call", (Signature)factory.makeMethodSig("1", "getComment", "org.squashtest.tm.service.internal.dto.pivotdefinition.testcaseworkspace.testcasepart.KeywordPivot", "", "", "", "java.lang.String"), 552);
    }

    public record TestCaseBindingLoader(Map<Long, Milestone> milestonesById, Map<Long, RequirementVersion> versionsById) {
        public Milestone getMilestoneById(Long id) {
            return this.milestonesById.get(id);
        }

        public RequirementVersion getVersionById(Long id) {
            return this.versionsById.get(id);
        }
    }
}

