/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.deletion;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.springframework.context.MessageSource;
import org.squashtest.tm.domain.attachment.AttachmentHolder;
import org.squashtest.tm.domain.attachment.AttachmentList;
import org.squashtest.tm.domain.attachment.ExternalContentCoordinates;
import org.squashtest.tm.service.attachment.AttachmentManagerService;
import org.squashtest.tm.service.configuration.ConfigurationService;
import org.squashtest.tm.service.deletion.OperationReport;
import org.squashtest.tm.service.deletion.SuppressionPreviewReport;
import org.squashtest.tm.service.internal.deletion.DeletionPreview;
import org.squashtest.tm.service.internal.deletion.LockedFolderInferenceTree;
import org.squashtest.tm.service.internal.library.NodeDeletionHandler;
import org.squashtest.tm.service.internal.repository.NodeDeletionDao;

public abstract class AbstractNodeDeletionHandler
implements NodeDeletionHandler {
    protected final ConfigurationService configurationService;
    protected final AttachmentManagerService attachmentManager;
    protected final MessageSource messageSource;
    private final NodeDeletionDao deletionDao;

    protected AbstractNodeDeletionHandler(ConfigurationService configurationService, AttachmentManagerService attachmentManager, MessageSource messageSource, NodeDeletionDao deletionDao) {
        this.configurationService = configurationService;
        this.attachmentManager = attachmentManager;
        this.messageSource = messageSource;
        this.deletionDao = deletionDao;
    }

    @Override
    public DeletionPreview simulateDeletion(List<Long> targetIds) {
        if (targetIds.isEmpty()) {
            return new DeletionPreview();
        }
        List<Long> nodeIds = this.findNodeHierarchy(targetIds);
        List<SuppressionPreviewReport> reports = this.diagnoseSuppression(nodeIds);
        Long deletableCount = this.countDeletableTreeNodes(nodeIds, reports);
        DeletionPreview preview = new DeletionPreview(deletableCount, this.getDeletionThreshold());
        preview.addMessages(reports, this.messageSource);
        return preview;
    }

    protected long countDeletableTreeNodes(List<Long> nodeIds, List<SuppressionPreviewReport> reports) {
        List lockedNodeIds = reports.stream().filter(report -> !report.modifiesLockedNodes()).flatMap(report -> report.getLockedNodes().stream()).distinct().toList();
        return nodeIds.stream().filter(id -> !lockedNodeIds.contains(id)).count();
    }

    @Override
    public OperationReport deleteNodes(List<Long> targetIds) {
        if (!targetIds.isEmpty()) {
            LockedFolderInferenceTree tree = this.createLockedFileInferenceTree(targetIds);
            List<Long> deletableNodeIds = tree.collectDeletableIds();
            OperationReport deleteReport = !deletableNodeIds.isEmpty() ? this.batchDeleteNodes(deletableNodeIds) : new OperationReport();
            if (this.isMilestoneMode()) {
                List candidateNodeIds = tree.collectKeys();
                OperationReport unbindReport = this.batchUnbindFromMilestone(candidateNodeIds);
                deleteReport.mergeWith(unbindReport);
            }
            return deleteReport;
        }
        return new OperationReport();
    }

    protected abstract boolean isMilestoneMode();

    protected LockedFolderInferenceTree createLockedFileInferenceTree(List<Long> targetIds) {
        List<Long[]> hierarchy = this.findPairedNodeHierarchy(targetIds);
        LockedFolderInferenceTree tree = new LockedFolderInferenceTree();
        tree.build(hierarchy);
        List<Long> lockedNodeIds = this.detectLockedNodes(tree.collectKeys());
        tree.markLockedNodes(lockedNodeIds);
        tree.resolveLockedFolders();
        return tree;
    }

    protected List<Long[]> findPairedNodeHierarchy(List<Long> rootNodeIds) {
        if (rootNodeIds.isEmpty()) {
            return new ArrayList<Long[]>();
        }
        ArrayList<Long[]> nodeHierarchy = new ArrayList<Long[]>();
        for (Long id : rootNodeIds) {
            Long[] longArray = new Long[2];
            longArray[1] = id;
            nodeHierarchy.add(longArray);
        }
        List<Long[]> childrenNodes = this.deletionDao.findPairedNodeHierarchy(rootNodeIds);
        nodeHierarchy.addAll(childrenNodes);
        return nodeHierarchy;
    }

    protected List<Long> findNodeHierarchy(List<Long> rootNodeIds) {
        if (rootNodeIds.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<Long> nodeHierarchy = new ArrayList<Long>(rootNodeIds);
        List<Long> childrenNodes = this.deletionDao.findNodeHierarchy(rootNodeIds);
        nodeHierarchy.addAll(childrenNodes);
        return nodeHierarchy;
    }

    protected List<Long> detectLockedNodes(List<Long> nodeIds) {
        return this.diagnoseSuppression(nodeIds).stream().flatMap(report -> report.getLockedNodes().stream()).distinct().toList();
    }

    protected abstract List<SuppressionPreviewReport> diagnoseSuppression(List<Long> var1);

    protected abstract OperationReport batchDeleteNodes(List<Long> var1);

    protected abstract OperationReport batchUnbindFromMilestone(List<Long> var1);

    protected List<ExternalContentCoordinates> getExternalAttachmentContentCoordinatesOfObject(AttachmentHolder attachmentHolder) {
        AttachmentList attachmentList = attachmentHolder.getAttachmentList();
        List<Long> listOfAttachmentListId = this.makeListAttachmentListIdFordAttachmentList(attachmentList);
        return this.attachmentManager.getListIDbyContentIdForAttachmentLists(listOfAttachmentListId);
    }

    protected List<Long> makeListAttachmentListIdFordAttachmentList(AttachmentList attachmentList) {
        Long attachmentListId = attachmentList.getId();
        return Collections.singletonList(attachmentListId);
    }

    protected long getDeletionThreshold() {
        String strThreshold = this.configurationService.findConfiguration("squash.control.deletion.threshold");
        return Long.parseLong(strThreshold);
    }
}

