/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.customreport;

import jakarta.inject.Inject;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.collections.Closure;
import org.springframework.stereotype.Component;
import org.squashtest.tm.api.plugin.PluginName;
import org.squashtest.tm.api.plugin.UsedInPlugin;
import org.squashtest.tm.domain.customreport.CustomReportLibraryNode;
import org.squashtest.tm.domain.customreport.CustomReportTreeEntityVisitor;
import org.squashtest.tm.domain.customreport.CustomReportTreeLibraryNode;
import org.squashtest.tm.service.configuration.ConfigurationService;
import org.squashtest.tm.service.deletion.OperationReport;
import org.squashtest.tm.service.internal.customreport.CRLNDeletionVisitor;
import org.squashtest.tm.service.internal.customreport.TreeLibraryNodeDeletionHandler;
import org.squashtest.tm.service.internal.deletion.DeletionPreview;
import org.squashtest.tm.service.internal.deletion.LockedFolderInferenceTree;
import org.squashtest.tm.service.internal.repository.CustomReportLibraryNodeDao;

@Component
public class CRLNDeletionHandler
implements TreeLibraryNodeDeletionHandler<CustomReportLibraryNode> {
    @Inject
    private CustomReportLibraryNodeDao customReportLibraryNodeDao;
    @Inject
    private ConfigurationService configurationService;

    @Override
    public DeletionPreview simulateDeletion(List<Long> targetIds) {
        Long count = this.customReportLibraryNodeDao.countChildrenByIds(targetIds);
        return new DeletionPreview(count, this.getDeletionThreshold());
    }

    @Override
    @UsedInPlugin(names={PluginName.API_REST})
    public OperationReport deleteNodes(List<Long> targetIds) {
        final OperationReport operationReport = new OperationReport();
        LockedFolderInferenceTree tree = this.createTree(targetIds);
        Closure closure = new Closure(){

            public void execute(Object input) {
                LockedFolderInferenceTree.Node node = (LockedFolderInferenceTree.Node)((Object)input);
                CRLNDeletionHandler.this.doOneDelete((Long)node.getKey(), operationReport);
            }
        };
        tree.doBottomUp(closure);
        return operationReport;
    }

    private void doOneDelete(Long nodeId, OperationReport operationReport) {
        CustomReportLibraryNode targetNode = (CustomReportLibraryNode)this.customReportLibraryNodeDao.getReferenceById(nodeId);
        CustomReportTreeLibraryNode parentNode = targetNode.getParent();
        parentNode.removeChild((CustomReportTreeLibraryNode)targetNode);
        CRLNDeletionVisitor visitor = new CRLNDeletionVisitor(operationReport, targetNode);
        targetNode.getEntity().accept((CustomReportTreeEntityVisitor)visitor);
        this.customReportLibraryNodeDao.delete(targetNode);
    }

    private LockedFolderInferenceTree createTree(List<Long> targetIds) {
        int descendantNumber = targetIds.size();
        List currentLayerIds = targetIds;
        LockedFolderInferenceTree tree = new LockedFolderInferenceTree();
        ArrayList<Long[]> pairedIds = new ArrayList<Long[]>();
        this.addMultipleChildToParent(null, targetIds, pairedIds);
        while (descendantNumber > 0) {
            for (Long id : currentLayerIds) {
                List descendantIds = this.customReportLibraryNodeDao.findAllFirstLevelDescendantIds(id);
                this.addMultipleChildToParent(id, descendantIds, pairedIds);
                currentLayerIds = descendantIds;
                descendantNumber = descendantIds.size();
            }
        }
        tree.build(pairedIds);
        return tree;
    }

    private void addMultipleChildToParent(Long parentId, List<Long> childIds, List<Long[]> pairs) {
        for (Long id : childIds) {
            this.addPairToList(parentId, id, pairs);
        }
    }

    private void addPairToList(Long parentId, Long childId, List<Long[]> pairs) {
        Long[] pair = new Long[]{parentId, childId};
        pairs.add(pair);
    }

    private long getDeletionThreshold() {
        String strThreshold = this.configurationService.findConfiguration("squash.control.deletion.threshold");
        return Long.parseLong(strThreshold);
    }
}

