/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.batchimport.excel;

import java.util.HashMap;
import java.util.Map;
import org.apache.poi.ss.usermodel.Cell;
import org.squashtest.tm.service.importer.ImportMode;
import org.squashtest.tm.service.internal.batchimport.excel.AbstractTypeBasedCellValueCoercer;
import org.squashtest.tm.service.internal.batchimport.excel.CannotCoerceException;

public final class ImportModeCellCoercer
extends AbstractTypeBasedCellValueCoercer<ImportMode> {
    public static final ImportModeCellCoercer INSTANCE = new ImportModeCellCoercer();
    private final Map<String, ImportMode> modeByShortName = new HashMap<String, ImportMode>(ImportMode.values().length);

    private ImportModeCellCoercer() {
        this.modeByShortName.put("C", ImportMode.CREATE);
        this.modeByShortName.put("U", ImportMode.UPDATE);
        this.modeByShortName.put("D", ImportMode.DELETE);
    }

    @Override
    protected ImportMode coerceBlankCell(Cell cell) {
        return ImportMode.getDefault();
    }

    @Override
    protected ImportMode coerceStringCell(Cell cell) {
        String val = cell.getStringCellValue();
        ImportMode res = this.modeByShortName.get(val);
        if (res == null) {
            try {
                res = Enum.valueOf(ImportMode.class, val);
            }
            catch (IllegalArgumentException e) {
                throw new CannotCoerceException(e, "message.import.log.error.listField.wrongValueForListField", "message.import.log.impact.defaultAction");
            }
        }
        return res;
    }
}

