/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.artificialintelligence;

import java.net.URI;
import java.util.Map;
import java.util.regex.Pattern;
import javax.annotation.PostConstruct;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.squashtest.tm.core.foundation.exception.ActionException;
import org.squashtest.tm.core.foundation.logger.Logger;
import org.squashtest.tm.core.foundation.logger.LoggerFactory;
import org.squashtest.tm.domain.aiserver.AiProvider;
import org.squashtest.tm.exception.artificialintelligence.server.AiServerCouldNotExecuteRequestException;
import org.squashtest.tm.exception.artificialintelligence.server.TestConfigurationGenericException;
import org.squashtest.tm.service.internal.display.dto.aiserver.AiServerDto;

@Service
public class AiServerSecurityService {
    private static final Logger LOGGER = LoggerFactory.getLogger(AiServerSecurityService.class);
    private static final String GENERIC_ERROR_MESSAGE = "Test failed. Please double check the configuration of the AI server.";
    @Value(value="${squash.cloud-mode-enabled:false}")
    private boolean cloudModeEnabled;
    @Value(value="${squash.security.ai-server-whitelist.azure-openai:[-a-zA-Z0-9]+\\.openai\\.azure\\.com}")
    private String azurePattern;
    @Value(value="${squash.security.ai-server-whitelist.anthropic:api\\.anthropic\\.com}")
    private String anthropicPattern;
    @Value(value="${squash.security.ai-server-whitelist.custom:(?!)}")
    private String customPattern;
    @Value(value="${squash.security.ai-server-whitelist.google-vertex-ai:.*}")
    private String googleVertexPattern;
    @Value(value="${squash.security.ai-server-whitelist.mistral-ai:api\\.mistral\\.ai}")
    private String mistralPattern;
    @Value(value="${squash.security.ai-server-whitelist.openai:api\\.openai\\.com}")
    private String openaiPattern;
    private Map<AiProvider, Pattern> whitelistPatterns;

    @PostConstruct
    public void init() {
        this.whitelistPatterns = Map.of(AiProvider.AZURE_OPEN_AI, Pattern.compile(this.azurePattern), AiProvider.ANTHROPIC, Pattern.compile(this.anthropicPattern), AiProvider.CUSTOM, Pattern.compile(this.customPattern), AiProvider.GOOGLE_VERTEX_AI, Pattern.compile(this.googleVertexPattern), AiProvider.MISTRAL_AI, Pattern.compile(this.mistralPattern), AiProvider.OPEN_AI, Pattern.compile(this.openaiPattern));
    }

    public ActionException sanitizeException(String originalExceptionMessage, AiServerDto aiServerDto) {
        if (!this.cloudModeEnabled) {
            return new AiServerCouldNotExecuteRequestException(originalExceptionMessage);
        }
        if (this.isServerWhitelisted(aiServerDto)) {
            return new AiServerCouldNotExecuteRequestException(originalExceptionMessage);
        }
        LOGGER.warn("AI server not whitelisted in cloud mode. Original error: {}", new Object[]{originalExceptionMessage});
        return new TestConfigurationGenericException(GENERIC_ERROR_MESSAGE);
    }

    private boolean isServerWhitelisted(AiServerDto aiServerDto) {
        Pattern pattern;
        String host;
        AiProvider provider;
        block7: {
            block6: {
                String aiServerUrl = aiServerDto.getUrl();
                provider = aiServerDto.getProvider();
                try {
                    URI uri = new URI(aiServerUrl);
                    host = uri.getHost();
                    if (host != null) break block6;
                    LOGGER.warn("Could not extract host from AI server URL: {}", new Object[]{aiServerUrl});
                    return false;
                }
                catch (Exception e) {
                    LOGGER.error("Error parsing AI server URL: {}", new Object[]{aiServerUrl, e});
                    return false;
                }
            }
            pattern = this.whitelistPatterns.get(provider);
            if (pattern != null) break block7;
            LOGGER.warn("No whitelist pattern found for provider: {}", new Object[]{provider});
            return false;
        }
        boolean matches = pattern.matcher(host).matches();
        if (matches) {
            LOGGER.debug("AI server {} matched whitelist pattern for provider: {}", new Object[]{host, provider});
        } else {
            LOGGER.debug("AI server {} did not match whitelist pattern for provider: {}", new Object[]{host, provider});
        }
        return matches;
    }
}

