/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.repository.hibernate;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.jooq.DSLContext;
import org.jooq.Field;
import org.jooq.OrderField;
import org.jooq.Select;
import org.jooq.SelectField;
import org.jooq.Table;
import org.jooq.TableLike;
import org.jooq.impl.DSL;
import org.springframework.stereotype.Repository;
import org.squashtest.tm.domain.milestone.MilestoneStatus;
import org.squashtest.tm.jooq.domain.Tables;
import org.squashtest.tm.service.internal.repository.TestCaseDeletionDao;
import org.squashtest.tm.service.internal.repository.display.utils.ConditionsConstants;
import org.squashtest.tm.service.internal.repository.hibernate.AbstractHibernateDeletionDao;

@Repository
public class HibernateTestCaseDeletionDao
extends AbstractHibernateDeletionDao
implements TestCaseDeletionDao {
    private static final String FOLDER_IDS = "folderIds";
    private static final String NODE_IDS = "nodeIds";

    public HibernateTestCaseDeletionDao(DSLContext dsl) {
        super(dsl);
    }

    @Override
    public void removeEntities(List<Long> entityIds) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setExecStepInboundReferencesToNull(List<Long> testStepIds) {
        if (testStepIds.isEmpty()) {
            return;
        }
        this.dsl.update((Table)Tables.EXECUTION_STEP).setNull((Field)Tables.EXECUTION_STEP.TEST_STEP_ID).where(Tables.EXECUTION_STEP.TEST_STEP_ID.in(testStepIds)).execute();
    }

    @Override
    public Map<String, List<Long>> separateFolderFromTestCaseIds(List<Long> originalIds) {
        ArrayList<Long> folderIds = new ArrayList<Long>();
        ArrayList<Long> testcaseIds = new ArrayList<Long>();
        List filteredFolderIds = this.dsl.select((SelectField)Tables.TEST_CASE_FOLDER.TCLN_ID).from((TableLike)Tables.TEST_CASE_FOLDER).innerJoin((TableLike)Tables.TEST_CASE_LIBRARY_NODE).on(Tables.TEST_CASE_FOLDER.TCLN_ID.eq((Field)Tables.TEST_CASE_LIBRARY_NODE.TCLN_ID).and(ConditionsConstants.TCLN_NOT_IN_BIN)).where(Tables.TEST_CASE_FOLDER.TCLN_ID.in(originalIds)).fetch((Field)Tables.TEST_CASE_FOLDER.TCLN_ID);
        for (Long oId : originalIds) {
            if (filteredFolderIds.contains(oId)) {
                folderIds.add(oId);
                continue;
            }
            testcaseIds.add(oId);
        }
        HashMap<String, List<Long>> idsMap = new HashMap<String, List<Long>>();
        idsMap.put(NODE_IDS, testcaseIds);
        idsMap.put(FOLDER_IDS, folderIds);
        return idsMap;
    }

    @Override
    public List<Long> findRemainingTestCaseIds(List<Long> originalIds) {
        return this.dsl.select((SelectField)Tables.TEST_CASE.TCLN_ID).from((TableLike)Tables.TEST_CASE).innerJoin((TableLike)Tables.TEST_CASE_LIBRARY_NODE).on(Tables.TEST_CASE.TCLN_ID.eq((Field)Tables.TEST_CASE_LIBRARY_NODE.TCLN_ID)).where(Tables.TEST_CASE.TCLN_ID.in(originalIds).and(ConditionsConstants.TCLN_NOT_IN_BIN)).fetch((Field)Tables.TEST_CASE.TCLN_ID);
    }

    @Override
    public void unbindFromMilestone(List<Long> testCaseIds, Long milestoneId) {
        if (testCaseIds.isEmpty()) {
            return;
        }
        this.dsl.deleteFrom((Table)Tables.MILESTONE_TEST_CASE).where(Tables.MILESTONE_TEST_CASE.MILESTONE_ID.eq((Object)milestoneId).and(Tables.MILESTONE_TEST_CASE.TEST_CASE_ID.in(testCaseIds))).execute();
    }

    @Override
    public List<Long> findTestCasesWhichMilestonesForbidsDeletion(List<Long> ids) {
        if (ids.isEmpty()) {
            return new ArrayList<Long>();
        }
        List<String> blockingStatuses = MilestoneStatus.MILESTONE_BLOCKING_STATUSES.stream().map(Enum::name).toList();
        return this.dsl.select((SelectField)Tables.TEST_CASE.TCLN_ID).from((TableLike)Tables.TEST_CASE).innerJoin((TableLike)Tables.TEST_CASE_LIBRARY_NODE).on(Tables.TEST_CASE.TCLN_ID.eq((Field)Tables.TEST_CASE_LIBRARY_NODE.TCLN_ID).and(ConditionsConstants.TCLN_NOT_IN_BIN)).innerJoin((TableLike)Tables.MILESTONE_TEST_CASE).on(Tables.TEST_CASE.TCLN_ID.eq((Field)Tables.MILESTONE_TEST_CASE.TEST_CASE_ID)).innerJoin((TableLike)Tables.MILESTONE).on(Tables.MILESTONE_TEST_CASE.MILESTONE_ID.eq((Field)Tables.MILESTONE.MILESTONE_ID)).where(Tables.TEST_CASE.TCLN_ID.in(ids).and(Tables.MILESTONE.STATUS.in(blockingStatuses))).fetch((Field)Tables.TEST_CASE.TCLN_ID);
    }

    /*
     * Exception decompiling
     */
    @Override
    public List<Long[]> findPairedNodeHierarchy(List<Long> nodeIds) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.UnsupportedOperationException
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.NewAnonymousArray.getDimSize(NewAnonymousArray.java:142)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.isNewArrayLambda(LambdaRewriter.java:455)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:409)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:167)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:105)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriterToArgs(AbstractMemberFunctionInvokation.java:101)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:87)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredReturn.rewriteExpressions(StructuredReturn.java:99)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewrite(LambdaRewriter.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.rewriteLambdas(Op04StructuredStatement.java:1137)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:912)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public List<Long> findNodeHierarchy(List<Long> nodeIds) {
        return this.dsl.selectDistinct((SelectField)Tables.TCLN_RELATIONSHIP_CLOSURE.DESCENDANT_ID, (SelectField)Tables.TCLN_RELATIONSHIP_CLOSURE.DEPTH).from((TableLike)Tables.TCLN_RELATIONSHIP_CLOSURE).innerJoin((TableLike)Tables.TEST_CASE_LIBRARY_NODE).on(Tables.TCLN_RELATIONSHIP_CLOSURE.DESCENDANT_ID.eq((Field)Tables.TEST_CASE_LIBRARY_NODE.TCLN_ID).and(ConditionsConstants.TCLN_NOT_IN_BIN)).where(Tables.TCLN_RELATIONSHIP_CLOSURE.ANCESTOR_ID.in(nodeIds).and(Tables.TCLN_RELATIONSHIP_CLOSURE.DEPTH.notEqual((Object)0))).orderBy((OrderField)Tables.TCLN_RELATIONSHIP_CLOSURE.DEPTH).fetch((Field)Tables.TCLN_RELATIONSHIP_CLOSURE.DESCENDANT_ID);
    }

    @Override
    public Optional<Long> getLibraryIdForEmptyingWorkspace(Long projectId) {
        return this.dsl.select((SelectField)Tables.PROJECT.TCL_ID).from((TableLike)Tables.PROJECT).where(Tables.PROJECT.PROJECT_ID.eq((Object)projectId).and(DSL.exists((Select)DSL.selectOne().from((TableLike)Tables.TEST_CASE_LIBRARY_NODE).where(Tables.TEST_CASE_LIBRARY_NODE.PROJECT_ID.eq((Field)Tables.PROJECT.PROJECT_ID))))).fetchOptional((Field)Tables.PROJECT.TCL_ID);
    }
}

