/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.report;

import jakarta.inject.Inject;
import jakarta.persistence.EntityManager;
import jakarta.persistence.PersistenceContext;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.squashtest.tm.domain.customreport.CustomReportLibraryNode;
import org.squashtest.tm.domain.customreport.CustomReportTreeEntity;
import org.squashtest.tm.domain.report.ReportDefinition;
import org.squashtest.tm.service.annotation.Id;
import org.squashtest.tm.service.customreport.CustomReportLibraryNodeService;
import org.squashtest.tm.service.internal.repository.ReportDefinitionDao;
import org.squashtest.tm.service.report.ReportModificationService;

@Transactional
@Service(value="squashtest.tm.service.ReportModificationService")
public class ReportModificationServiceImpl
implements ReportModificationService {
    @PersistenceContext
    private EntityManager em;
    @Inject
    private CustomReportLibraryNodeService customReportLibraryNodeService;
    @Inject
    private ReportDefinitionDao reportDefinitionDao;

    @Override
    public ReportDefinition findById(@Id long id) {
        return (ReportDefinition)this.reportDefinitionDao.getReferenceById(id);
    }

    @Override
    @PreAuthorize(value="hasPermission(#definition.id, 'org.squashtest.tm.domain.report.ReportDefinition' ,'WRITE')  or hasRole('ROLE_ADMIN')")
    public void updateDefinition(ReportDefinition definition, ReportDefinition oldDef) {
        definition.setProject(oldDef.getProject());
        definition.setCreatedBy(oldDef.getCreatedBy());
        definition.setCreatedOn(oldDef.getCreatedOn());
        if (!definition.getName().equals(oldDef.getName())) {
            CustomReportLibraryNode node = this.customReportLibraryNodeService.findNodeFromEntity((CustomReportTreeEntity)oldDef);
            node.renameNode(definition.getName());
        }
        this.em.flush();
        this.em.clear();
        this.save(definition);
    }

    @Override
    public void save(ReportDefinition report) {
        this.em.merge((Object)report);
    }
}

