/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.filemanagement.writer;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.QuoteMode;
import org.springframework.stereotype.Component;
import org.squashtest.tm.service.internal.filemanagement.writer.CSVWriter;

@Component
public class WriterFactory {
    public CSVWriter createDefaultCSVWriter(Appendable appendable) {
        return new CSVWriter(appendable, this.getDefaultCSVFormat());
    }

    private CSVFormat getDefaultCSVFormat() {
        return CSVFormat.DEFAULT.builder().setDelimiter(";").setQuote('\"').setQuoteMode(QuoteMode.ALL).get();
    }

    public FileWriter createFileWriter(File file) throws IOException {
        return new FileWriter(file, StandardCharsets.UTF_8);
    }
}

