/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.security.acls.domain.objectidentity;

import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.springframework.security.acls.model.ObjectIdentity;
import org.springframework.stereotype.Component;
import org.squashtest.tm.service.security.acls.domain.objectidentity.OptimizedObjectIdentityRetrievalStrategy;
import org.squashtest.tm.service.security.acls.domain.objectidentity.retrievers.OptimizedObjectIdentityRetriever;

@Component
public class OptimizedObjectIdentityRetrievalStrategyImpl
implements OptimizedObjectIdentityRetrievalStrategy {
    private final Map<String, OptimizedObjectIdentityRetriever> retrieverByClassName;

    public OptimizedObjectIdentityRetrievalStrategyImpl(List<OptimizedObjectIdentityRetriever> retrievers) {
        this.retrieverByClassName = Collections.unmodifiableMap(retrievers.stream().collect(Collectors.toMap(OptimizedObjectIdentityRetriever::handledClass, Function.identity())));
    }

    @Override
    public boolean isHandled(String className) {
        Objects.requireNonNull(className);
        return this.retrieverByClassName.containsKey(className);
    }

    public ObjectIdentity createObjectIdentity(Serializable id, String type) {
        Objects.requireNonNull(id);
        Objects.requireNonNull(type);
        OptimizedObjectIdentityRetriever optimizedObjectIdentityRetriever = this.retrieverByClassName.get(type);
        return optimizedObjectIdentityRetriever.createObjectIdentity(id);
    }
}

