/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.testautomation.httpclient;

import java.io.IOException;
import java.io.Serializable;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.hc.client5.http.classic.methods.HttpDelete;
import org.apache.hc.client5.http.classic.methods.HttpGet;
import org.apache.hc.client5.http.classic.methods.HttpPost;
import org.apache.hc.client5.http.classic.methods.HttpUriRequestBase;
import org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import org.apache.hc.client5.http.protocol.HttpClientContext;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.ClassicHttpResponse;
import org.apache.hc.core5.http.ContentType;
import org.apache.hc.core5.http.Header;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.HttpMessage;
import org.apache.hc.core5.http.ParseException;
import org.apache.hc.core5.http.io.entity.EntityUtils;
import org.apache.hc.core5.http.io.entity.StringEntity;
import org.apache.hc.core5.http.message.BasicHeader;
import org.apache.hc.core5.http.protocol.HttpContext;
import org.apache.hc.core5.net.URIBuilder;
import org.opentestfactory.messages.Status;
import org.squashtest.tm.core.foundation.lang.UrlUtils;
import org.squashtest.tm.core.foundation.logger.Logger;
import org.squashtest.tm.core.foundation.logger.LoggerFactory;
import org.squashtest.tm.domain.testautomation.TestAutomationServer;
import org.squashtest.tm.exception.testautomation.InaccessibleVersionException;
import org.squashtest.tm.service.internal.dto.WorkflowDto;
import org.squashtest.tm.service.internal.testautomation.codec.ObjectMapperFactory;
import org.squashtest.tm.service.internal.testautomation.httpclient.ClientRuntimeException;
import org.squashtest.tm.service.internal.testautomation.httpclient.HttpClientFactory;
import org.squashtest.tm.service.internal.testautomation.httpclient.MessageRefusedException;
import org.squashtest.tm.service.internal.testautomation.httpclient.RequestConfigurationFactory;
import org.squashtest.tm.service.internal.testautomation.httpclient.Response;
import org.squashtest.tm.service.internal.testautomation.httpclient.SquashAutomWorkflowClient;
import org.squashtest.tm.service.internal.testautomation.httpclient.UnexpectedServerResponseException;
import org.squashtest.tm.service.internal.testautomation.model.messages.ChannelStatus;
import org.squashtest.tm.service.internal.testautomation.model.messages.KillWorkflowStatus;
import org.squashtest.tm.service.internal.testautomation.model.messages.VersionStatus;
import org.squashtest.tm.service.internal.testautomation.model.messages.Workflow;
import org.squashtest.tm.service.internal.testautomation.model.messages.WorkflowData;
import org.squashtest.tm.service.internal.testautomation.model.messages.WorkflowHandle;
import org.squashtest.tm.service.internal.testautomation.model.messages.WorkflowsStatus;
import org.squashtest.tm.service.orchestrator.model.OrchestratorConfVersions;
import org.squashtest.tm.service.orchestrator.model.OrchestratorResponse;
import org.squashtest.tm.service.testautomation.model.AutomatedExecutionEnvironment;

public class SquashAutomWorkflowClientImpl
implements SquashAutomWorkflowClient,
Serializable {
    private static final long serialVersionUID = -3269346366501338867L;
    private static final Logger LOGGER = LoggerFactory.getLogger(SquashAutomWorkflowClientImpl.class);
    private static final int HTTP_ERROR_CODE = 400;
    private static final String PATH_TO_CHANNELS_ENDPOINT = "./channels";
    private static final String PATH_TO_WORKFLOWS_ENDPOINT = "./workflows";
    private static final String PATH_TO_VERSION_ENDPOINT = "./version";
    private static final String PATH_TO_LOGS_ENDPOINT = "/logs";
    private static final String GET_WORKFLOWS_PARAM = "?expand=manifest";
    private static final String NO_TOKEN_DEBUG_MESSAGE = "No authentication token, sending anonymously";
    private static final String GENERIC_REST_CALL_ERROR_MESSAGE = "Failed to manage REST call for technical reasons";
    private final String authToken;
    private final String receptionEndpoint;
    private final String observerEndpoint;
    private final String killSwitchEndpoint;
    private final int timeoutSeconds;

    public SquashAutomWorkflowClientImpl(String receptionEndpoint, String observerEndpoint, String killSwitchEndpoint, String authToken, int timeoutSeconds) {
        this.receptionEndpoint = receptionEndpoint;
        this.observerEndpoint = observerEndpoint;
        this.killSwitchEndpoint = killSwitchEndpoint;
        this.authToken = authToken;
        this.timeoutSeconds = timeoutSeconds;
    }

    @Override
    public List<AutomatedExecutionEnvironment> getAllAccessibleEnvironments(TestAutomationServer server) throws MessageRefusedException {
        ChannelStatus channelStatus = this.performJsonGetRestCall(this.buildChannelsUrl(), ChannelStatus.class);
        return channelStatus.getAutomatedExecutionEnvironments();
    }

    @Override
    public OrchestratorResponse<OrchestratorConfVersions> fetchOrchestratorConfVersions(TestAutomationServer server) throws UnexpectedServerResponseException {
        VersionStatus versionStatus = null;
        String endpoint = this.buildVersionUrl();
        try {
            versionStatus = this.performJsonGetRestCall(endpoint, VersionStatus.class);
        }
        catch (MessageRefusedException | UnexpectedServerResponseException e) {
            LOGGER.warn("Failed to fetch orchestrator version: {}", new Object[]{e.getMessage()});
            throw new InaccessibleVersionException(endpoint);
        }
        return new OrchestratorResponse<OrchestratorConfVersions>(versionStatus.getOrchestratorConfigurations(), true);
    }

    @Override
    public OrchestratorResponse<List<WorkflowDto>> fetchProjectWorkflows(TestAutomationServer server, Long projectId) throws MessageRefusedException {
        WorkflowsStatus workflowsStatus = this.performJsonGetRestCall(this.buildWorkflowsUrl(), WorkflowsStatus.class);
        List<WorkflowDto> workflows = workflowsStatus.getProjectWorkflows(projectId.toString()).stream().map(WorkflowData::toWorkflowDto).toList();
        return new OrchestratorResponse<List<WorkflowDto>>(workflows, true);
    }

    @Override
    public OrchestratorResponse<String> fetchWorkflowLogs(String workflowId) throws MessageRefusedException {
        String logs = this.performStringGetRestCall(this.buildWorkflowLogsUrl(workflowId));
        return new OrchestratorResponse<String>(logs, true);
    }

    @Override
    public OrchestratorResponse<Void> killWorkflow(TestAutomationServer server, Long projectId, String workflowId) throws MessageRefusedException {
        try {
            KillWorkflowStatus response = this.performJsonDeleteCall(this.buildKillWorkflowUrl(workflowId), KillWorkflowStatus.class);
            if (response.getCode() == 200) {
                return new OrchestratorResponse<Void>(true);
            }
            LOGGER.error("Failed to kill workflow {} on project {} : {}", new Object[]{workflowId, projectId, response.getMessage()});
            return new OrchestratorResponse<Void>(false);
        }
        catch (URISyntaxException | ClientRuntimeException ex) {
            LOGGER.error("Failed to kill workflow {} on project {} : {}, check URL validity", new Object[]{workflowId, projectId, ex.getMessage()});
            return new OrchestratorResponse<Void>(false);
        }
    }

    private String buildWorkflowsUrl() {
        String baseUrl = StringUtils.isBlank((CharSequence)this.observerEndpoint) ? this.receptionEndpoint : this.observerEndpoint;
        return UrlUtils.appendPath((String)baseUrl, (String)"./workflows?expand=manifest").toExternalForm();
    }

    private String buildWorkflowLogsUrl(String workflowId) {
        String baseUrl = StringUtils.isBlank((CharSequence)this.observerEndpoint) ? this.receptionEndpoint : this.observerEndpoint;
        return UrlUtils.appendPath((String)baseUrl, (String)("./workflows/" + workflowId + PATH_TO_LOGS_ENDPOINT)).toExternalForm();
    }

    private String buildKillWorkflowUrl(String workflowId) throws URISyntaxException {
        if (!StringUtils.isBlank((CharSequence)this.killSwitchEndpoint)) {
            return UrlUtils.appendPath((String)this.killSwitchEndpoint, (String)("./workflows/" + workflowId)).toExternalForm();
        }
        String baseUrl = StringUtils.isBlank((CharSequence)this.observerEndpoint) ? this.receptionEndpoint : this.observerEndpoint;
        URI originalUrl = new URI(baseUrl);
        URIBuilder uriBuilder = new URIBuilder().setScheme(originalUrl.getScheme()).setHost(originalUrl.getHost()).setPort(7776).setPath(originalUrl.getPath());
        URI killSwitchUri = uriBuilder.build();
        LOGGER.warn("No KillSwitchUrl, using constructed default (BaseUrl: " + String.valueOf(originalUrl) + ", Port: 7776 => " + String.valueOf(killSwitchUri) + ")", new Object[0]);
        return UrlUtils.appendPath((String)killSwitchUri.toString(), (String)("./workflows/" + workflowId)).toExternalForm();
    }

    public String buildChannelsUrl() {
        String baseUrl = StringUtils.isBlank((CharSequence)this.observerEndpoint) ? this.receptionEndpoint : this.observerEndpoint;
        return UrlUtils.appendPath((String)baseUrl, (String)PATH_TO_CHANNELS_ENDPOINT).toExternalForm();
    }

    public String buildVersionUrl() {
        String baseUrl = StringUtils.isBlank((CharSequence)this.observerEndpoint) ? this.receptionEndpoint : this.observerEndpoint;
        return UrlUtils.appendPath((String)baseUrl, (String)PATH_TO_VERSION_ENDPOINT).toExternalForm();
    }

    private <T extends Status<?>> T performJsonPostRestCall(Workflow workflow, String endpoint, Class<T> responseType) throws MessageRefusedException {
        try {
            String payload = ObjectMapperFactory.getJsonObjectMapper().writeValueAsString((Object)workflow);
            HttpPost request = new HttpPost(endpoint);
            request.setEntity((HttpEntity)new StringEntity(payload, ContentType.APPLICATION_JSON));
            return (T)((Status)this.performRequest((HttpUriRequestBase)request, endpoint, responseType));
        }
        catch (IOException ex) {
            throw new ClientRuntimeException(GENERIC_REST_CALL_ERROR_MESSAGE, ex, endpoint);
        }
    }

    private String performStringGetRestCall(String endpoint) throws MessageRefusedException, UnexpectedServerResponseException {
        HttpGet request = new HttpGet(endpoint);
        return this.performRequest((HttpUriRequestBase)request, endpoint, String.class);
    }

    private <T extends Status<?>> T performJsonGetRestCall(String endpoint, Class<T> responseType) throws MessageRefusedException, UnexpectedServerResponseException {
        HttpGet request = new HttpGet(endpoint);
        return (T)((Status)this.performRequest((HttpUriRequestBase)request, endpoint, responseType));
    }

    private <T extends Status<?>> T performJsonDeleteCall(String endpoint, Class<T> responseType) throws MessageRefusedException {
        HttpDelete request = new HttpDelete(endpoint);
        return (T)((Status)this.performRequest((HttpUriRequestBase)request, endpoint, responseType));
    }

    /*
     * Loose catch block
     */
    private <T> T performRequest(HttpUriRequestBase request, String endpoint, Class<T> responseType) throws MessageRefusedException {
        try {
            URI uri = new URI(endpoint);
            request.setConfig(new RequestConfigurationFactory().getRequestConfig(this.timeoutSeconds));
            this.appendAuthorizationHeaderOrLogAnonymousMode((HttpMessage)request);
            Throwable throwable = null;
            Object var6_8 = null;
            try (CloseableHttpClient client = new HttpClientFactory().getHttpClientWithTimeout(this.timeoutSeconds);){
                T t;
                ClassicHttpResponse classicResponse;
                Throwable throwable2;
                block21: {
                    throwable2 = null;
                    Object var9_13 = null;
                    classicResponse = client.executeOpen(null, (ClassicHttpRequest)request, (HttpContext)HttpClientContext.create());
                    Response response = new Response(classicResponse);
                    t = this.handleStatusResponse(response, uri, responseType);
                    if (classicResponse == null) break block21;
                    classicResponse.close();
                }
                return t;
                {
                    catch (Throwable throwable3) {
                        try {
                            if (classicResponse != null) {
                                classicResponse.close();
                            }
                            throw throwable3;
                        }
                        catch (Throwable throwable4) {
                            if (throwable2 == null) {
                                throwable2 = throwable4;
                            } else if (throwable2 != throwable4) {
                                throwable2.addSuppressed(throwable4);
                            }
                            throw throwable2;
                        }
                    }
                }
            }
            catch (Throwable throwable5) {
                if (throwable == null) {
                    throwable = throwable5;
                } else if (throwable != throwable5) {
                    throwable.addSuppressed(throwable5);
                }
                throw throwable;
            }
        }
        catch (IOException | URISyntaxException | ParseException ex) {
            throw new ClientRuntimeException(GENERIC_REST_CALL_ERROR_MESSAGE, ex, endpoint);
        }
    }

    @Override
    public WorkflowHandle launch(Workflow workflow) throws MessageRefusedException {
        String workflowsUrl = UrlUtils.appendPath((String)this.receptionEndpoint, (String)PATH_TO_WORKFLOWS_ENDPOINT).toExternalForm();
        return this.performJsonPostRestCall(workflow, workflowsUrl, WorkflowHandle.class);
    }

    private void appendAuthorizationHeaderOrLogAnonymousMode(HttpMessage request) {
        if (StringUtils.isEmpty((CharSequence)this.authToken)) {
            LOGGER.debug(NO_TOKEN_DEBUG_MESSAGE, new Object[0]);
        } else {
            request.addHeader((Header)new BasicHeader("Authorization", (Object)("Bearer " + this.authToken)));
        }
    }

    private <T> T handleStatusResponse(Response response, URI endPoint, Class<T> responseClass) throws MessageRefusedException, IOException, UnexpectedServerResponseException, ParseException {
        try {
            if (response.getCode() >= 400) {
                if (this.hasJsonMimeType(response)) {
                    throw new MessageRefusedException(endPoint, response.getCode());
                }
                throw new UnexpectedServerResponseException(endPoint, response.getCode(), response.getReasonPhrase());
            }
            if (responseClass == String.class) {
                String string = EntityUtils.toString((HttpEntity)response.getEntity());
                return (T)string;
            }
            T t = this.readValueWithJsonObjectMapper(response, responseClass);
            return t;
        }
        finally {
            response.getEntity().getContent().close();
        }
    }

    private boolean hasJsonMimeType(Response resp) {
        String jsonMimeType = ContentType.APPLICATION_JSON.getMimeType();
        String actualMimeType = resp.mimeType();
        return jsonMimeType.equals(actualMimeType);
    }

    private <T> T readValueWithJsonObjectMapper(Response response, Class<T> responseClass) throws IOException {
        return (T)ObjectMapperFactory.getJsonObjectMapper().readValue(response.getEntity().getContent(), responseClass);
    }
}

