/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.repository;

import java.util.List;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;
import org.springframework.transaction.annotation.Transactional;
import org.squashtest.tm.domain.testautomation.FailureDetail;

public interface FailureDetailDao
extends JpaRepository<FailureDetail, Long> {
    public List<FailureDetail> findByTestPlanItemIdAndMessageIn(Long var1, List<String> var2);

    @Query(value="select fd.id from FailureDetail fd\nwhere fd.automatedExecutions is empty\nand exists (\n    select 1\n    from TestPlanItem tpi\n    join tpi.testPlan tp\n    join tp.campaignLibrary cl\n    join cl.project p\n    where tpi.id = fd.testPlanItem.id\n    and fd.audit.lastModifiedOn < (CURRENT_TIMESTAMP - p.automatedSuitesLifetime day)\n    and (:projectId is null or p.id = :projectId)\n)\n")
    public List<Long> findOldWithNoExecutions(@Param(value="projectId") Long var1);

    @Modifying
    @Transactional
    @Query(value="delete from FailureDetail f where f.id in :ids")
    public void deleteByIds(@Param(value="ids") List<Long> var1);
}

