/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.query;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Set;
import org.squashtest.tm.service.internal.query.InternalEntityType;
import org.squashtest.tm.service.internal.query.InternalQueryModel;
import org.squashtest.tm.service.internal.query.PlannedJoin;
import org.squashtest.tm.service.internal.query.QueryPlan;

class DomainGraph {
    private static final String ATTACHMENT_LIST = "attachmentList";
    private static final String ATTACHMENTS = "attachments";
    private static final String PROJECT = "project";
    private static final String TEST_CASE = "testCase";
    private static final String MILESTONES = "milestones";
    private InternalQueryModel internalQueryModel;
    private InternalEntityType seed;
    private Set<TraversableEntity> nodes = new HashSet<TraversableEntity>();
    private Set<InternalEntityType> visited = new HashSet<InternalEntityType>();

    DomainGraph(InternalQueryModel internalQueryModel, InternalEntityType seed) {
        this.internalQueryModel = internalQueryModel;
        this.seed = seed;
        TraversableEntity campaignNode = new TraversableEntity(InternalEntityType.CAMPAIGN);
        TraversableEntity iterationNode = new TraversableEntity(InternalEntityType.ITERATION);
        TraversableEntity itemNode = new TraversableEntity(InternalEntityType.ITEM_TEST_PLAN);
        TraversableEntity executionNode = new TraversableEntity(InternalEntityType.EXECUTION);
        TraversableEntity issueNode = new TraversableEntity(InternalEntityType.ISSUE);
        TraversableEntity testcaseNode = new TraversableEntity(InternalEntityType.TEST_CASE);
        TraversableEntity reqcoverageNode = new TraversableEntity(InternalEntityType.REQUIREMENT_VERSION_COVERAGE);
        TraversableEntity rversionNode = new TraversableEntity(InternalEntityType.REQUIREMENT_VERSION);
        TraversableEntity requirementNode = new TraversableEntity(InternalEntityType.REQUIREMENT);
        TraversableEntity testPlanNode = new TraversableEntity(InternalEntityType.TEST_PLAN);
        TraversableEntity campaignLibraryNode = new TraversableEntity(InternalEntityType.CAMPAIGN_LIBRARY);
        TraversableEntity sprintNode = new TraversableEntity(InternalEntityType.SPRINT);
        TraversableEntity sprintReqVersionNode = new TraversableEntity(InternalEntityType.SPRINT_REQUIREMENT_VERSION_NODE);
        TraversableEntity teststepNode = new TraversableEntity(InternalEntityType.TEST_CASE_STEP);
        TraversableEntity userNode = new TraversableEntity(InternalEntityType.ITERATION_TEST_PLAN_ASSIGNED_USER);
        TraversableEntity tcnatNode = new TraversableEntity(InternalEntityType.TEST_CASE_NATURE);
        TraversableEntity tctypNode = new TraversableEntity(InternalEntityType.TEST_CASE_TYPE);
        TraversableEntity rvcatNode = new TraversableEntity(InternalEntityType.REQUIREMENT_VERSION_CATEGORY);
        TraversableEntity tcmilNode = new TraversableEntity(InternalEntityType.TEST_CASE_MILESTONE);
        TraversableEntity campmilNode = new TraversableEntity(InternalEntityType.CAMPAIGN_MILESTONE);
        TraversableEntity rvmilNode = new TraversableEntity(InternalEntityType.REQUIREMENT_VERSION_MILESTONE);
        TraversableEntity autoNode = new TraversableEntity(InternalEntityType.AUTOMATED_TEST);
        TraversableEntity extNode = new TraversableEntity(InternalEntityType.AUTOMATED_EXECUTION_EXTENDER);
        TraversableEntity tcAttlistNode = new TraversableEntity(InternalEntityType.TEST_CASE_ATTLIST);
        TraversableEntity tcAttachmentNode = new TraversableEntity(InternalEntityType.TEST_CASE_ATTACHMENT);
        TraversableEntity rvAttlistNode = new TraversableEntity(InternalEntityType.REQUIREMENT_VERSION_ATTLIST);
        TraversableEntity rvAttachmentNode = new TraversableEntity(InternalEntityType.REQUIREMENT_VERSION_ATTACHMENT);
        TraversableEntity campAttlistNode = new TraversableEntity(InternalEntityType.CAMPAIGN_ATTLIST);
        TraversableEntity campAttachmentNode = new TraversableEntity(InternalEntityType.CAMPAIGN_ATTACHMENT);
        TraversableEntity datasetNode = new TraversableEntity(InternalEntityType.DATASET);
        TraversableEntity paramNode = new TraversableEntity(InternalEntityType.PARAMETER);
        TraversableEntity tcProjectNode = new TraversableEntity(InternalEntityType.TEST_CASE_PROJECT);
        TraversableEntity reqProjectNode = new TraversableEntity(InternalEntityType.REQUIREMENT_PROJECT);
        TraversableEntity campProjectNode = new TraversableEntity(InternalEntityType.CAMPAIGN_PROJECT);
        TraversableEntity campLibraryProjectNode = new TraversableEntity(InternalEntityType.CAMPAIGN_LIBRARY_PROJECT);
        TraversableEntity itemSuiteNode = new TraversableEntity(InternalEntityType.ITEM_SUITE);
        TraversableEntity automationRequestNode = new TraversableEntity(InternalEntityType.AUTOMATION_REQUEST);
        TraversableEntity scmRepositoryNode = new TraversableEntity(InternalEntityType.SCM_REPOSITORY);
        TraversableEntity highLevelRequirementNode = new TraversableEntity(InternalEntityType.HIGH_LEVEL_REQUIREMENT);
        this.nodes.addAll(Arrays.asList(campaignNode, iterationNode, itemNode, executionNode, issueNode, testcaseNode, reqcoverageNode, rversionNode, requirementNode, teststepNode, userNode, tcnatNode, tctypNode, rvcatNode, tcmilNode, rvmilNode, campmilNode, autoNode, extNode, tcAttlistNode, tcAttachmentNode, rvAttlistNode, rvAttachmentNode, campAttlistNode, campAttlistNode, campAttachmentNode, datasetNode, paramNode, tcProjectNode, reqProjectNode, campProjectNode, itemSuiteNode, automationRequestNode, scmRepositoryNode, highLevelRequirementNode, testPlanNode, campaignLibraryNode, campLibraryProjectNode, sprintNode, sprintReqVersionNode));
        this.addEdge(campaignNode, iterationNode, "iterations");
        this.addEdge(iterationNode, campaignNode, "campaign");
        this.addEdge(iterationNode, itemNode, "testPlan.testPlanItems");
        this.addEdge(itemNode, iterationNode, "testPlan.parentIteration");
        this.addEdge(itemNode, executionNode, "executions");
        this.addEdge(executionNode, itemNode, "testPlanItem");
        this.addEdge(executionNode, issueNode, "issues");
        this.addEdge(issueNode, executionNode, "execution");
        this.addEdge(itemNode, testcaseNode, "referencedTestCase");
        this.addEdge(testcaseNode, itemNode, "referencedTestCase", PlannedJoin.JoinType.UNMAPPED);
        this.addEdge(itemNode, datasetNode, "referencedDataset");
        this.addEdge(testcaseNode, reqcoverageNode, "requirementVersionCoverages");
        this.addEdge(reqcoverageNode, testcaseNode, "verifyingTestCase");
        this.addEdge(reqcoverageNode, rversionNode, "verifiedRequirementVersion");
        this.addEdge(rversionNode, reqcoverageNode, "requirementVersionCoverages");
        this.addEdge(rversionNode, requirementNode, "requirement");
        this.addEdge(requirementNode, rversionNode, "versions");
        this.addEdge(itemNode, testPlanNode, "testPlan");
        this.addEdge(testPlanNode, campaignLibraryNode, "campaignLibrary");
        this.addEdge(campaignLibraryNode, campLibraryProjectNode, PROJECT);
        this.addEdge(testPlanNode, sprintReqVersionNode, "testPlan", PlannedJoin.JoinType.UNMAPPED);
        this.addEdge(sprintReqVersionNode, sprintNode, "sprint");
        this.addEdge(itemNode, userNode, "assignee");
        this.addEdge(testcaseNode, teststepNode, "steps");
        this.addEdge(testcaseNode, tcnatNode, "nature");
        this.addEdge(testcaseNode, tctypNode, "type");
        this.addEdge(testcaseNode, tcmilNode, MILESTONES);
        this.addEdge(rversionNode, rvcatNode, "category");
        this.addEdge(rversionNode, rvmilNode, MILESTONES);
        this.addEdge(campaignNode, campmilNode, MILESTONES);
        this.addEdge(testcaseNode, autoNode, "automatedTest");
        this.addEdge(executionNode, extNode, "automatedExecutionExtender");
        this.addEdge(testcaseNode, datasetNode, "datasets");
        this.addEdge(datasetNode, testcaseNode, TEST_CASE);
        this.addEdge(testcaseNode, paramNode, "parameters");
        this.addEdge(paramNode, testcaseNode, TEST_CASE);
        this.addEdge(testcaseNode, tcAttlistNode, ATTACHMENT_LIST);
        this.addEdge(tcAttlistNode, tcAttachmentNode, ATTACHMENTS);
        this.addEdge(rversionNode, rvAttlistNode, ATTACHMENT_LIST);
        this.addEdge(rvAttlistNode, rvAttachmentNode, ATTACHMENTS);
        this.addEdge(campaignNode, campAttlistNode, ATTACHMENT_LIST);
        this.addEdge(campAttlistNode, campAttachmentNode, ATTACHMENTS);
        this.addEdge(testcaseNode, tcProjectNode, PROJECT);
        this.addEdge(tcProjectNode, testcaseNode, PROJECT, PlannedJoin.JoinType.UNMAPPED);
        this.addEdge(requirementNode, reqProjectNode, PROJECT);
        this.addEdge(reqProjectNode, requirementNode, PROJECT, PlannedJoin.JoinType.UNMAPPED);
        this.addEdge(campaignNode, campProjectNode, PROJECT);
        this.addEdge(campProjectNode, campaignNode, PROJECT, PlannedJoin.JoinType.UNMAPPED);
        this.addEdge(itemNode, itemSuiteNode, "testSuites");
        this.addEdge(itemSuiteNode, itemNode, "testPlanItems");
        this.addEdge(testcaseNode, automationRequestNode, "automationRequest");
        this.addEdge(automationRequestNode, testcaseNode, TEST_CASE);
        this.addEdge(testcaseNode, scmRepositoryNode, "scmRepository");
        this.addEdge(scmRepositoryNode, testcaseNode, TEST_CASE);
        this.addEdge(requirementNode, highLevelRequirementNode, "highLevelRequirement");
        this.addEdge(highLevelRequirementNode, requirementNode, "requirement");
    }

    QueryPlan getQueryPlan() {
        QueryPlan plan = this.morphToQueryPlan();
        plan.trim(this.internalQueryModel);
        return plan;
    }

    private void addEdge(TraversableEntity src, TraversableEntity dest, String attribute) {
        PlannedJoin join = new PlannedJoin(src.type(), dest.type(), attribute);
        src.addJoinInfo(join);
    }

    private void addEdge(TraversableEntity src, TraversableEntity dest, String attribute, PlannedJoin.JoinType jointype) {
        PlannedJoin join = new PlannedJoin(src.type(), dest.type(), attribute, jointype);
        src.addJoinInfo(join);
    }

    private TraversableEntity getNode(InternalEntityType type) {
        for (TraversableEntity node : this.nodes) {
            if (node.type() != type) continue;
            return node;
        }
        return null;
    }

    protected boolean shouldNavigate(PlannedJoin join) {
        InternalEntityType dest = join.getDest();
        return !this.visited.contains((Object)dest);
    }

    private QueryPlan morphToQueryPlan() {
        QueryPlan plan = new QueryPlan();
        TraversableEntity rootNode = this.getNode(this.seed);
        QueryPlan.TraversedEntity treeRoot = rootNode.toTraversedEntity();
        plan.addNode(null, treeRoot);
        LinkedList<TraversableEntity> queue = new LinkedList<TraversableEntity>();
        queue.add(rootNode);
        while (!queue.isEmpty()) {
            TraversableEntity currentNode = (TraversableEntity)queue.remove();
            InternalEntityType currentEntity = currentNode.type();
            Iterator<PlannedJoin> iter = currentNode.getJoinInfos().iterator();
            while (iter.hasNext()) {
                PlannedJoin currentJoin = iter.next();
                TraversableEntity outNode = this.getNode(currentJoin.getDest());
                if (this.shouldNavigate(currentJoin)) {
                    QueryPlan.TraversedEntity outTree = outNode.toTraversedEntity();
                    plan.addNode(currentEntity, outTree, currentJoin);
                    outNode.removeEdges(currentEntity);
                    queue.add(outNode);
                    this.visited.add(outNode.type());
                    continue;
                }
                iter.remove();
            }
        }
        return plan;
    }

    static final class TraversableEntity {
        private InternalEntityType type;
        private Collection<PlannedJoin> joinInfos = new ArrayList<PlannedJoin>();

        private TraversableEntity(InternalEntityType type) {
            this.type = type;
        }

        QueryPlan.TraversedEntity toTraversedEntity() {
            return new QueryPlan.TraversedEntity(this.type);
        }

        public String toString() {
            return this.type.toString();
        }

        void addJoinInfo(PlannedJoin joininfo) {
            this.joinInfos.add(joininfo);
        }

        void removeJoinInfo(PlannedJoin joininfo) {
            this.joinInfos.remove((Object)joininfo);
        }

        Collection<PlannedJoin> getJoinInfos() {
            return this.joinInfos;
        }

        void clearJoins() {
            this.joinInfos.clear();
        }

        void removeEdges(InternalEntityType dest) {
            Iterator<PlannedJoin> iter = this.joinInfos.iterator();
            while (iter.hasNext()) {
                PlannedJoin nextJoin = iter.next();
                if (nextJoin.getDest() != dest) continue;
                iter.remove();
            }
        }

        InternalEntityType type() {
            return this.type;
        }

        public int hashCode() {
            int result = 1;
            result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            TraversableEntity other = (TraversableEntity)obj;
            return this.type == other.type;
        }
    }
}

