/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.display.grid.campaign;

import java.util.Arrays;
import java.util.List;
import org.jooq.Condition;
import org.jooq.Field;
import org.jooq.GroupField;
import org.jooq.Record2;
import org.jooq.SelectField;
import org.jooq.SelectHavingStep;
import org.jooq.SortField;
import org.jooq.Table;
import org.jooq.TableLike;
import org.jooq.impl.DSL;
import org.squashtest.tm.domain.execution.ExecutionStatus;
import org.squashtest.tm.domain.testcase.TestCaseImportance;
import org.squashtest.tm.domain.testcase.TestCaseKind;
import org.squashtest.tm.jooq.domain.Tables;
import org.squashtest.tm.jooq.domain.tables.TestCaseLibraryNode;
import org.squashtest.tm.service.internal.display.grid.AbstractGrid;
import org.squashtest.tm.service.internal.display.grid.columns.GridColumn;
import org.squashtest.tm.service.internal.display.grid.columns.LevelEnumColumn;
import org.squashtest.tm.service.internal.repository.display.utils.ConditionsConstants;

public class TestPlanItemExecutionGrid
extends AbstractGrid {
    private final Long testPlanItemId;

    public TestPlanItemExecutionGrid(Long testPlanItemId) {
        this.testPlanItemId = testPlanItemId;
    }

    @Override
    protected List<GridColumn> getColumns() {
        return Arrays.asList(new GridColumn((Field<?>)Tables.EXECUTION.EXECUTION_ID), new GridColumn(Tables.EXECUTION.EXECUTION_ORDER.as("EXECUTION_ORDER")), new GridColumn(Tables.PROJECT.PROJECT_ID.as("PROJECT_ID")), new GridColumn(Tables.EXECUTION.EXECUTION_MODE.as("INFERRED_EXECUTION_MODE")), new GridColumn(Tables.EXECUTION.REFERENCE.as("EXECUTION_REFERENCE")), new GridColumn(Tables.EXECUTION.NAME.as("EXECUTION_NAME")), new LevelEnumColumn(TestCaseImportance.class, (Field<String>)Tables.EXECUTION.IMPORTANCE), new GridColumn(Tables.EXECUTION.DATASET_LABEL.as("DATASET_NAME")), new LevelEnumColumn(ExecutionStatus.class, (Field<String>)Tables.EXECUTION.EXECUTION_STATUS), new GridColumn(Tables.EXECUTION.LAST_EXECUTED_BY.as("USER")), new GridColumn((Field<?>)Tables.EXECUTION.LAST_EXECUTED_ON), new GridColumn(this.countIssue().as("ISSUE_COUNT")), new GridColumn(Tables.TEST_PLAN_ITEM.TEST_PLAN_ITEM_ID.as("TEST_PLAN_ITEM_ID")), new GridColumn(this.getTestCaseKind().field("KIND")));
    }

    private Field<Integer> countIssue() {
        return DSL.selectCount().from((TableLike)Tables.EXECUTION_ISSUES_CLOSURE).where(Tables.EXECUTION_ISSUES_CLOSURE.EXECUTION_ID.eq((Field)Tables.EXECUTION.EXECUTION_ID)).asField("ISSUE_COUNT");
    }

    @Override
    protected Table<?> getTable() {
        SelectHavingStep<Record2<Long, String>> testCaseKind = this.getTestCaseKind();
        return Tables.EXECUTION.innerJoin((TableLike)Tables.TEST_PLAN_ITEM).on(Tables.EXECUTION.TEST_PLAN_ITEM_ID.eq((Field)Tables.TEST_PLAN_ITEM.TEST_PLAN_ITEM_ID)).innerJoin((TableLike)Tables.TEST_PLAN).on(Tables.TEST_PLAN_ITEM.TEST_PLAN_ID.eq((Field)Tables.TEST_PLAN.TEST_PLAN_ID)).innerJoin((TableLike)Tables.CAMPAIGN_LIBRARY).on(Tables.TEST_PLAN.CL_ID.eq((Field)Tables.CAMPAIGN_LIBRARY.CL_ID)).innerJoin((TableLike)Tables.PROJECT).on(Tables.PROJECT.CL_ID.eq((Field)Tables.CAMPAIGN_LIBRARY.CL_ID)).where(Tables.TEST_PLAN_ITEM.TEST_PLAN_ITEM_ID.eq((Object)this.testPlanItemId)).leftJoin(testCaseKind).on(Tables.EXECUTION.EXECUTION_ID.eq(testCaseKind.field("ITEM_ID", Long.class)));
    }

    @Override
    protected Field<?> getIdentifier() {
        return Tables.EXECUTION.EXECUTION_ID;
    }

    @Override
    protected Field<?> getProjectIdentifier() {
        return Tables.PROJECT.PROJECT_ID;
    }

    @Override
    protected SortField<?> getDefaultOrder() {
        return Tables.EXECUTION.EXECUTION_ORDER.desc();
    }

    private SelectHavingStep<Record2<Long, String>> getTestCaseKind() {
        return DSL.select((SelectField)Tables.EXECUTION.EXECUTION_ID.as("ITEM_ID"), (SelectField)DSL.when((Condition)Tables.SCRIPTED_TEST_CASE.TCLN_ID.isNotNull(), (Object)TestCaseKind.GHERKIN.toString()).when(Tables.KEYWORD_TEST_CASE.TCLN_ID.isNotNull(), (Object)TestCaseKind.KEYWORD.toString()).when(Tables.EXPLORATORY_TEST_CASE.TCLN_ID.isNotNull(), (Object)TestCaseKind.EXPLORATORY.toString()).otherwise((Object)TestCaseKind.STANDARD.toString()).as("KIND")).from((TableLike)Tables.EXECUTION).innerJoin((TableLike)Tables.TEST_CASE).on(Tables.EXECUTION.TCLN_ID.eq((Field)Tables.TEST_CASE.TCLN_ID)).innerJoin((TableLike)TestCaseLibraryNode.TEST_CASE_LIBRARY_NODE).on(Tables.TEST_CASE.TCLN_ID.eq((Field)TestCaseLibraryNode.TEST_CASE_LIBRARY_NODE.TCLN_ID).and(ConditionsConstants.TCLN_NOT_IN_BIN)).leftJoin((TableLike)Tables.SCRIPTED_TEST_CASE).on(Tables.TEST_CASE.TCLN_ID.eq((Field)Tables.SCRIPTED_TEST_CASE.TCLN_ID)).leftJoin((TableLike)Tables.KEYWORD_TEST_CASE).on(Tables.TEST_CASE.TCLN_ID.eq((Field)Tables.KEYWORD_TEST_CASE.TCLN_ID)).leftJoin((TableLike)Tables.EXPLORATORY_TEST_CASE).on(Tables.TEST_CASE.TCLN_ID.eq((Field)Tables.EXPLORATORY_TEST_CASE.TCLN_ID)).groupBy(new GroupField[]{Tables.EXECUTION.EXECUTION_ID, Tables.SCRIPTED_TEST_CASE.TCLN_ID, Tables.KEYWORD_TEST_CASE.TCLN_ID, Tables.EXPLORATORY_TEST_CASE.TCLN_ID});
    }
}

