/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.deletion.helper.testcase;

import java.util.Collection;
import java.util.Set;
import org.jooq.Condition;
import org.jooq.Field;
import org.jooq.Record;
import org.jooq.Select;
import org.jooq.SelectConditionStep;
import org.jooq.SelectOrderByStep;
import org.jooq.SelectSelectStep;
import org.jooq.TableLike;
import org.jooq.impl.DSL;
import org.squashtest.tm.jooq.domain.Tables;
import org.squashtest.tm.service.internal.deletion.NodeScope;
import org.squashtest.tm.service.internal.repository.display.utils.ConditionsConstants;

public final class TestCaseNodeScopeQueryHelper {
    private TestCaseNodeScopeQueryHelper() {
    }

    public static <R extends Record> Select<R> buildDeletedTestCaseNodeScopeQuery(NodeScope scope, SelectSelectStep<R> select) {
        return TestCaseNodeScopeQueryHelper.buildTestCaseNodeScopeQuery(scope, select, ConditionsConstants.TCLN_IN_BIN);
    }

    public static <R extends Record> Select<R> buildTestCaseNodeScopeQuery(NodeScope scope, SelectSelectStep<R> select, Condition condition) {
        if (scope.isEmpty()) {
            throw new IllegalArgumentException("At least one of library ids or node ids must be provided.");
        }
        SelectConditionStep<R> query = null;
        if (scope.hasLibraries()) {
            query = TestCaseNodeScopeQueryHelper.getLibrariesScopeContent(select, condition, scope.getLibraryIds());
        }
        if (scope.hasNodes()) {
            Select folderQuery = TestCaseNodeScopeQueryHelper.getNodesScopeContent(select, condition, scope.getNodeIds());
            query = query == null ? folderQuery : query.union(folderQuery);
        }
        return query;
    }

    private static <R extends Record> SelectConditionStep<R> getLibrariesScopeContent(SelectSelectStep<R> select, Condition condition, Set<Long> libraryIds) {
        SelectSelectStep clone = DSL.select((Collection)select.getSelect());
        return clone.from((TableLike)Tables.TEST_CASE_LIBRARY_NODE).innerJoin((TableLike)Tables.PROJECT).on(Tables.TEST_CASE_LIBRARY_NODE.PROJECT_ID.eq((Field)Tables.PROJECT.PROJECT_ID)).where(Tables.PROJECT.TCL_ID.in(libraryIds).and(condition));
    }

    private static <R extends Record> SelectOrderByStep<R> getNodesScopeContent(SelectSelectStep<R> select, Condition condition, Set<Long> nodeIds) {
        return select.from((TableLike)Tables.TCLN_RELATIONSHIP_CLOSURE).innerJoin((TableLike)Tables.TEST_CASE_LIBRARY_NODE).on(Tables.TCLN_RELATIONSHIP_CLOSURE.DESCENDANT_ID.eq((Field)Tables.TEST_CASE_LIBRARY_NODE.TCLN_ID)).where(Tables.TCLN_RELATIONSHIP_CLOSURE.ANCESTOR_ID.in(nodeIds).and(condition));
    }
}

