/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.bugtracker.knownissues.local;

import org.jooq.Condition;
import org.jooq.DSLContext;
import org.jooq.Field;
import org.jooq.GroupField;
import org.jooq.Record4;
import org.jooq.Select;
import org.jooq.SelectConditionStep;
import org.jooq.SelectField;
import org.jooq.SelectHavingStep;
import org.jooq.Table;
import org.jooq.TableLike;
import org.jooq.impl.DSL;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;
import org.squashtest.tm.jooq.domain.Tables;
import org.squashtest.tm.jooq.domain.tables.TestPlan;
import org.squashtest.tm.service.internal.bugtracker.knownissues.local.AbstractDefaultLocalKnownIssueFinder;

@Repository
@Transactional(readOnly=true)
public class CampaignFolderKnownIssueFinder
extends AbstractDefaultLocalKnownIssueFinder {
    public CampaignFolderKnownIssueFinder(DSLContext dsl) {
        super(dsl);
    }

    @Override
    public int countKnownIssues(Long entityId) {
        SelectHavingStep<Record4<Long, Long, String, String>> groupedSelect = this.selectKnownIssues(entityId);
        return this.dsl.fetchCount(groupedSelect);
    }

    private Table<?> getTestPlanTable(long ancestorId) {
        SelectConditionStep campaignSelect = DSL.select((SelectField)Tables.ITERATION.TEST_PLAN_ID).from((TableLike)Tables.CLN_RELATIONSHIP_CLOSURE).join((TableLike)Tables.CAMPAIGN_ITERATION).on(Tables.CLN_RELATIONSHIP_CLOSURE.DESCENDANT_ID.eq((Field)Tables.CAMPAIGN_ITERATION.CAMPAIGN_ID)).join((TableLike)Tables.ITERATION).on(Tables.CAMPAIGN_ITERATION.ITERATION_ID.eq((Field)Tables.ITERATION.ITERATION_ID)).where(Tables.CLN_RELATIONSHIP_CLOSURE.ANCESTOR_ID.eq((Object)ancestorId));
        SelectConditionStep sprintSelect = DSL.select((SelectField)Tables.SPRINT_REQ_VERSION.TEST_PLAN_ID).from((TableLike)Tables.CLN_RELATIONSHIP_CLOSURE).join((TableLike)Tables.SPRINT_REQ_VERSION).on(Tables.CLN_RELATIONSHIP_CLOSURE.DESCENDANT_ID.eq((Field)Tables.SPRINT_REQ_VERSION.SPRINT_ID)).where(Tables.CLN_RELATIONSHIP_CLOSURE.ANCESTOR_ID.eq((Object)ancestorId));
        Table tpUnion = campaignSelect.union((Select)sprintSelect).asTable("tp_union");
        Field testPlanIdField = tpUnion.field("TEST_PLAN_ID", Long.class);
        return CampaignFolderKnownIssueFinder.getIssueToBugtrackerBindingJoin().join((TableLike)tpUnion).on(TestPlan.TEST_PLAN.TEST_PLAN_ID.eq(testPlanIdField));
    }

    @Override
    protected SelectHavingStep<Record4<Long, Long, String, String>> selectKnownIssues(long entityId) {
        return this.dsl.select((SelectField)Tables.PROJECT.PROJECT_ID, (SelectField)Tables.ISSUE.BUGTRACKER_ID, (SelectField)Tables.ISSUE.REMOTE_ISSUE_ID, (SelectField)DSL.groupConcatDistinct((Field)Tables.EXECUTION.EXECUTION_ID)).from(this.getTestPlanTable(entityId)).where(this.getMatchCondition(entityId)).groupBy(new GroupField[]{Tables.PROJECT.PROJECT_ID, Tables.ISSUE.BUGTRACKER_ID, Tables.ISSUE.REMOTE_ISSUE_ID});
    }

    @Override
    protected Condition getMatchCondition(long campaignFolderId) {
        return Tables.ISSUE.BUGTRACKER_ID.eq((Field)Tables.PROJECT.BUGTRACKER_ID);
    }
}

