/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.batchimport.excel;

import org.apache.commons.lang3.StringUtils;
import org.apache.poi.ss.usermodel.Cell;
import org.squashtest.tm.service.internal.batchimport.excel.AbstractTypeBasedCellValueCoercer;

public class OptionalStringArrayCellCoercer
extends AbstractTypeBasedCellValueCoercer<String[]> {
    private static final String DEFAULT_SEPARATOR = "|";
    private static final String[] EMPTY = new String[0];
    public static final OptionalStringArrayCellCoercer INSTANCE = new OptionalStringArrayCellCoercer();
    private final String separator;

    protected OptionalStringArrayCellCoercer() {
        this.separator = DEFAULT_SEPARATOR;
    }

    @Override
    protected String[] coerceBlankCell(Cell cell) {
        return EMPTY;
    }

    @Override
    protected String[] coerceStringCell(Cell cell) {
        String val = cell.getStringCellValue();
        if (val != null) {
            String[] milestones = StringUtils.split((String)val, (String)this.separator);
            int i = 0;
            while (i < milestones.length) {
                milestones[i] = StringUtils.trim((String)milestones[i]);
                ++i;
            }
            return milestones;
        }
        return EMPTY;
    }
}

