/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.batchexport;

import jakarta.inject.Inject;
import jakarta.inject.Named;
import jakarta.inject.Provider;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.springframework.context.MessageSource;
import org.springframework.stereotype.Service;
import org.squashtest.tm.service.internal.batchexport.ExcelExporter;
import org.squashtest.tm.service.internal.batchexport.SearchSimpleTestCaseExcelExporter;
import org.squashtest.tm.service.internal.batchexport.SearchTestCaseExcelExporter;
import org.squashtest.tm.service.internal.batchexport.SimpleExcelExporter;
import org.squashtest.tm.service.internal.batchexport.TestCaseExportDao;
import org.squashtest.tm.service.internal.batchexport.models.CoverageModel;
import org.squashtest.tm.service.internal.batchexport.models.DatasetModel;
import org.squashtest.tm.service.internal.batchexport.models.ExportModel;
import org.squashtest.tm.service.internal.batchexport.models.ParameterModel;
import org.squashtest.tm.service.internal.batchexport.models.TestCaseModel;
import org.squashtest.tm.service.internal.batchexport.models.TestStepModel;
import org.squashtest.tm.service.internal.library.PathService;

@Service
public class TestCaseExcelExporterService {
    private static final int BATCH_SIZE = 50;
    @Inject
    private TestCaseExportDao testCaseExportDao;
    @Inject
    private PathService pathService;
    @Inject
    @Named(value="excelExporter")
    private Provider<ExcelExporter> exporterProvider;
    @Inject
    private Provider<SearchTestCaseExcelExporter> searchExporterProvider;
    @Inject
    private Provider<SearchSimpleTestCaseExcelExporter> simpleSearchExporterProvider;

    public File exportAsExcel(List<Long> testCaseIds, boolean keepRteFormat, MessageSource messageSource) {
        return this.doExportAsExcel(testCaseIds, keepRteFormat, messageSource, (ExcelExporter)this.exporterProvider.get());
    }

    public File searchExportAsExcel(List<Long> testCaseIds, boolean keepRteFormat, MessageSource messageSource) {
        return this.doExportAsExcel(testCaseIds, keepRteFormat, messageSource, (ExcelExporter)this.searchExporterProvider.get());
    }

    public File searchSimpleExportAsExcel(List<Long> testCaseIds, boolean keepRteFormat, MessageSource messageSource, Boolean simplifiedColumnDisplayForTest) {
        return this.doSimpleExportAsExcel(testCaseIds, keepRteFormat, messageSource, (SimpleExcelExporter)this.simpleSearchExporterProvider.get(), simplifiedColumnDisplayForTest);
    }

    private File doExportAsExcel(List<Long> testCaseIds, boolean keepRteFormat, MessageSource messageSource, ExcelExporter exporter) {
        int idx = 0;
        int max = Math.min(idx + 50, testCaseIds.size());
        exporter.setMessageSource(messageSource);
        HashMap<Long, String> pathById = new HashMap<Long, String>(testCaseIds.size());
        this.populatePathsCache(pathById, testCaseIds);
        while (idx < testCaseIds.size()) {
            List<Long> ids = testCaseIds.subList(idx, max);
            ExportModel model = this.testCaseExportDao.findModel(ids);
            this.addPaths(pathById, model);
            this.sort(model);
            exporter.appendToWorkbook(model, keepRteFormat);
            idx = max;
            max = Math.min(idx + 50, testCaseIds.size());
        }
        return exporter.print();
    }

    private File doSimpleExportAsExcel(List<Long> testCaseIds, boolean keepRteFormat, MessageSource messageSource, SimpleExcelExporter exporter, Boolean simplifiedColumnDisplayForTest) {
        int idx = 0;
        int max = Math.min(idx + 50, testCaseIds.size());
        exporter.setMessageSource(messageSource);
        while (idx < testCaseIds.size()) {
            List<Long> ids = testCaseIds.subList(idx, max);
            ExportModel model = this.testCaseExportDao.findSimpleModel(ids);
            exporter.createHeaders(simplifiedColumnDisplayForTest);
            exporter.simpleAppendToWorkbook(model, keepRteFormat, simplifiedColumnDisplayForTest);
            idx = max;
            max = Math.min(idx + 50, testCaseIds.size());
        }
        return exporter.print();
    }

    private void populatePathsCache(Map<Long, String> pathById, Set<Long> ids) {
        this.populatePathsCache(pathById, new ArrayList<Long>(ids));
    }

    private void populatePathsCache(Map<Long, String> pathById, List<Long> ids) {
        List paths = !ids.isEmpty() ? this.pathService.buildTestCasesPaths(ids) : Collections.emptyList();
        int i = 0;
        while (i < ids.size()) {
            pathById.put(ids.get(i), (String)paths.get(i));
            ++i;
        }
    }

    private void addPaths(Map<Long, String> pathById, ExportModel models) {
        this.addPathsForTestCase(pathById, models);
        this.addPathsForTestSteps(pathById, models);
        this.addPathsForParameters(pathById, models);
        this.addPathsForDatasets(pathById, models);
    }

    private void addPathsForTestCase(Map<Long, String> pathById, ExportModel models) {
        for (TestCaseModel model : models.getTestCases()) {
            Long id = model.getId();
            String path = pathById.get(id);
            model.setPath(path);
        }
    }

    private void addPathsForTestSteps(Map<Long, String> pathById, ExportModel models) {
        LinkedList<TestStepModel> callsteps = new LinkedList<TestStepModel>();
        HashSet<Long> calledTC = new HashSet<Long>();
        for (TestStepModel model : models.getTestSteps()) {
            Long id = model.getTcOwnerId();
            String path = pathById.get(id);
            model.setTcOwnerPath(path);
            if (model.getIsCallStep() <= 0) continue;
            Long callid = Long.valueOf(model.getAction());
            if (pathById.containsKey(callid)) {
                String callaction = "CALL " + pathById.get(callid);
                model.setAction(callaction);
                continue;
            }
            callsteps.add(model);
            calledTC.add(callid);
        }
        if (!calledTC.isEmpty()) {
            this.populatePathsCache(pathById, calledTC);
            for (TestStepModel model : callsteps) {
                Long callid = Long.valueOf(model.getAction());
                String callaction = "CALL " + pathById.get(callid);
                model.setAction(callaction);
            }
        }
    }

    private void addPathsForParameters(Map<Long, String> pathById, ExportModel models) {
        for (ParameterModel model : models.getParameters()) {
            Long id = model.getTcOwnerId();
            String path = pathById.get(id);
            model.setTcOwnerPath(path);
        }
    }

    private void addPathsForDatasets(Map<Long, String> pathById, ExportModel models) {
        String path;
        LinkedList<DatasetModel> unresolvedPOwnerPath = new LinkedList<DatasetModel>();
        LinkedList<Long> pOwnerIds = new LinkedList<Long>();
        for (DatasetModel model : models.getDatasets()) {
            Long id = model.getOwnerId();
            path = pathById.get(id);
            model.setTcOwnerPath(path);
            Long pOwnerId = model.getParamOwnerId();
            if (pathById.containsKey(pOwnerId)) {
                String pOwnerPath = pathById.get(pOwnerId);
                model.setParamOwnerPath(pOwnerPath);
                continue;
            }
            unresolvedPOwnerPath.add(model);
            pOwnerIds.add(pOwnerId);
        }
        if (!pOwnerIds.isEmpty()) {
            this.populatePathsCache(pathById, pOwnerIds);
            for (DatasetModel model : unresolvedPOwnerPath) {
                Long ownId = model.getParamOwnerId();
                path = pathById.get(ownId);
                model.setParamOwnerPath(path);
            }
        }
    }

    private void sort(ExportModel models) {
        Collections.sort(models.getTestCases(), TestCaseModel.COMPARATOR);
        Collections.sort(models.getTestSteps(), TestStepModel.COMPARATOR);
        Collections.sort(models.getParameters(), ParameterModel.COMPARATOR);
        Collections.sort(models.getDatasets(), DatasetModel.COMPARATOR);
        Collections.sort(models.getCoverages(), CoverageModel.TC_COMPARATOR);
    }
}

