/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.repository.hibernate;

import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.jooq.AggregateFunction;
import org.jooq.Condition;
import org.jooq.DSLContext;
import org.jooq.Field;
import org.jooq.GroupField;
import org.jooq.OrderField;
import org.jooq.Record2;
import org.jooq.Record4;
import org.jooq.Result;
import org.jooq.SelectField;
import org.jooq.Table;
import org.jooq.TableLike;
import org.jooq.WindowSpecification;
import org.jooq.impl.DSL;
import org.springframework.stereotype.Repository;
import org.squashtest.tm.domain.campaign.SprintReqVersionValidationStatus;
import org.squashtest.tm.domain.execution.ExecutionStatus;
import org.squashtest.tm.domain.testcase.TestCaseImportance;
import org.squashtest.tm.jooq.domain.Tables;
import org.squashtest.tm.jooq.domain.tables.TestPlanItem;
import org.squashtest.tm.service.internal.repository.SprintStatisticsDao;
import org.squashtest.tm.service.internal.repository.display.utils.ConditionsConstants;
import org.squashtest.tm.service.statistics.campaign.CampaignTestCaseSuccessRateStatistics;
import org.squashtest.tm.service.statistics.requirement.RequirementBoundTestCasesStatistics;

@Repository
public class SprintStatisticsDaoImpl
implements SprintStatisticsDao {
    private static final String EMPTY_STRING = "";
    private static final String PATH_SEPARATOR = " / ";
    private static final String NAME_REFERENCE_SEPARATOR = " - ";
    private static final String RANKED_IDS = "ranked_ids";
    private static final String NO_COUNT = "none";
    private static final String ONE_COUNT = "one";
    private static final String MULTIPLE_COUNT = "many";
    private final DSLContext dsl;

    public SprintStatisticsDaoImpl(DSLContext dsl) {
        this.dsl = dsl;
    }

    @Override
    public Map<SprintReqVersionValidationStatus, Integer> countSprintRequirementsByValidationStatuses(List<Long> sprintIds) {
        return this.dsl.select((SelectField)Tables.SPRINT_REQ_VERSION.VALIDATION_STATUS, (SelectField)DSL.count((Field)Tables.SPRINT_REQ_VERSION.VALIDATION_STATUS)).from((TableLike)Tables.SPRINT_REQ_VERSION).where(Tables.SPRINT_REQ_VERSION.SPRINT_ID.in(sprintIds)).groupBy(new GroupField[]{Tables.SPRINT_REQ_VERSION.VALIDATION_STATUS}).fetch().intoMap(result -> SprintReqVersionValidationStatus.valueOf((String)((String)result.value1())), Record2::value2);
    }

    @Override
    public CampaignTestCaseSuccessRateStatistics countSprintTestCaseSuccessRate(List<Long> stpiIds) {
        CampaignTestCaseSuccessRateStatistics statistics = new CampaignTestCaseSuccessRateStatistics();
        this.dsl.select((SelectField)Tables.TEST_CASE.IMPORTANCE, (SelectField)Tables.TEST_PLAN_ITEM.EXECUTION_STATUS, (SelectField)DSL.count((Field)Tables.TEST_CASE.IMPORTANCE)).from((TableLike)Tables.TEST_PLAN_ITEM).innerJoin((TableLike)Tables.TEST_CASE).on(Tables.TEST_PLAN_ITEM.TCLN_ID.eq((Field)Tables.TEST_CASE.TCLN_ID)).innerJoin((TableLike)Tables.TEST_CASE_LIBRARY_NODE).on(Tables.TEST_CASE.TCLN_ID.eq((Field)Tables.TEST_CASE_LIBRARY_NODE.TCLN_ID).and(ConditionsConstants.TCLN_NOT_IN_BIN)).where(Tables.TEST_PLAN_ITEM.TEST_PLAN_ITEM_ID.in(stpiIds)).groupBy(new GroupField[]{Tables.TEST_CASE.IMPORTANCE, Tables.TEST_PLAN_ITEM.EXECUTION_STATUS}).fetch().forEach(record -> statistics.add(TestCaseImportance.valueOf((String)((String)record.value1())), ExecutionStatus.valueOf((String)((String)record.value2())), ((Integer)record.value3()).longValue()));
        return statistics;
    }

    @Override
    public Result<Record2<String, Integer>> countUnvalidatedSprintRequirementsByCriticality(List<Long> sprintIds) {
        AggregateFunction countField = DSL.count();
        return this.dsl.select((SelectField)DSL.coalesce((Field)Tables.REQUIREMENT_VERSION.CRITICALITY, (Field[])new Field[]{Tables.SPRINT_REQ_VERSION.CRITICALITY}).as("CRITICALITY"), (SelectField)countField).from((TableLike)Tables.SPRINT_REQ_VERSION).innerJoin((TableLike)Tables.SPRINT).on(Tables.SPRINT.CLN_ID.eq((Field)Tables.SPRINT_REQ_VERSION.SPRINT_ID)).leftJoin((TableLike)Tables.REQUIREMENT_VERSION).on(Tables.REQUIREMENT_VERSION.RES_ID.eq((Field)Tables.SPRINT_REQ_VERSION.REQ_VERSION_ID)).where(Tables.SPRINT.CLN_ID.in(sprintIds).and(Tables.SPRINT_REQ_VERSION.VALIDATION_STATUS.notEqual((Object)SprintReqVersionValidationStatus.VALIDATED.name()))).groupBy(new GroupField[]{DSL.coalesce((Field)Tables.REQUIREMENT_VERSION.CRITICALITY, (Field[])new Field[]{Tables.SPRINT_REQ_VERSION.CRITICALITY})}).orderBy((OrderField)countField.desc(), (OrderField)DSL.lower((Field)DSL.coalesce((Field)Tables.REQUIREMENT_VERSION.CRITICALITY, (Field[])new Field[]{Tables.SPRINT_REQ_VERSION.CRITICALITY})).asc()).fetch();
    }

    @Override
    public List<Long> gatherStpiIdsForTCInScopeForSprints(List<Long> sprintIds) {
        return this.dsl.select((SelectField)Tables.TEST_PLAN_ITEM.TEST_PLAN_ITEM_ID).from((TableLike)Tables.SPRINT_REQ_VERSION).innerJoin((TableLike)Tables.TEST_PLAN_ITEM).on(Tables.SPRINT_REQ_VERSION.TEST_PLAN_ID.eq((Field)Tables.TEST_PLAN_ITEM.TEST_PLAN_ID).and(Tables.TEST_PLAN_ITEM.DELETED.isFalse())).where(Tables.SPRINT_REQ_VERSION.SPRINT_ID.in(sprintIds)).fetchInto(Long.class);
    }

    @Override
    public List<Long> gatherLatestStpiIdsForTCInScopeForSprints(List<Long> sprintIds) {
        TestPlanItem stpi = Tables.TEST_PLAN_ITEM.as("SPRINT_TEST_PLAN_ITEM");
        Table rankedIds = this.dsl.select((SelectField)stpi.TEST_PLAN_ITEM_ID.as("ID"), (SelectField)DSL.rowNumber().over((WindowSpecification)DSL.partitionBy((GroupField[])new GroupField[]{stpi.TCLN_ID, stpi.DATASET_ID}).orderBy(new OrderField[]{stpi.LAST_EXECUTED_ON.desc().nullsLast(), stpi.CREATED_ON.desc(), stpi.TEST_PLAN_ITEM_ID.desc()})).as("ROW_NUMBER")).from((TableLike)Tables.SPRINT_REQ_VERSION).innerJoin((TableLike)stpi).on(Tables.SPRINT_REQ_VERSION.TEST_PLAN_ID.eq((Field)stpi.TEST_PLAN_ID).and(stpi.DELETED.isFalse())).where(Tables.SPRINT_REQ_VERSION.SPRINT_ID.in(sprintIds)).asTable(RANKED_IDS);
        return this.dsl.select((SelectField)rankedIds.field("ID", Long.class)).from((TableLike)rankedIds).where(rankedIds.field("ROW_NUMBER", Integer.TYPE).eq((Object)1)).fetchInto(Long.class);
    }

    @Override
    public Map<ExecutionStatus, Integer> countExecutionStatuses(List<Long> stpiIds) {
        return this.dsl.select((SelectField)Tables.TEST_PLAN_ITEM.EXECUTION_STATUS, (SelectField)DSL.count((Field)Tables.TEST_PLAN_ITEM.EXECUTION_STATUS)).from((TableLike)Tables.TEST_PLAN_ITEM).where(Tables.TEST_PLAN_ITEM.TEST_PLAN_ITEM_ID.in(stpiIds).and(Tables.TEST_PLAN_ITEM.DELETED.isFalse())).groupBy(new GroupField[]{Tables.TEST_PLAN_ITEM.EXECUTION_STATUS}).fetch().intoMap(result -> ExecutionStatus.valueOf((String)((String)result.value1())), Record2::value2);
    }

    @Override
    public Map<TestCaseImportance, Integer> countNonExecutedTestCasesByImportance(List<Long> stpiIds) {
        return this.dsl.select((SelectField)Tables.TEST_CASE.IMPORTANCE, (SelectField)DSL.count((Field)Tables.TEST_CASE.IMPORTANCE)).from((TableLike)Tables.TEST_PLAN_ITEM).innerJoin((TableLike)Tables.TEST_CASE).on(Tables.TEST_PLAN_ITEM.TCLN_ID.eq((Field)Tables.TEST_CASE.TCLN_ID)).innerJoin((TableLike)Tables.TEST_CASE_LIBRARY_NODE).on(Tables.TEST_CASE.TCLN_ID.eq((Field)Tables.TEST_CASE_LIBRARY_NODE.TCLN_ID).and(ConditionsConstants.TCLN_NOT_IN_BIN)).where(Tables.TEST_PLAN_ITEM.TEST_PLAN_ITEM_ID.in(stpiIds)).and(Tables.TEST_PLAN_ITEM.EXECUTION_STATUS.eq((Object)ExecutionStatus.READY.name()).or(Tables.TEST_PLAN_ITEM.EXECUTION_STATUS.eq((Object)ExecutionStatus.RUNNING.name()))).groupBy(new GroupField[]{Tables.TEST_CASE.IMPORTANCE}).fetch().intoMap(result -> TestCaseImportance.valueOf((String)((String)result.value1())), Record2::value2);
    }

    @Override
    public RequirementBoundTestCasesStatistics computeRequirementCoverageStatistics(List<Long> sprintIds) {
        Table subquery = this.dsl.select((SelectField)Tables.SPRINT_REQ_VERSION.SPRINT_REQ_VERSION_ID, (SelectField)DSL.countDistinct((Field)Tables.TEST_PLAN_ITEM.TCLN_ID).as("NB_TESTS")).from((TableLike)Tables.SPRINT_REQ_VERSION).leftJoin((TableLike)Tables.TEST_PLAN_ITEM).on(Tables.SPRINT_REQ_VERSION.TEST_PLAN_ID.eq((Field)Tables.TEST_PLAN_ITEM.TEST_PLAN_ID).and(Tables.TEST_PLAN_ITEM.DELETED.isFalse())).where(Tables.SPRINT_REQ_VERSION.SPRINT_ID.in(sprintIds)).groupBy(new GroupField[]{Tables.SPRINT_REQ_VERSION.SPRINT_REQ_VERSION_ID}).asTable();
        return (RequirementBoundTestCasesStatistics)this.dsl.select((SelectField)DSL.sum((Field)DSL.when((Condition)subquery.field("NB_TESTS", Integer.class).eq((Object)0), (Object)1).otherwise((Object)0)).as(NO_COUNT), (SelectField)DSL.sum((Field)DSL.when((Condition)subquery.field("NB_TESTS", Integer.class).eq((Object)1), (Object)1).otherwise((Object)0)).as(ONE_COUNT), (SelectField)DSL.sum((Field)DSL.when((Condition)subquery.field("NB_TESTS", Integer.class).gt((Object)1), (Object)1).otherwise((Object)0)).as(MULTIPLE_COUNT)).from((TableLike)subquery).fetchOne(r -> new RequirementBoundTestCasesStatistics(Optional.ofNullable((Integer)r.get(NO_COUNT, Integer.class)).orElse(0), Optional.ofNullable((Integer)r.get(ONE_COUNT, Integer.class)).orElse(0), Optional.ofNullable((Integer)r.get(MULTIPLE_COUNT, Integer.class)).orElse(0)));
    }

    @Override
    public Result<Record4<Long, String, String, Integer>> fetchTestInventoryStatisticsForSprints(List<Long> sprintIds) {
        Field<String> nameField = this.buildNameFieldForTestInventoryStatistics(sprintIds);
        return this.dsl.select((SelectField)Tables.SPRINT_REQ_VERSION.SPRINT_REQ_VERSION_ID, nameField, (SelectField)Tables.TEST_PLAN_ITEM.EXECUTION_STATUS.as("STATUS"), (SelectField)DSL.count((Field)Tables.TEST_PLAN_ITEM.TCLN_ID)).from((TableLike)Tables.SPRINT_REQ_VERSION).leftJoin((TableLike)Tables.REQUIREMENT_VERSION).on(Tables.SPRINT_REQ_VERSION.REQ_VERSION_ID.eq((Field)Tables.REQUIREMENT_VERSION.RES_ID)).leftJoin((TableLike)Tables.RESOURCE).on(Tables.SPRINT_REQ_VERSION.REQ_VERSION_ID.eq((Field)Tables.RESOURCE.RES_ID)).innerJoin((TableLike)Tables.SPRINT).on(Tables.SPRINT_REQ_VERSION.SPRINT_ID.eq((Field)Tables.SPRINT.CLN_ID)).innerJoin((TableLike)Tables.CAMPAIGN_LIBRARY_NODE).on(Tables.SPRINT.CLN_ID.eq((Field)Tables.CAMPAIGN_LIBRARY_NODE.CLN_ID)).leftJoin((TableLike)Tables.TEST_PLAN_ITEM).on(Tables.SPRINT_REQ_VERSION.TEST_PLAN_ID.eq((Field)Tables.TEST_PLAN_ITEM.TEST_PLAN_ID).and(Tables.TEST_PLAN_ITEM.DELETED.isFalse())).where(Tables.SPRINT_REQ_VERSION.SPRINT_ID.in(sprintIds)).groupBy(new GroupField[]{Tables.SPRINT_REQ_VERSION.REQ_VERSION_ID, Tables.TEST_PLAN_ITEM.EXECUTION_STATUS, Tables.SPRINT_REQ_VERSION.SPRINT_ID, Tables.SPRINT_REQ_VERSION.SPRINT_REQ_VERSION_ID}).orderBy((OrderField)nameField.asc(), (OrderField)Tables.TEST_PLAN_ITEM.EXECUTION_STATUS.asc()).fetch();
    }

    @Override
    public Result<Record4<Long, String, String, Integer>> fetchTestInventoryStatisticsForSprintGroups(List<Long> sprintIds) {
        Field<String> sprintNameField = this.buildSprintName();
        return this.dsl.select((SelectField)Tables.SPRINT.CLN_ID, sprintNameField, (SelectField)Tables.TEST_PLAN_ITEM.EXECUTION_STATUS.as("STATUS"), (SelectField)DSL.count((Field)Tables.TEST_PLAN_ITEM.TCLN_ID)).from((TableLike)Tables.SPRINT_REQ_VERSION).innerJoin((TableLike)Tables.SPRINT).on(Tables.SPRINT_REQ_VERSION.SPRINT_ID.eq((Field)Tables.SPRINT.CLN_ID)).innerJoin((TableLike)Tables.CAMPAIGN_LIBRARY_NODE).on(Tables.SPRINT.CLN_ID.eq((Field)Tables.CAMPAIGN_LIBRARY_NODE.CLN_ID)).leftJoin((TableLike)Tables.TEST_PLAN_ITEM).on(Tables.SPRINT_REQ_VERSION.TEST_PLAN_ID.eq((Field)Tables.TEST_PLAN_ITEM.TEST_PLAN_ID).and(Tables.TEST_PLAN_ITEM.DELETED.isFalse())).where(Tables.SPRINT_REQ_VERSION.SPRINT_ID.in(sprintIds)).groupBy(new GroupField[]{Tables.SPRINT.CLN_ID, Tables.TEST_PLAN_ITEM.EXECUTION_STATUS}).orderBy((OrderField)sprintNameField.asc(), (OrderField)Tables.TEST_PLAN_ITEM.EXECUTION_STATUS.asc()).fetch();
    }

    private Field<String> buildNameFieldForTestInventoryStatistics(List<Long> sprintIds) {
        boolean isSolitarySprint = sprintIds.size() == 1;
        Field<String> sprintName = this.buildSprintName();
        Field<String> sprintReqNameField = this.buildSprintReqName();
        if (isSolitarySprint) {
            return sprintReqNameField;
        }
        Field trimmedSprintName = DSL.trim((Field)DSL.coalesce(sprintName, (Object)EMPTY_STRING));
        return DSL.when((Condition)trimmedSprintName.eq((Object)EMPTY_STRING), sprintReqNameField).otherwise(DSL.concat((Field[])new Field[]{trimmedSprintName, DSL.inline((String)PATH_SEPARATOR), DSL.coalesce(sprintReqNameField, (Field[])new Field[]{DSL.inline((String)EMPTY_STRING)})}));
    }

    private Field<String> buildSprintName() {
        Field<String> sprintReference = this.trimmedMax((Field<String>)Tables.SPRINT.REFERENCE);
        AggregateFunction sprintDisplayName = DSL.max((Field)Tables.CAMPAIGN_LIBRARY_NODE.NAME);
        return DSL.when((Condition)sprintReference.eq((Object)EMPTY_STRING), (Field)sprintDisplayName).otherwise(DSL.concat((Field[])new Field[]{sprintReference, DSL.inline((String)NAME_REFERENCE_SEPARATOR), sprintDisplayName}));
    }

    private Field<String> buildSprintReqName() {
        Field<String> sprintReqName = this.trimmedMax((Field<String>)Tables.SPRINT_REQ_VERSION.NAME);
        Field<String> sprintReqRef = this.trimmedMax((Field<String>)Tables.SPRINT_REQ_VERSION.REFERENCE);
        Field<String> reqRef = this.trimmedMax((Field<String>)Tables.REQUIREMENT_VERSION.REFERENCE);
        AggregateFunction resourceName = DSL.max((Field)Tables.RESOURCE.NAME);
        return DSL.when((Condition)sprintReqName.eq((Object)EMPTY_STRING).and(sprintReqRef.eq((Object)EMPTY_STRING)), (Field)DSL.when((Condition)reqRef.eq((Object)EMPTY_STRING), (Field)resourceName).otherwise(DSL.concat((Field[])new Field[]{reqRef, DSL.inline((String)NAME_REFERENCE_SEPARATOR), resourceName}))).when(sprintReqRef.eq((Object)EMPTY_STRING), sprintReqName).otherwise(DSL.concat((Field[])new Field[]{sprintReqRef, DSL.inline((String)NAME_REFERENCE_SEPARATOR), sprintReqName}));
    }

    private Field<String> trimmedMax(Field<String> field) {
        return DSL.trim((Field)DSL.coalesce((Field)DSL.max(field), (Object)EMPTY_STRING));
    }
}

