/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.repository.hibernate;

import jakarta.inject.Inject;
import jakarta.persistence.EntityManager;
import jakarta.persistence.PersistenceContext;
import java.sql.Timestamp;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.jooq.DSLContext;
import org.jooq.Field;
import org.jooq.SelectField;
import org.jooq.Table;
import org.jooq.TableLike;
import org.squashtest.tm.domain.requirement.RequirementSyncExtender;
import org.squashtest.tm.jooq.domain.Tables;
import org.squashtest.tm.service.internal.bugtracker.RemoteRequirementAndProjectId;
import org.squashtest.tm.service.internal.repository.CustomRequirementSyncExtenderDao;
import org.squashtest.tm.service.internal.repository.display.utils.ConditionsConstants;

public class RequirementSyncExtenderDaoImpl
implements CustomRequirementSyncExtenderDao {
    @Inject
    DSLContext dsl;
    @PersistenceContext
    private EntityManager entityManager;

    @Override
    public List<RemoteRequirementAndProjectId> findAllRemoteReqIdVerifiedByATestCaseByServerUrl(String serverUrl, Long testCaseId) {
        return this.dsl.select((SelectField)Tables.REQUIREMENT_SYNC_EXTENDER.REMOTE_PROJECT_ID, (SelectField)Tables.REQUIREMENT_SYNC_EXTENDER.REMOTE_REQ_ID).from((TableLike)Tables.REQUIREMENT_SYNC_EXTENDER).leftJoin((TableLike)Tables.REQUIREMENT).on(Tables.REQUIREMENT.RLN_ID.eq((Field)Tables.REQUIREMENT_SYNC_EXTENDER.REQUIREMENT_ID)).leftJoin((TableLike)Tables.REQUIREMENT_VERSION).on(Tables.REQUIREMENT_VERSION.REQUIREMENT_ID.eq((Field)Tables.REQUIREMENT.RLN_ID)).leftJoin((TableLike)Tables.REQUIREMENT_VERSION_COVERAGE).on(Tables.REQUIREMENT_VERSION_COVERAGE.VERIFIED_REQ_VERSION_ID.eq((Field)Tables.REQUIREMENT_VERSION.RES_ID)).leftJoin((TableLike)Tables.TEST_CASE_LIBRARY_NODE).on(Tables.REQUIREMENT_VERSION_COVERAGE.VERIFYING_TEST_CASE_ID.eq((Field)Tables.TEST_CASE_LIBRARY_NODE.TCLN_ID).and(ConditionsConstants.TCLN_NOT_IN_BIN)).leftJoin((TableLike)Tables.TEST_CASE).on(Tables.TEST_CASE.TCLN_ID.eq((Field)Tables.TEST_CASE_LIBRARY_NODE.TCLN_ID)).leftJoin((TableLike)Tables.BUGTRACKER).on(Tables.BUGTRACKER.BUGTRACKER_ID.eq((Field)Tables.REQUIREMENT_SYNC_EXTENDER.SERVER_ID)).leftJoin((TableLike)Tables.THIRD_PARTY_SERVER).on(Tables.BUGTRACKER.BUGTRACKER_ID.eq((Field)Tables.THIRD_PARTY_SERVER.SERVER_ID)).where(Tables.THIRD_PARTY_SERVER.URL.eq((Object)serverUrl)).and(Tables.TEST_CASE.TCLN_ID.eq((Object)testCaseId)).fetchInto(RemoteRequirementAndProjectId.class);
    }

    @Override
    public Map<String, RequirementSyncExtender> findByRemoteKeysAndSyncId(Collection<String> remoteIds, Long remoteSyncId) {
        if (remoteIds == null || remoteIds.isEmpty()) {
            return Collections.emptyMap();
        }
        return this.entityManager.createQuery("select rse from RequirementSyncExtender rse where rse.remoteReqId in :remoteIds and rse.remoteSynchronisation.id = :remoteSynchronisationId", RequirementSyncExtender.class).setParameter("remoteIds", remoteIds).setParameter("remoteSynchronisationId", (Object)remoteSyncId).getResultList().stream().collect(Collectors.toMap(RequirementSyncExtender::getRemoteReqId, Function.identity()));
    }

    @Override
    public Map<String, RequirementSyncExtender> findByRemoteKeysAndProjectId(Collection<String> remoteIds, Long projectId) {
        if (remoteIds == null || remoteIds.isEmpty()) {
            return Collections.emptyMap();
        }
        return this.entityManager.createQuery("select rse from RequirementSyncExtender rse where rse.remoteReqId in :remoteIds and rse.requirement.project.id = :projectId", RequirementSyncExtender.class).setParameter("remoteIds", remoteIds).setParameter("projectId", (Object)projectId).getResultList().stream().collect(Collectors.toMap(RequirementSyncExtender::getRemoteReqId, Function.identity()));
    }

    @Override
    public Long findRequirementIdByIssueKeyAndRemoteSyncId(String issueKey, Long remoteSyncId) {
        return (Long)this.dsl.select((SelectField)Tables.REQUIREMENT_SYNC_EXTENDER.REQUIREMENT_ID).from((TableLike)Tables.REQUIREMENT_SYNC_EXTENDER).where(Tables.REQUIREMENT_SYNC_EXTENDER.REMOTE_REQ_ID.eq((Object)issueKey)).and(Tables.REQUIREMENT_SYNC_EXTENDER.REMOTE_SYNCHRONISATION_ID.eq((Object)remoteSyncId)).fetchOne((Field)Tables.REQUIREMENT_SYNC_EXTENDER.REQUIREMENT_ID);
    }

    @Override
    public void resetRemoteLastUpdated(Long syncId) {
        this.dsl.update((Table)Tables.REQUIREMENT_SYNC_EXTENDER).set((Field)Tables.REQUIREMENT_SYNC_EXTENDER.REMOTE_LAST_UPDATED, (Object)new Timestamp(0L)).where(Tables.REQUIREMENT_SYNC_EXTENDER.REMOTE_SYNCHRONISATION_ID.eq((Object)syncId)).execute();
        this.dsl.update((Table)Tables.SPRINT_REQUIREMENT_SYNC_EXTENDER).set((Field)Tables.SPRINT_REQUIREMENT_SYNC_EXTENDER.REMOTE_LAST_UPDATED, (Object)new Timestamp(0L)).where(Tables.SPRINT_REQUIREMENT_SYNC_EXTENDER.REMOTE_SYNCHRONISATION_ID.eq((Object)syncId)).execute();
    }
}

