/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.repository.display.impl;

import java.util.List;
import org.jooq.DSLContext;
import org.jooq.Field;
import org.jooq.Record1;
import org.jooq.Select;
import org.jooq.SelectConditionStep;
import org.jooq.SelectField;
import org.jooq.TableLike;
import org.springframework.stereotype.Repository;
import org.squashtest.tm.domain.project.AutomationWorkflowType;
import org.squashtest.tm.domain.testcase.SuggestionStatus;
import org.squashtest.tm.domain.testcase.TestCaseAutomatable;
import org.squashtest.tm.domain.testcase.TestCaseStatus;
import org.squashtest.tm.jooq.domain.Tables;
import org.squashtest.tm.service.internal.repository.display.AutomationHelperRequestDisplayDao;
import org.squashtest.tm.service.internal.repository.display.utils.ConditionsConstants;

@Repository
public class AutomationHelperRequestDisplayDaoImpl
implements AutomationHelperRequestDisplayDao {
    private final DSLContext dsl;

    public AutomationHelperRequestDisplayDaoImpl(DSLContext dsl) {
        this.dsl = dsl;
    }

    @Override
    public int countNbTotalCandidates(List<Long> readableProjectIds) {
        return this.dsl.fetchCount((Select)this.dsl.select((SelectField)Tables.TEST_AUTOMATION_CANDIDATE.TEST_AUTOMATION_CANDIDATE_ID).from((TableLike)Tables.TEST_AUTOMATION_CANDIDATE).join((TableLike)Tables.TEST_CASE).on(Tables.TEST_AUTOMATION_CANDIDATE.TEST_CASE_ID.eq((Field)Tables.TEST_CASE.TCLN_ID)).join((TableLike)Tables.TEST_CASE_LIBRARY_NODE).on(Tables.TEST_CASE.TCLN_ID.eq((Field)Tables.TEST_CASE_LIBRARY_NODE.TCLN_ID).and(ConditionsConstants.TCLN_NOT_IN_BIN)).join((TableLike)Tables.PROJECT).on(Tables.TEST_CASE_LIBRARY_NODE.PROJECT_ID.eq((Field)Tables.PROJECT.PROJECT_ID)).where(Tables.PROJECT.PROJECT_ID.in(readableProjectIds).and(Tables.TEST_CASE.TC_STATUS.ne((Object)TestCaseStatus.OBSOLETE.name()))).and(Tables.TEST_CASE.AUTOMATABLE.eq((Object)TestCaseAutomatable.M.name()).or(Tables.TEST_CASE.AUTOMATABLE.ne((Object)TestCaseAutomatable.M.name()).and(Tables.PROJECT.AUTOMATION_WORKFLOW_TYPE.eq((Object)AutomationWorkflowType.NONE.name())))).and(Tables.TEST_AUTOMATION_CANDIDATE.SUGGESTION_STATUS.eq((Object)SuggestionStatus.SUGGESTED.name())));
    }

    @Override
    public int countNbTotalEligibleTests(List<Long> readableProjectIds) {
        SelectConditionStep<Record1<Long>> manualEligibleTestIdsNotIn = this.buildManualEligibleTestIds(readableProjectIds);
        SelectConditionStep<Record1<Long>> manualEligibleTestIdsUnion = this.buildManualEligibleTestIds(readableProjectIds);
        SelectConditionStep approvedTests = this.dsl.select((SelectField)Tables.TEST_CASE.TCLN_ID).from((TableLike)Tables.TEST_AUTOMATION_CANDIDATE).join((TableLike)Tables.TEST_CASE).on(Tables.TEST_AUTOMATION_CANDIDATE.TEST_CASE_ID.eq((Field)Tables.TEST_CASE.TCLN_ID)).innerJoin((TableLike)Tables.TEST_CASE_LIBRARY_NODE).on(Tables.TEST_CASE.TCLN_ID.eq((Field)Tables.TEST_CASE_LIBRARY_NODE.TCLN_ID).and(ConditionsConstants.TCLN_NOT_IN_BIN)).join((TableLike)Tables.PROJECT).on(Tables.TEST_CASE_LIBRARY_NODE.PROJECT_ID.eq((Field)Tables.PROJECT.PROJECT_ID)).where(Tables.TEST_AUTOMATION_CANDIDATE.SUGGESTION_STATUS.eq((Object)SuggestionStatus.APPROVED.name()).and(Tables.TEST_CASE.AUTOMATED_TEST_REFERENCE.isNull()).and(Tables.TEST_CASE.TC_STATUS.ne((Object)TestCaseStatus.OBSOLETE.name())).and(Tables.PROJECT.PROJECT_ID.in(readableProjectIds)).and(Tables.TEST_CASE.TCLN_ID.notIn(manualEligibleTestIdsUnion)));
        return this.dsl.fetchCount((Select)manualEligibleTestIdsNotIn.unionAll((Select)approvedTests));
    }

    private SelectConditionStep<Record1<Long>> buildManualEligibleTestIds(List<Long> projectIds) {
        return this.dsl.select((SelectField)Tables.TEST_CASE.TCLN_ID).from((TableLike)Tables.TEST_CASE).join((TableLike)Tables.AUTOMATION_REQUEST).on(Tables.TEST_CASE.AUTOMATION_REQUEST_ID.eq((Field)Tables.AUTOMATION_REQUEST.AUTOMATION_REQUEST_ID)).join((TableLike)Tables.TEST_CASE_LIBRARY_NODE).on(Tables.TEST_CASE.TCLN_ID.eq((Field)Tables.TEST_CASE_LIBRARY_NODE.TCLN_ID).and(ConditionsConstants.TCLN_NOT_IN_BIN)).join((TableLike)Tables.PROJECT).on(Tables.TEST_CASE_LIBRARY_NODE.PROJECT_ID.eq((Field)Tables.PROJECT.PROJECT_ID)).where(Tables.TEST_CASE.AUTOMATABLE.eq((Object)TestCaseAutomatable.Y.name()).and(Tables.PROJECT.AUTOMATION_WORKFLOW_TYPE.ne((Object)AutomationWorkflowType.NONE.name())).and(Tables.TEST_CASE.AUTOMATED_TEST_REFERENCE.isNull()).and(Tables.TEST_CASE.TC_STATUS.ne((Object)TestCaseStatus.OBSOLETE.name())).and(Tables.PROJECT.PROJECT_ID.in(projectIds)));
    }
}

